/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.ioc.loader;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.impl.NutIoc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.annotation.IocBy;
import org.nutz.plugins.ioc.loader.chain.IocSetup;
import org.nutz.plugins.ioc.loader.chain.IocSetupBuilder;

public final class ThreadIocLoader {
    private static final Log log = Logs.get();
    private static final String MAIN_MODULE = "ioc.main.module";
    private static final String IOC_BY = "ioc.by";
    private static final String LOADER_CLASSES = "ioc.loader.classes";
    private static final String SETUP_FIRST = "ioc.setup.first";
    private static final String SETUP_LAST = "ioc.setup.last";
    private static final String IOC_COMBO_LOADER = "ioc.combo.loader";
    private static final String PROPERTIES_NAME = "comboIocLoader.properties";
    private static final String SEPARATOR_CHAR = ",";
    private static PropertiesProxy config;
    private static IocSetup iocSetupCopy;
    private static final ThreadIocLoader lock_get;
    public static Map<String, Ioc> iocs;
    private static Ioc mainIoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadIocLoader getIoc() {
        if (mainIoc == null) {
            try {
                ThreadIocLoader threadIocLoader = lock_get;
                synchronized (threadIocLoader) {
                    if (mainIoc == null) {
                        if (Mvcs.getServletContext() == null) {
                            mainIoc = new NutIoc(ThreadIocLoader.getIocLoader());
                            log.info((Object)"<<<--- get Not Mvc Ioc --->>>");
                        } else {
                            mainIoc = Mvcs.getIoc();
                            if (mainIoc == null) {
                                mainIoc = Mvcs.ctx().getDefaultIoc();
                            }
                            log.info((Object)"<<<--- get Mvc Ioc --->>>");
                        }
                        iocs.put("ioc", mainIoc);
                    }
                }
                ThreadIocLoader.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return lock_get;
    }

    private static void init() throws Exception {
        String iocComboLoader = config.get(IOC_COMBO_LOADER);
        if (Strings.isNotBlank((CharSequence)iocComboLoader)) {
            String[] iocComboLoaders = Strings.splitIgnoreBlank((String)iocComboLoader, (String)SEPARATOR_CHAR);
            for (String icl : iocComboLoaders) {
                IocLoader loader = (IocLoader)Class.forName(icl).newInstance();
                iocs.put(icl, (Ioc)new NutIoc((IocLoader)new ComboIocLoader(new IocLoader[]{loader})));
            }
        }
        if (iocSetupCopy == null) {
            String iocSetupLastStr;
            IocSetupBuilder b = IocSetupBuilder.create();
            String iocSetupFirstStr = config.get(SETUP_FIRST);
            if (Strings.isNotBlank((CharSequence)iocSetupFirstStr)) {
                String[] iocSetupFirsts;
                for (String isf : iocSetupFirsts = Strings.splitIgnoreBlank((String)iocSetupFirstStr, (String)SEPARATOR_CHAR)) {
                    IocSetup is = (IocSetup)mainIoc.get(Class.forName(isf));
                    b.addFirst(is);
                }
            }
            if (Strings.isNotBlank((CharSequence)(iocSetupLastStr = config.get(SETUP_LAST)))) {
                String[] iocSetupLasts;
                for (String isl : iocSetupLasts = Strings.splitIgnoreBlank((String)iocSetupLastStr, (String)SEPARATOR_CHAR)) {
                    IocSetup is = (IocSetup)mainIoc.get(Class.forName(isl));
                    b.addLast(is);
                }
            }
            iocSetupCopy = b.build();
        }
        iocSetupCopy.init(iocs);
        List loaderClasses = config.getList(LOADER_CLASSES, SEPARATOR_CHAR);
        for (String loaderClass : loaderClasses) {
            mainIoc.get(Class.forName(loaderClass));
        }
    }

    private static void _depose() throws Exception {
        iocSetupCopy.destroy(iocs);
    }

    private static IocLoader getIocLoader() throws Exception {
        return new ComboIocLoader(ThreadIocLoader.getIocConfigure());
    }

    private static Class<?> getMainModule() throws Exception {
        String mainModule = config.get(MAIN_MODULE);
        if (Strings.isNotBlank((CharSequence)mainModule)) {
            return Class.forName(config.get(MAIN_MODULE));
        }
        return null;
    }

    private static String[] getIocConfigure() throws Exception {
        Class<?> klass = ThreadIocLoader.getMainModule();
        String iocByStr = config.get(IOC_BY);
        String[] iocBys = null;
        if (Strings.isNotBlank((CharSequence)iocByStr)) {
            iocBys = Strings.splitIgnoreBlank((String)iocByStr, (String)SEPARATOR_CHAR);
        }
        if (klass == null) {
            return iocBys;
        }
        IocBy iocBy = klass.getAnnotation(IocBy.class);
        if (iocBy == null) {
            return iocBys;
        }
        return iocBy.args();
    }

    public void depose() throws Exception {
        try {
            ThreadIocLoader._depose();
        }
        finally {
            for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
                entry.getValue().depose();
            }
        }
    }

    public <T> T get(Class<T> type, String name) throws IocException {
        IocException ex = null;
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            try {
                return (T)entry.getValue().get(type, name);
            }
            catch (IocException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public <T> T get(Class<T> type) throws IocException {
        IocException ex = null;
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            try {
                return (T)entry.getValue().get(type);
            }
            catch (IocException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public boolean has(String name) throws IocException {
        IocException ex = null;
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            try {
                boolean bl = entry.getValue().has(name);
                if (!bl) continue;
                return true;
            }
            catch (IocException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return false;
    }

    public String[] getNames() {
        LinkedList<String[]> nameList = new LinkedList<String[]>();
        int arrLen = 0;
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            String[] names = entry.getValue().getNames();
            nameList.add(names);
            arrLen += names.length;
        }
        int destPos = 0;
        String[] nameArr = new String[arrLen];
        for (String[] names : nameList) {
            System.arraycopy(names, 0, nameArr, destPos += names.length, names.length);
        }
        return nameArr;
    }

    public void reset() {
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            entry.getValue().reset();
        }
    }

    public String[] getNamesByType(Class<?> klass) {
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            String[] t = entry.getValue().getNamesByType(klass);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public <K> K getByType(Class<K> klass) {
        for (Map.Entry<String, Ioc> entry : iocs.entrySet()) {
            Object k = entry.getValue().getByType(klass);
            if (k == null) continue;
            return (K)k;
        }
        return null;
    }

    static {
        lock_get = new ThreadIocLoader();
        iocs = new LinkedHashMap<String, Ioc>();
        config = new PropertiesProxy(new String[]{PROPERTIES_NAME});
    }
}

