/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.props;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.meta.IocObject;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mapl.Mapl;
import org.nutz.mvc.adaptor.ParamExtractor;
import org.nutz.mvc.adaptor.Params;
import org.nutz.mvc.adaptor.injector.ObjectNaviNode;

public class PropertiesIocLoader
extends PropertiesProxy
implements IocLoader {
    private static Log log = Logs.get();
    protected Map<String, IocObject> objs = new HashMap<String, IocObject>();

    public PropertiesIocLoader() {
    }

    public PropertiesIocLoader(String ... paths) {
        super(paths);
        log.debug((Object)("beans = " + this.objs.keySet()));
    }

    public String[] getName() {
        this.reload();
        return this.objs.keySet().toArray(new String[this.objs.size()]);
    }

    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        this.reload();
        return this.objs.get(name);
    }

    public boolean has(String name) {
        this.reload();
        return this.objs.containsKey(name);
    }

    public void reload() {
        ArrayList<String> beanNames = new ArrayList<String>();
        for (String key : this.keys()) {
            String[] tmp;
            if (!key.startsWith("ioc.") || key.length() < 5 || (tmp = key.split("[.]")).length != 3 || !tmp[2].equals("type") && !tmp[2].equals("factory")) continue;
            beanNames.add(tmp[1]);
        }
        for (String beanName : beanNames) {
            ObjectNaviNode no = new ObjectNaviNode();
            String prefix = "ioc." + beanName + ".";
            String pre = "";
            ParamExtractor pe = Params.makeParamExtractor(null, (Object)this.toMap());
            for (Object name : pe.keys()) {
                String na = (String)name;
                if (!na.startsWith(prefix)) continue;
                no.put(pre + na, pe.extractor(na));
            }
            Object model = no.get();
            Object re = Mapl.maplistToObj(((Map)model).get(beanName), IocObject.class);
            this.objs.put(beanName, (IocObject)re);
        }
    }
}

