/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.ioc.loader.chain;

import java.util.List;
import java.util.Map;
import org.nutz.ioc.Ioc2;
import org.nutz.plugins.ioc.loader.chain.IocSetup;

public class ImmutableIocSetup
implements IocSetup {
    private final IocSetup[] IocSetups;

    public ImmutableIocSetup(IocSetup ... setups) {
        if (setups != null) {
            int l = setups.length;
            this.IocSetups = new IocSetup[l];
            System.arraycopy(setups, 0, this.IocSetups, 0, l);
        } else {
            this.IocSetups = new IocSetup[0];
        }
    }

    public ImmutableIocSetup(List<IocSetup> setups) {
        if (setups != null) {
            int l = setups.size();
            this.IocSetups = setups.toArray(new IocSetup[l]);
        } else {
            this.IocSetups = new IocSetup[0];
        }
    }

    @Override
    public void init(Map<String, Ioc2> iocs) {
        for (IocSetup setup : this.IocSetups) {
            setup.init(iocs);
        }
    }

    @Override
    public void destroy(Map<String, Ioc2> iocs) {
        for (IocSetup setup : this.IocSetups) {
            setup.destroy(iocs);
        }
    }
}

