/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.ioc.loader.dao;

import java.util.List;
import java.util.Map;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.entity.Record;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.json.JsonLoader;
import org.nutz.ioc.meta.IocObject;
import org.nutz.json.Json;
import org.nutz.lang.Lang;

public class DaoIocLoader
extends JsonLoader {
    private static final String IOC_TABLE = "ioc.table";
    private static final String IOC_NAME_FIELD = "ioc.name.field";
    private static final String IOC_VALUE_FIELD = "ioc.value.field";
    private static final String PROPERTIES_NAME = "daoIocLoader.properties";
    protected String name = "dao";
    protected String table = "t_iocbean";
    protected String nameField = "nm";
    protected String valueField = "val";
    @Inject
    protected Dao dao;

    public DaoIocLoader() {
        PropertiesProxy config = new PropertiesProxy(new String[]{PROPERTIES_NAME});
        this.table = config.get(IOC_TABLE, this.table);
        this.nameField = config.get(IOC_NAME_FIELD, this.nameField);
        this.valueField = config.get(IOC_VALUE_FIELD, this.valueField);
    }

    public DaoIocLoader(String ... args) {
        if (args.length > 0) {
            this.name = args[0];
            if (args.length > 1) {
                this.table = args[1];
                if (args.length > 2) {
                    this.nameField = args[2];
                    if (args.length > 3) {
                        this.valueField = args[3];
                    }
                }
            }
        }
    }

    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        if (this.getMap().containsKey(name)) {
            return super.load(loading, name);
        }
        Record re = this.dao.fetch(this.table, (Condition)Cnd.where((String)this.nameField, (String)"=", (Object)name));
        if (re == null) {
            throw new ObjectLoadException("Object '" + name + "' without define!");
        }
        Map map = Json.fromJsonAsMap(Object.class, (CharSequence)re.getString(this.valueField));
        try {
            this.getMap().put(name, map);
            return super.load(loading, name);
        }
        catch (Throwable e) {
            this.getMap().remove(name);
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    public boolean has(String name) {
        return 0 != this.dao.count(this.table, (Condition)Cnd.where((String)this.nameField, (String)"=", (Object)name));
    }

    public String[] getName() {
        List res = this.dao.query(this.table, null);
        if (res == null || res.isEmpty()) {
            return new String[0];
        }
        String[] names = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            names[i] = ((Record)res.get(i)).getString(this.nameField);
        }
        return names;
    }
}

