/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.sigar.gather;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.nutz.lang.util.NutMap;

public class DISKGather {
    private String userHome = System.getProperty("user.home");
    private String tempDir = System.getProperty("java.io.tmpdir");
    List<NutMap> details = new ArrayList<NutMap>();
    private FileSystem config;
    private FileSystemUsage stat;

    public static DISKGather gather(Sigar sigar) {
        DISKGather data = new DISKGather();
        try {
            FileSystem[] fsArr;
            FileSystem[] fileSystemArray = fsArr = sigar.getFileSystemList();
            int n = fsArr.length;
            int n2 = 0;
            while (n2 < n) {
                FileSystem fs = fileSystemArray[n2];
                NutMap temp = new NutMap();
                temp.addv("fileSystem", (Object)fs);
                temp.addv("usage", (Object)sigar.getFileSystemUsage(fs.getDirName()));
                temp.addv("fileInfo", (Object)sigar.getFileInfo(fs.getDirName()));
                data.details.add(temp);
                ++n2;
            }
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        return data;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public void setUserHome(String userHome) {
        this.userHome = userHome;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public List<NutMap> getDetails() {
        return this.details;
    }

    public void setDetails(List<NutMap> details) {
        this.details = details;
    }

    public FileSystem getConfig() {
        return this.config;
    }

    public void setConfig(FileSystem config) {
        this.config = config;
    }

    public FileSystemUsage getStat() {
        return this.stat;
    }

    public void setStat(FileSystemUsage stat) {
        this.stat = stat;
    }
}

