/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.sigar.gather;

import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.nutz.lang.util.NutMap;
import org.nutz.plugins.sigar.gather.CPUGather;
import org.nutz.plugins.sigar.gather.DISKGather;
import org.nutz.plugins.sigar.gather.MemoryGather;
import org.nutz.plugins.sigar.gather.NetInterfaceGather;
import org.nutz.plugins.sigar.gather.OSGather;

public class Gathers {
    public static NutMap all() throws SigarException, InterruptedException {
        Sigar sigar = new Sigar();
        NutMap data = NutMap.NEW();
        CPUGather cpu = CPUGather.gather(sigar);
        data.put((Object)"cpu", (Object)cpu);
        data.put((Object)"cpuUsage", (Object)(cpu.getPerc().getCombined() * 100.0));
        MemoryGather memory = MemoryGather.gather(sigar);
        data.put((Object)"memory", (Object)memory);
        data.put((Object)"ramUasge", (Object)memory.getMem().getUsedPercent());
        data.put((Object)"jvmUasge", (Object)memory.getJvm().getUsedPercent());
        if (memory.getSwap().getTotal() == 0L) {
            data.put((Object)"swapUasge", (Object)0);
        } else {
            data.put((Object)"swapUasge", (Object)(memory.getSwap().getUsed() * 100L / memory.getSwap().getTotal()));
        }
        data.put((Object)"disk", (Object)DISKGather.gather(sigar));
        data.put((Object)"network", (Object)NetInterfaceGather.gather(sigar));
        data.put((Object)"system", (Object)OSGather.init(sigar));
        return data;
    }
}

