/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.sigar.gather;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.sigar.NetInfo;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.nutz.json.JsonField;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NetInterfaceGather {
    private static String ip;
    private static String hostName;
    @JsonField(ignore=true)
    private String activeCard;
    @JsonField(ignore=true)
    private static Log log;
    private NetInterfaceConfig config;
    private NetInterfaceStat stat;
    private NetInfo info;
    private long rxbps;
    private long txbps;
    private List<NutMap> detail = new ArrayList<NutMap>();

    static {
        log = Logs.getLog(NetInterfaceGather.class);
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error((Object)e);
        }
    }

    public static NetInterfaceGather gather(final Sigar sigar) {
        final NetInterfaceGather data = new NetInterfaceGather();
        try {
            String active = data.fetActiveNetInterfaceName(sigar);
            data.config = sigar.getNetInterfaceConfig(active);
            data.info = sigar.getNetInfo();
            data.stat = sigar.getNetInterfaceStat(active);
            long start = System.currentTimeMillis();
            long rxBytesStart = data.stat.getRxBytes();
            long txBytesStart = data.stat.getTxBytes();
            Thread.sleep(1000L);
            long end = System.currentTimeMillis();
            NetInterfaceStat statEnd = sigar.getNetInterfaceStat(active);
            long rxBytesEnd = statEnd.getRxBytes();
            long txBytesEnd = statEnd.getTxBytes();
            data.rxbps = (rxBytesEnd - rxBytesStart) * 8L / (end - start) * 1000L;
            data.txbps = (txBytesEnd - txBytesStart) * 8L / (end - start) * 1000L;
            Lang.each((Object)sigar.getNetInterfaceList(), (Each)new Each<String>(){

                public void invoke(int arg0, String name, int arg2) throws ExitLoop, ContinueLoop, LoopException {
                    NutMap temp = NutMap.NEW();
                    try {
                        temp.addv("stat", (Object)sigar.getNetInterfaceStat(name));
                        temp.addv("config", (Object)sigar.getNetInterfaceConfig(name));
                    }
                    catch (SigarException e) {
                        e.printStackTrace();
                    }
                    data.detail.add(temp);
                }
            });
        }
        catch (SigarException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return data;
    }

    private String fetActiveNetInterfaceName(final Sigar sigar) throws SigarException {
        Lang.each((Object)sigar.getNetInterfaceList(), (Each)new Each<String>(){

            public void invoke(int arg0, String name, int arg2) throws ExitLoop, ContinueLoop, LoopException {
                try {
                    if (Strings.equals((String)ip, (String)sigar.getNetInterfaceConfig(name).getAddress())) {
                        NetInterfaceGather.this.activeCard = name;
                        throw new ExitLoop();
                    }
                }
                catch (SigarException e) {
                    e.printStackTrace();
                }
            }
        });
        return this.activeCard;
    }

    public static String getIp() {
        return ip;
    }

    public static void setIp(String ip) {
        NetInterfaceGather.ip = ip;
    }

    public static String getHostName() {
        return hostName;
    }

    public static void setHostName(String hostName) {
        NetInterfaceGather.hostName = hostName;
    }

    public NetInterfaceConfig getConfig() {
        return this.config;
    }

    public long getRxbps() {
        return this.rxbps;
    }

    public void setRxbps(long rxbps) {
        this.rxbps = rxbps;
    }

    public long getTxbps() {
        return this.txbps;
    }

    public void setTxbps(long txbps) {
        this.txbps = txbps;
    }

    public void setConfig(NetInterfaceConfig config) {
        this.config = config;
    }

    public NetInterfaceStat getStat() {
        return this.stat;
    }

    public void setStat(NetInterfaceStat stat) {
        this.stat = stat;
    }

    public NetInfo getInfo() {
        return this.info;
    }

    public void setInfo(NetInfo info) {
        this.info = info;
    }

    public List<NutMap> getDetail() {
        return this.detail;
    }

    public void setDetail(List<NutMap> detail) {
        this.detail = detail;
    }
}

