/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugin.spring.boot.service;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.FieldFilter;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.Record;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.cri.Exps;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Logs;
import org.nutz.plugin.spring.boot.service.entity.DataBaseEntity;
import org.nutz.plugin.spring.boot.service.entity.PageredData;
import org.nutz.service.IdNameEntityService;

public class BaseService<T extends DataBaseEntity>
extends IdNameEntityService<T> {
    private int defaultPageSize = 15;

    @Resource(type=Dao.class)
    public void init(Dao dao) {
        super.setDao(dao);
    }

    public T save(T t) {
        return (T)((DataBaseEntity)this.dao().insert(t));
    }

    public T save(T obj, FieldFilter filter) {
        return (T)((DataBaseEntity)this.dao().insert(obj, filter));
    }

    public void save(String tableName, Chain chain) {
        this.dao().insert(tableName, chain);
    }

    public void save(Class<?> classOfT, Chain chain) {
        this.dao().insert(classOfT, chain);
    }

    public T insert(T t, boolean ignoreNull, boolean ignoreZero, boolean ignoreBlankStr) {
        return (T)((DataBaseEntity)this.dao().insert(t, ignoreNull, ignoreZero, ignoreBlankStr));
    }

    public T insertWith(T obj, String regex) {
        return (T)((DataBaseEntity)this.dao().insertWith(obj, regex));
    }

    public T insertLinks(T obj, String regex) {
        return (T)((DataBaseEntity)this.dao().insertLinks(obj, regex));
    }

    public T insertRelation(T obj, String regex) {
        return (T)((DataBaseEntity)this.dao().insertRelation(obj, regex));
    }

    public List<T> queryAll() {
        return this.query(null);
    }

    public List<T> query(Condition condition, int currentPage, int pageSize) {
        if (condition == null) {
            condition = Cnd.orderBy().desc("id");
        }
        Pager pager = this.dao().createPager(currentPage, pageSize);
        return this.dao().query(this.getEntityClass(), condition, pager);
    }

    public List<T> query(Condition condition, int currentPage) {
        return this.query(condition, currentPage, this.defaultPageSize);
    }

    public T findByField(String field, Object value) {
        return (T)((DataBaseEntity)this.dao().fetch(this.getEntityClass(), (Condition)Cnd.where((String)field, (String)"=", (Object)value)));
    }

    public Record fetch(Sql sql) {
        sql.setCallback(Sqls.callback.record());
        this.dao().execute(sql);
        return (Record)sql.getObject(Record.class);
    }

    public List<Record> search(Sql sql) {
        sql.setCallback(Sqls.callback.records());
        this.dao().execute(sql);
        return sql.getList(Record.class);
    }

    public List<NutMap> searchAsMap(Sql sql) {
        sql.setCallback(Sqls.callback.maps());
        this.dao().execute(sql);
        return sql.getList(NutMap.class);
    }

    public T fetchObj(Sql sql) {
        sql.setCallback(Sqls.callback.entity());
        sql.setEntity(this.dao().getEntity(this.getEntityClass()));
        this.dao().execute(sql);
        return (T)((DataBaseEntity)sql.getObject(this.getEntityClass()));
    }

    public List<T> searchObj(Sql sql) {
        sql.setCallback(Sqls.callback.entities());
        sql.setEntity(this.dao().getEntity(this.getEntityClass()));
        this.dao().execute(sql);
        return sql.getList(this.getEntityClass());
    }

    public int deleteOrUpdate(Sql sql) {
        sql.setCallback(Sqls.callback.integer());
        this.dao().execute(sql);
        return sql.getUpdateCount();
    }

    public Sql create(String key) {
        return this.dao().sqls().create(key);
    }

    public PageredData<T> searchByPage(int page) {
        return this.searchByPage(page, null);
    }

    public PageredData<T> searchByPage(int page, Condition condition) {
        return this.searchByPage(page, this.defaultPageSize, condition);
    }

    public PageredData<T> searchByPage(int page, int pageSize, Condition condition) {
        PageredData data = new PageredData();
        Pager pager = new Pager(page, pageSize);
        data.setDataList(this.query(condition, pager));
        pager.setRecordCount(this.count(condition));
        data.setPager(pager);
        return data;
    }

    public PageredData<T> searchByKeyAndPage(String key, int page, Cnd cnd, String ... fields) {
        return this.searchByKeyAndPage(key, page, this.defaultPageSize, cnd, fields);
    }

    public PageredData<T> searchByKeyAndPage(String key, int page, int pageSize, Cnd cnd, String ... fields) {
        String searchKey = String.format("%%%s%%", key);
        if (cnd == null) {
            cnd = Cnd.NEW();
        }
        SqlExpressionGroup expressionGroup = Exps.begin();
        int index = 0;
        for (String field : fields) {
            if (index == 0) {
                expressionGroup.and(field, "like", (Object)searchKey);
            } else {
                expressionGroup.or(field, "like", (Object)searchKey);
            }
            ++index;
        }
        return this.searchByPage(page, pageSize, (Condition)cnd.and((SqlExpression)expressionGroup));
    }

    public PageredData<T> searchByKeyAndPage(String key, int page, int pageSize, String ... fields) {
        return this.searchByKeyAndPage(key, page, pageSize, (Cnd)null, fields);
    }

    public PageredData<T> searchByKeyAndPage(String key, int page, String ... fields) {
        return this.searchByKeyAndPage(key, page, this.defaultPageSize, (Cnd)null, fields);
    }

    public int update(T obj) {
        return this.dao().update(obj);
    }

    public int updateFields(T obj, String regex) {
        return this.dao().update(obj, regex);
    }

    public int updateIgnoreNull(T obj) {
        return this.dao().updateIgnoreNull(obj);
    }

    public T updateWith(T obj, String regex) {
        return (T)((DataBaseEntity)this.dao().updateWith(obj, regex));
    }

    public T updateLinks(T obj, String regex) {
        return (T)((DataBaseEntity)this.dao().updateLinks(obj, regex));
    }

    public boolean update(T t, String ... fields) {
        return this.dao().update(t.getClass(), this.makeChain(t, fields), this.getCnd(t)) == 1;
    }

    private Chain makeChain(T t, String[] fields) {
        NutMap map = NutMap.NEW();
        for (String field : fields) {
            MappingField mf = this.getEntity().getField(field);
            map.put((Object)mf.getColumnName(), mf.getValue(t));
        }
        return Chain.from((Object)map);
    }

    private Condition getCnd(T t) {
        Mirror clazzMirror = Mirror.me(t);
        Field idField = null;
        try {
            idField = clazzMirror.getField(Id.class);
        }
        catch (NoSuchFieldException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        String fieldName = idField.getName();
        Object value = clazzMirror.getValue(t, idField);
        return Cnd.where((String)fieldName, (String)"=", (Object)value);
    }

    public int update(T t, Condition cnd, String ... fields) {
        Arrays.sort(fields);
        NutMap map = Lang.map((String)Json.toJson(t));
        NutMap data = NutMap.NEW();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (Arrays.binarySearch(fields, key) < 0) continue;
            data.put((Object)key, map.get((Object)key));
        }
        try {
            return this.dao().update(t.getClass(), Chain.from((Object)data), cnd);
        }
        catch (Exception e) {
            Logs.get().error((Object)e);
            return 0;
        }
    }

    public int update(T t, Condition cnd) {
        try {
            return this.dao().update(t.getClass(), Chain.from(t), cnd);
        }
        catch (Exception e) {
            Logs.get().error((Object)e);
            return 0;
        }
    }

    public int clear() {
        return this.clear(null);
    }

    public T clearLinks(T obj, String regex) {
        return (T)((DataBaseEntity)this.dao().clearLinks(obj, regex));
    }

    public int delete(T obj) {
        return this.dao().delete(obj);
    }

    public int deleteWith(T obj, String regex) {
        return this.dao().deleteWith(obj, regex);
    }

    public int deleteLinks(T obj, String regex) {
        return this.dao().deleteLinks(obj, regex);
    }
}

