/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.validation.annotation;

import java.lang.reflect.Field;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.plugins.validation.Errors;
import org.nutz.plugins.validation.Validation;
import org.nutz.plugins.validation.ValidationUtils;
import org.nutz.plugins.validation.annotation.Validations;

public class AnnotationValidation
implements Validation {
    @Override
    public Errors validate(Object target) {
        Errors errors = new Errors();
        this.validate(target, errors);
        return errors;
    }

    @Override
    public void validate(Object target, Errors errors) {
        Field[] fields;
        if (null == target) {
            return;
        }
        Mirror mirror = Mirror.me((Object)target);
        for (Field field : fields = mirror.getFields(Validations.class)) {
            Validations vals = field.getAnnotation(Validations.class);
            String errMsg = vals.errorMsg();
            try {
                Object value = mirror.getValue(target, field);
                if (vals.required() && !ValidationUtils.required(field.getName(), value, errMsg, errors) || vals.account() && !ValidationUtils.account(field.getName(), value, errMsg, errors) || vals.mobile() && !ValidationUtils.mobile(field.getName(), value, errMsg, errors) || vals.email() && !ValidationUtils.email(field.getName(), value, errMsg, errors) || vals.qq() && !ValidationUtils.qq(field.getName(), value, errMsg, errors) || vals.chinese() && !ValidationUtils.chinese(field.getName(), value, errMsg, errors) || vals.post() && !ValidationUtils.post(field.getName(), value, errMsg, errors) || !Strings.isBlank((CharSequence)vals.regex()) && !ValidationUtils.regex(field.getName(), value, vals.regex(), errMsg, errors) || vals.strLen().length > 0 && !ValidationUtils.stringLength(field.getName(), value, vals.strLen(), errMsg, errors)) continue;
                if (!Strings.isBlank((CharSequence)vals.repeat())) {
                    Object repeatValue = mirror.getGetter(vals.repeat()).invoke(target, new Object[0]);
                    if (!ValidationUtils.repeat(field.getName(), value, repeatValue, errMsg, errors)) continue;
                }
                if (!(vals.limit().length > 0 && !ValidationUtils.limit(field.getName(), value, vals.limit(), errMsg, errors) || !Strings.isBlank((CharSequence)vals.el()) && !ValidationUtils.el(field.getName(), value, vals.el(), errMsg, errors) || Strings.isBlank((CharSequence)vals.custom())) && ValidationUtils.custom(field.getName(), target, vals.custom(), errMsg, errors)) continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

