/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.validation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.el.El;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.reflect.FastClassFactory;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.lang.util.Context;
import org.nutz.plugins.validation.Errors;

public abstract class ValidationUtils {
    private static final String mobile_regex = "1\\d{10}";
    private static final String email_regex = "^([\\w-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([\\w-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";
    private static final String chinese_regex = "[\u4e00-\u9fa5]+";
    private static final String qq_regex = "[1-9][0-9]{4,}";
    private static final String post_regex = "[1-9]\\d{5}(?!\\d)";
    private static final String account_regex = "^[a-zA-Z][a-zA-Z0-9_]+";
    protected static Map<String, FastMethod> customMethods = new HashMap<String, FastMethod>();

    public static boolean required(String fieldName, Object target, String errorMsg, Errors errors) {
        if (null == target) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        if (target instanceof String && Strings.isBlank((CharSequence)((String)target))) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        return true;
    }

    public static boolean regex(String fieldName, Object target, String regex, String errorMsg, Errors errors) {
        if (null == target || !(target instanceof String)) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        Matcher m = Pattern.compile(regex, 40).matcher((String)target);
        if (!m.matches()) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        return true;
    }

    public static boolean mobile(String fieldName, Object target, String errorMsg, Errors errors) {
        return ValidationUtils.regex(fieldName, target, mobile_regex, errorMsg, errors);
    }

    public static boolean post(String fieldName, Object target, String errorMsg, Errors errors) {
        return ValidationUtils.regex(fieldName, target, post_regex, errorMsg, errors);
    }

    public static boolean email(String fieldName, Object target, String errorMsg, Errors errors) {
        return ValidationUtils.regex(fieldName, target, email_regex, errorMsg, errors);
    }

    public static boolean chinese(String fieldName, Object target, String errorMsg, Errors errors) {
        return ValidationUtils.regex(fieldName, target, chinese_regex, errorMsg, errors);
    }

    public static boolean qq(String fieldName, Object target, String errorMsg, Errors errors) {
        return ValidationUtils.regex(fieldName, target, qq_regex, errorMsg, errors);
    }

    public static boolean account(String fieldName, Object target, String errorMsg, Errors errors) {
        return ValidationUtils.regex(fieldName, target, account_regex, errorMsg, errors);
    }

    public static boolean repeat(String fieldName, Object target, Object repeatValue, String errorMsg, Errors errors) {
        if (null != target && !target.equals(repeatValue)) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        if (null != repeatValue && !repeatValue.equals(target)) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        return true;
    }

    public static boolean stringLength(String fieldName, Object target, int[] interval, String errorMsg, Errors errors) {
        int minLength = 0;
        int maxLength = Integer.MAX_VALUE;
        if (interval.length >= 1) {
            minLength = interval[0];
        }
        if (interval.length >= 2) {
            maxLength = interval[1];
        }
        return ValidationUtils.stringLength(fieldName, target, minLength, maxLength, errorMsg, errors);
    }

    public static boolean stringLength(String fieldName, Object target, int minLength, int maxLength, String errorMsg, Errors errors) {
        if (null == target || !(target instanceof String)) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        String str = (String)target;
        if (str.length() < minLength || str.length() > maxLength) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        return true;
    }

    public static boolean limit(String fieldName, Object target, double[] interval, String errorMsg, Errors errors) {
        double minLength = 0.0;
        double maxLength = Double.MAX_VALUE;
        if (interval.length >= 1) {
            minLength = interval[0];
        }
        if (interval.length >= 2) {
            maxLength = interval[1];
        }
        return ValidationUtils.limit(fieldName, target, minLength, maxLength, errorMsg, errors);
    }

    public static boolean limit(String fieldName, Object target, double minValue, double maxValue, String errorMsg, Errors errors) {
        if (null == target) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        Double d = null;
        if (target instanceof Double) {
            d = (Double)target;
        } else if (target instanceof Integer) {
            d = ((Integer)target).doubleValue();
        } else if (target instanceof Long) {
            d = ((Long)target).doubleValue();
        } else if (target instanceof Float) {
            d = ((Float)target).doubleValue();
        }
        if (d == null || d < minValue || d > maxValue) {
            errors.add(fieldName, errorMsg);
            return false;
        }
        return true;
    }

    public static boolean el(String fieldName, Object obj, String el, String errorMsg, Errors errors) {
        Context context = Lang.context();
        context.set("value", obj);
        Object val = El.eval((Context)context, (String)el);
        if (val == null) {
            return true;
        }
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                return (Boolean)val;
            }
            errors.add(fieldName, errorMsg);
            return false;
        }
        errors.add(fieldName, errorMsg);
        return false;
    }

    public static boolean custom(String fieldName, Object obj, String customFunction, String errorMsg, Errors errors) {
        FastMethod fm;
        Mirror mirror = Mirror.me(obj.getClass());
        Method[] mds = mirror.getMethods();
        boolean find = false;
        if ("_".equals(customFunction)) {
            customFunction = "verify" + Strings.upperFirst((CharSequence)fieldName);
        }
        if ((fm = customMethods.get(obj.getClass().getName() + "#" + fieldName)) != null) {
            try {
                Boolean ret = (Boolean)fm.invoke(obj, new Object[]{fieldName, errorMsg, errors});
                if (ret != null && !ret.booleanValue()) {
                    errors.add(fieldName, errorMsg);
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Method md : mds) {
            if (!md.getName().equals(customFunction)) continue;
            int paramCount = md.getParameterTypes().length;
            try {
                Boolean ret = null;
                if (paramCount == 0) {
                    find = true;
                    ret = (Boolean)md.invoke(obj, new Object[0]);
                } else {
                    if (paramCount != 3) continue;
                    find = true;
                    fm = FastClassFactory.get((Method)md);
                    customMethods.put(obj.getClass().getName() + "#" + fieldName, fm);
                    ret = (Boolean)fm.invoke(obj, new Object[]{fieldName, errorMsg, errors});
                }
                if (ret != null && !ret.booleanValue()) {
                    errors.add(fieldName, errorMsg);
                    return false;
                }
                return true;
            }
            catch (Throwable e) {
                errors.add(fieldName, errorMsg);
                return false;
            }
        }
        if (!find) {
            errors.add(fieldName, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6548\u9a8c\u65b9\u6cd5");
            return false;
        }
        return true;
    }

    public static Errors checkArgs(Class<?>[] argsClass, Object ... args) {
        Errors es = null;
        for (int i = 0; i < argsClass.length; ++i) {
            if (argsClass[i] != Errors.class) continue;
            if (args[i] == null) {
                es = new Errors();
                args[i] = es;
                break;
            }
            es = (Errors)args[i];
            break;
        }
        return es;
    }
}

