/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.nutz.boot.AppContext;
import org.nutz.boot.aware.AppContextAware;
import org.nutz.boot.aware.ClassLoaderAware;
import org.nutz.boot.aware.EnvHolderAware;
import org.nutz.boot.aware.IocAware;
import org.nutz.boot.aware.ResourceLoaderAware;
import org.nutz.boot.banner.SimpleBannerPrinter;
import org.nutz.boot.config.ConfigureLoader;
import org.nutz.boot.config.impl.PropertiesConfigureLoader;
import org.nutz.boot.env.SystemPropertiesEnvHolder;
import org.nutz.boot.ioc.IocLoaderProvider;
import org.nutz.boot.resource.impl.SimpleResourceLoader;
import org.nutz.boot.tools.PropDocReader;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Ioc2;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.ObjectProxy;
import org.nutz.ioc.impl.NutIoc;
import org.nutz.ioc.loader.annotation.AnnotationIocLoader;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Stopwatch;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.util.LifeCycle;
import org.nutz.log.Log;
import org.nutz.log.LogAdapter;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.IocBy;

public class NbApp
extends Thread {
    protected static Log log;
    protected String[] args;
    protected boolean allowCommandLineProperties = true;
    protected boolean printProcDoc;
    protected AppContext ctx;
    protected AnnotationIocLoader starterIocLoader;
    protected List<Class<?>> starterClasses;
    protected boolean prepared;
    protected Object lock = new Object();

    public NbApp() {
        this.ctx = AppContext.getDefault();
        StackTraceElement[] ts = Thread.currentThread().getStackTrace();
        if (ts.length > 2) {
            this.setMainClass(Lang.loadClassQuite((String)ts[2].getClassName()));
        }
    }

    public NbApp(Class<?> mainClass) {
        this.ctx = AppContext.getDefault();
        this.setMainClass(mainClass);
    }

    public NbApp(AppContext ctx) {
        this.ctx = ctx;
        StackTraceElement[] ts = Thread.currentThread().getStackTrace();
        if (ts.length > 2) {
            this.setMainClass(Lang.loadClassQuite((String)ts[2].getClassName()));
        }
    }

    public NbApp(AppContext ctx, Class<?> mainClass) {
        this.ctx = ctx;
        this.setMainClass(mainClass);
    }

    public NbApp setArgs(String[] args) {
        this.args = args;
        return this;
    }

    public NbApp setMainClass(Class<?> mainClass) {
        this.ctx.setMainClass(mainClass);
        return this;
    }

    public NbApp setAllowCommandLineProperties(boolean flag) {
        this.allowCommandLineProperties = flag;
        return this;
    }

    public NbApp setPrintProcDoc(boolean printProcDoc) {
        this.printProcDoc = printProcDoc;
        return this;
    }

    public AppContext getAppContext() {
        return this.ctx;
    }

    @Override
    public void run() {
        try {
            this._run();
        }
        catch (Throwable e) {
            Logs.get().error((Object)"something happen", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _run() throws Exception {
        Stopwatch sw = Stopwatch.begin();
        this.prepare();
        try {
            this.ctx.init();
            this.ctx.startServers();
            if (this.ctx.getMainClass().getAnnotation(IocBean.class) != null) {
                this.ctx.getIoc().get(this.ctx.getMainClass());
            }
            sw.stop();
            log.infof("NB started : %sms", new Object[]{sw.du()});
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
        }
        catch (Throwable e) {
            log.error((Object)"something happen!!", e);
        }
        this.ctx.stopServers();
        this.ctx.depose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info((Object)"ok, shutting down ...");
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void prepare() throws Exception {
        if (this.prepared) {
            return;
        }
        this.prepareBasic();
        new SimpleBannerPrinter().printBanner(this.ctx);
        this.prepareConfigureLoader();
        this.prepareIocLoader();
        this.prepareStarterClassList();
        if (this.printProcDoc) {
            PropDocReader docReader = new PropDocReader();
            docReader.load(this.starterClasses);
            Logs.get().info((Object)("Configure Manual:\r\n" + docReader.toMarkdown()));
        }
        this.prepareIoc();
        this.prepareStarterInstance();
        this.prepared = true;
    }

    public void prepareBasic() throws Exception {
        String logAdapter;
        if (this.ctx.getClassLoader() == null) {
            this.ctx.setClassLoader(NbApp.class.getClassLoader());
        }
        if (this.ctx.getEnvHolder() == null) {
            this.ctx.setEnvHolder(new SystemPropertiesEnvHolder());
        }
        if (!Strings.isBlank((CharSequence)(logAdapter = this.ctx.getEnvHolder().get("nutz.boot.base.LogAdapter")))) {
            Logs.setAdapter((LogAdapter)((LogAdapter)this.ctx.getClassLoader().loadClass(logAdapter).newInstance()));
        }
        log = Logs.get();
        if (this.ctx.getResourceLoader() == null) {
            SimpleResourceLoader resourceLoader = new SimpleResourceLoader();
            this.aware(resourceLoader);
            this.ctx.setResourceLoader(resourceLoader);
        }
    }

    public void prepareConfigureLoader() throws Exception {
        if (this.ctx.getConfigureLoader() == null) {
            String cnfLoader;
            ConfigureLoader configureLoader = null;
            InputStream ins = this.ctx.getResourceLoader().get("META-INF/nutz/org.nutz.boot.config.ConfigureLoader");
            if (ins != null && !Strings.isBlank((CharSequence)(cnfLoader = new String(Streams.readBytes((InputStream)ins)).trim()))) {
                log.debugf("using %s as ConfigureLoader", new Object[]{cnfLoader});
                configureLoader = (ConfigureLoader)this.ctx.getClassLoader().loadClass(cnfLoader).newInstance();
            }
            if (configureLoader == null) {
                configureLoader = new PropertiesConfigureLoader();
            }
            configureLoader.setCommandLineProperties(this.allowCommandLineProperties, this.args);
            this.aware(configureLoader);
            this.ctx.setConfigureLoader(configureLoader);
            if (configureLoader instanceof LifeCycle) {
                ((LifeCycle)configureLoader).init();
            }
        }
    }

    public void prepareIocLoader() throws Exception {
        if (this.ctx.getComboIocLoader() == null) {
            int asyncPoolSize = this.ctx.getConfigureLoader().get().getInt("nutz.ioc.async.poolSize", 64);
            ArrayList<String> args = new ArrayList<String>();
            args.add("*js");
            args.add("ioc/");
            args.add("*tx");
            args.add("*async");
            args.add("" + asyncPoolSize);
            args.add("*anno");
            args.add(this.ctx.getPackage());
            IocBy iocBy = this.ctx.getMainClass().getAnnotation(IocBy.class);
            if (iocBy != null) {
                String[] tmp = iocBy.args();
                ArrayList<String> _args = new ArrayList<String>();
                for (int i = 0; i < tmp.length; ++i) {
                    if (tmp[i].startsWith("*") && !_args.isEmpty()) {
                        switch ((String)_args.get(0)) {
                            case "*tx": 
                            case "*async": 
                            case "*anno": 
                            case "*js": {
                                break;
                            }
                            default: {
                                args.addAll(_args);
                            }
                        }
                        _args.clear();
                    }
                    _args.add(tmp[i]);
                }
                if (_args.size() > 0) {
                    switch ((String)_args.get(0)) {
                        case "*tx": 
                        case "*async": 
                        case "*anno": 
                        case "*js": {
                            break;
                        }
                        default: {
                            args.addAll(_args);
                        }
                    }
                }
            }
            this.ctx.setComboIocLoader(new ComboIocLoader(args.toArray(new String[args.size()])));
        }
        this.starterIocLoader = new AnnotationIocLoader(new String[]{NbApp.class.getPackage().getName() + ".starter"});
        this.ctx.getComboIocLoader().addLoader((IocLoader)this.starterIocLoader);
    }

    public void prepareStarterClassList() throws Exception {
        this.starterClasses = new ArrayList();
        HashSet<String> classNames = new HashSet<String>();
        Enumeration<URL> _en = this.ctx.getClassLoader().getResources("META-INF/nutz/org.nutz.boot.starter.NbStarter");
        while (_en.hasMoreElements()) {
            URL url = _en.nextElement();
            log.debug((Object)("Found " + url));
            InputStream ins = url.openStream();
            Throwable throwable = null;
            try {
                InputStreamReader reader = new InputStreamReader(ins);
                String tmp = Streams.readAndClose((Reader)reader);
                if (Strings.isBlank((CharSequence)tmp)) continue;
                for (String _tmp : Strings.splitIgnoreBlank((String)tmp, (String)"[\n]")) {
                    String className = _tmp.trim();
                    if (!classNames.add(className)) continue;
                    Class<?> klass = this.ctx.getClassLoader().loadClass(className);
                    if (!klass.getPackage().getName().startsWith(NbApp.class.getPackage().getName()) && klass.getAnnotation(IocBean.class) != null) {
                        this.starterIocLoader.addClass(klass);
                    }
                    this.starterClasses.add(klass);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ins == null) continue;
                if (throwable != null) {
                    try {
                        ins.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ins.close();
            }
        }
    }

    public void prepareIoc() {
        if (this.ctx.getIoc() == null) {
            this.ctx.setIoc((Ioc)new NutIoc((IocLoader)this.ctx.getComboIocLoader()));
        }
        if (!this.ctx.ioc.has("appContext")) {
            Ioc2 ioc2 = (Ioc2)this.ctx.getIoc();
            ioc2.getIocContext().save("app", "appContext", new ObjectProxy((Object)this.ctx));
            ioc2.getIocContext().save("app", "conf", new ObjectProxy((Object)this.ctx.getConf()));
            ioc2.getIocContext().save("app", "nbApp", new ObjectProxy((Object)this));
        }
    }

    public void prepareStarterInstance() {
        for (Class<?> klass : this.starterClasses) {
            Object obj = klass.getAnnotation(IocBean.class) == null ? Mirror.me(klass).born(new Object[0]) : this.ctx.getIoc().get(klass);
            this.aware(obj);
            if (obj instanceof IocLoaderProvider) {
                IocLoader loader = ((IocLoaderProvider)obj).getIocLoader();
                this.ctx.getComboIocLoader().addLoader(loader);
            }
            this.ctx.addStarter(obj);
        }
    }

    protected void aware(Object obj) {
        if (obj instanceof AppContextAware) {
            ((AppContextAware)obj).setAppContext(this.ctx);
        }
        if (obj instanceof ClassLoaderAware) {
            ((ClassLoaderAware)obj).setClassLoader(this.ctx.getClassLoader());
        }
        if (obj instanceof EnvHolderAware) {
            ((EnvHolderAware)obj).setEnvHolder(this.ctx.getEnvHolder());
        }
        if (obj instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)obj).setResourceLoader(this.ctx.getResourceLoader());
        }
        if (obj instanceof IocAware) {
            ((IocAware)obj).setIoc(this.ctx.getIoc());
        }
    }
}

