/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.config.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.nutz.boot.config.impl.AbstractConfigureLoader;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Streams;
import org.nutz.lang.util.Disks;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class PropertiesConfigureLoader
extends AbstractConfigureLoader {
    private static final Log log = Logs.get();

    public void init() throws Exception {
        Object tmp;
        boolean flag;
        String path;
        block21: {
            path = this.envHolder.get("nutz.boot.configure.properties_path", "application.properties");
            this.conf.setPaths(new String[]{"custom/"});
            flag = true;
            try {
                tmp = new File(this.getPath(path));
                if (!((File)tmp).exists() || !((File)tmp).canRead()) break block21;
                try (FileInputStream ins = new FileInputStream((File)tmp);){
                    log.debugf("load %s", new Object[]{((File)tmp).getAbsolutePath()});
                    this.conf.load(Streams.utf8r((InputStream)ins), false);
                    flag = false;
                }
            }
            catch (Throwable tmp2) {
                // empty catch block
            }
        }
        if (flag) {
            this.readPropertiesPath(path);
        }
        tmp = new PropertiesProxy();
        if (this.args != null) {
            this.parseCommandLineArgs((PropertiesProxy)tmp, this.args);
            if (tmp.has("nutz.profiles.active")) {
                this.conf.put("nutz.profiles.active", tmp.remove((Object)"nutz.profiles.active"));
            }
        }
        if (this.allowCommandLineProperties) {
            this.conf.putAll((Map)System.getProperties());
        }
        if (this.conf.has("nutz.profiles.active")) {
            String profile = this.conf.get("nutz.profiles.active");
            String _path = path.substring(0, path.lastIndexOf(46)) + "-" + profile + ".properties";
            this.readPropertiesPath(_path);
        }
        if (this.conf.has("nutz.boot.configure.properties.dir")) {
            String configDir = this.conf.get("nutz.boot.configure.properties.dir");
            String configPath = this.getPath(configDir);
            Disks.visitFile((String)configPath, (String)".+properties$", (boolean)true, file -> {
                if (file.canRead()) {
                    try (FileInputStream ins = new FileInputStream(file);){
                        this.conf.load(Streams.utf8r((InputStream)ins), false);
                    }
                    catch (IOException e) {
                        log.info((Object)("fail to load " + file.getAbsolutePath()));
                    }
                }
            });
        }
        if (tmp.size() > 0) {
            this.conf.putAll(tmp.toMap());
        }
    }

    protected String getBasePath() {
        String basePath = "";
        basePath = this.appContext.getMainClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        int lastIndex = basePath.lastIndexOf(47);
        if (lastIndex < 0) {
            lastIndex = basePath.lastIndexOf(92);
        }
        basePath = basePath.substring(0, lastIndex);
        try {
            basePath = URLDecoder.decode(basePath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return basePath;
    }

    protected String getPath(String ... name) {
        String path = this.getBasePath();
        for (int i = 0; i < name.length; ++i) {
            path = path + File.separator + name[i];
        }
        return path;
    }

    protected void readPropertiesPath(String path) throws IOException {
        try (InputStream ins = this.resourceLoader.get(path);){
            if (ins != null) {
                this.conf.load(Streams.utf8r((InputStream)ins), false);
            }
        }
    }
}

