/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.tools;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.nutz.boot.AppContext;
import org.nutz.boot.starter.WebEventListenerFace;
import org.nutz.integration.spring.SpringIocLoader2;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.loader.annotation.Inject;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public abstract class SpringWebContextProxy
implements ServletContextListener,
WebEventListenerFace {
    @Inject(value="refer:$ioc")
    protected Ioc ioc;
    @Inject
    protected AppContext appContext;
    protected XmlWebApplicationContext applicationContext;
    protected String configLocation;
    protected String selfName;

    public void contextInitialized(ServletContextEvent sce) {
        this.applicationContext = new XmlWebApplicationContext();
        this.applicationContext.setServletContext(sce.getServletContext());
        this.applicationContext.setConfigLocation(this.configLocation);
        this.applicationContext.refresh();
        this.appContext.getComboIocLoader().addLoader((IocLoader)new SpringIocLoader2((ApplicationContext)this.applicationContext, this.getSpringBeanNames().toArray(new String[0])));
        sce.getServletContext().setAttribute("spring." + this.selfName, (Object)this.applicationContext);
    }

    protected List<String> getSpringBeanNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.applicationContext.getBeanDefinitionNames()) {
            if (!name.startsWith(this.selfName + ".")) continue;
            names.add(name);
        }
        return names;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }

    @Override
    public EventListener getEventListener() {
        return this;
    }
}

