/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.hystrix_dashboard;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.boot.starter.WebServletFace;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class ProxyStreamServletStarter
extends HttpServlet
implements WebServletFace {
    private static final long serialVersionUID = 1L;
    private static final Log log = Logs.get();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String origin = request.getParameter("origin");
        String authorization = request.getParameter("authorization");
        if (origin == null) {
            response.setStatus(500);
            response.getWriter().println("Required parameter 'origin' missing. Example: 107.20.175.135:7001");
            return;
        }
        origin = origin.trim();
        InputStream is = null;
        boolean hasFirstParameter = false;
        StringBuilder url = new StringBuilder();
        if (!origin.startsWith("http")) {
            url.append("http://");
        }
        url.append(origin);
        if (origin.contains("?")) {
            hasFirstParameter = true;
        }
        Map params = request.getParameterMap();
        for (String key : params.keySet()) {
            if (key.equals("origin") || key.equals("authorization")) continue;
            String[] values = (String[])params.get(key);
            String value = values[0].trim();
            if (hasFirstParameter) {
                url.append("&");
            } else {
                url.append("?");
                hasFirstParameter = true;
            }
            url.append(key).append("=").append(value);
        }
        String proxyUrl = url.toString();
        log.debugf("Proxy opening connection to: %s", new Object[]{proxyUrl});
        try {
            Response resp;
            Request req = Request.create((String)proxyUrl, (Request.METHOD)Request.METHOD.GET);
            if (authorization != null) {
                req.getHeader().set("Authorization", authorization);
            }
            if (!(resp = Sender.create((Request)req).setConnTimeout(5000).setTimeout(15000).send()).isOK()) return;
            String contentType = resp.getHeader().get("Content-Type");
            if (Strings.isBlank((CharSequence)contentType) || !contentType.startsWith("text/event-stream")) {
                log.warn((Object)("not vaild ContentType = " + contentType));
                Streams.safeClose((Closeable)is);
                return;
            }
            response.setHeader("Content-Type", contentType);
            is = resp.getStream();
            ServletOutputStream os = response.getOutputStream();
            int b = -1;
            while ((b = is.read()) != -1) {
                try {
                    os.write(b);
                    if (b != 10) continue;
                    os.flush();
                }
                catch (Exception e) {
                    // empty catch block
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            log.error((Object)("Error proxying request: " + url), (Throwable)e);
            return;
        }
        finally {
            Streams.safeClose(is);
        }
    }

    public String getName() {
        return "ProxyStreamServlet";
    }

    public String getPathSpec() {
        return "/hystrix-dashboard/proxy.stream";
    }

    public Servlet getServlet() {
        return this;
    }
}

