/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.mqtt.client;

import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class MqttClientStarter {
    private static final Log log = Logs.get();
    protected static final String PRE = "mqtt.client.";
    @PropDoc(value="\u670d\u52a1\u5668\u5730\u5740", defaultValue="tcp://127.0.0.1:1883")
    public static final String PROP_URL = "mqtt.client.url";
    @PropDoc(value="\u5ba2\u6237\u7aefid", defaultValue="MqttClient.generateClientId()")
    public static final String PROP_CLIENT_ID = "mqtt.client.clientId";
    @PropDoc(value="\u540c\u6b65\u5ba2\u6237\u7aef\u7684\u6700\u5927\u7b49\u5f85\u65f6\u95f4", defaultValue="-1")
    public static final String PROP_TIME_TO_WAIT = "mqtt.client.timeToWait";
    @PropDoc(value="\u542f\u52a8\u65f6\u81ea\u52a8\u8fde\u63a5", defaultValue="true")
    public static final String PROP_CONNECT_ON_START = "mqtt.client.connectOnStart";
    @PropDoc(value="\u81ea\u52a8\u91cd\u8fde", defaultValue="true")
    public static final String PROP_OPTIONS_AUTOMATIC_RECONNECT = "mqtt.client.options.automaticReconnect";
    @PropDoc(value="\u5fc3\u8df3\u9891\u7387,\u5355\u4f4d\u79d2", defaultValue="60")
    public static final String PROP_OPTIONS_KEEP_ALIVE_INTERVAL = "mqtt.client.options.keepAliveInterval";
    @PropDoc(value="Will\u6d88\u606f\u7684topic")
    public static final String PROP_OPTIONS_WILL_TOPIC = "mqtt.client.options.will.topic";
    @PropDoc(value="Will\u6d88\u606f\u7684\u5185\u5bb9")
    public static final String PROP_OPTIONS_WILL_PAYLOAD = "mqtt.client.options.will.payload";
    @PropDoc(value="Will\u6d88\u606f\u7684QOS", defaultValue="2")
    public static final String PROP_OPTIONS_WILL_QOS = "mqtt.client.options.will.qos";
    @PropDoc(value="Will\u6d88\u606f\u662f\u5426retained", defaultValue="true")
    public static final String PROP_OPTIONS_WILL_RETAINED = "mqtt.client.options.will.retained";
    @PropDoc(value="\u7528\u6237\u540d")
    public static final String PROP_OPTIONS_USERNAME = "mqtt.client.options.username";
    @PropDoc(value="\u5bc6\u7801")
    public static final String PROP_OPTIONS_PASSWORD = "mqtt.client.options.password";
    @PropDoc(value="\u6e05\u9664session", defaultValue="true")
    public static final String PROP_OPTIONS_CLEAN_SESSION = "mqtt.client.options.cleanSession";
    @PropDoc(value="\u8fde\u63a5\u8d85\u65f6\u8bbe\u7f6e", defaultValue="30")
    public static final String PROP_OPTIONS_CONNECTION_TIMEOUT = "mqtt.client.options.connectionTimeout";
    @PropDoc(value="\u591a\u670d\u52a1\u5668\u5730\u5740\u8bbe\u7f6e")
    public static final String PROP_OPTIONS_URLS = "mqtt.client.options.urls";
    @PropDoc(value="\u6301\u4e45\u5316\u65b9\u5f0f", defaultValue="memory", possible={"memory", "file"})
    public static final String PROP_PERSISTENCE_TYPE = "mqtt.client.persistence.type";
    @PropDoc(value="\u6587\u4ef6\u6301\u4e45\u5316\u65f6\u7684\u76ee\u5f55", defaultValue="\u7528\u6237\u4e3b\u76ee\u5f55")
    public static final String PROP_PERSISTENCE_PATH = "mqtt.client.persistence.path";
    @Inject
    protected PropertiesProxy conf;
    @Inject(value="refer:$ioc")
    protected Ioc ioc;

    @IocBean(name="mqttConnectOptions")
    public MqttConnectOptions createMqttConnectOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(this.conf.getBoolean(PROP_OPTIONS_AUTOMATIC_RECONNECT, true));
        options.setKeepAliveInterval(this.conf.getInt(PROP_OPTIONS_KEEP_ALIVE_INTERVAL, 60));
        if (!Strings.isBlank((CharSequence)this.conf.get(PROP_OPTIONS_WILL_TOPIC))) {
            options.setWill(this.conf.get(PROP_OPTIONS_WILL_TOPIC), this.conf.get(PROP_OPTIONS_WILL_PAYLOAD).getBytes(), this.conf.getInt(PROP_OPTIONS_WILL_QOS, 2), this.conf.getBoolean(PROP_OPTIONS_WILL_RETAINED, true));
        }
        if (!Strings.isBlank((CharSequence)this.conf.get(PROP_OPTIONS_USERNAME))) {
            options.setUserName(this.conf.get(PROP_OPTIONS_USERNAME));
        }
        if (!Strings.isBlank((CharSequence)this.conf.get(PROP_OPTIONS_PASSWORD))) {
            options.setPassword(this.conf.get(PROP_OPTIONS_PASSWORD).toCharArray());
        }
        options.setCleanSession(this.conf.getBoolean(PROP_OPTIONS_CLEAN_SESSION, true));
        options.setConnectionTimeout(this.conf.getInt(PROP_OPTIONS_CONNECTION_TIMEOUT, 30));
        if (!Strings.isBlank((CharSequence)this.conf.get(PROP_OPTIONS_URLS))) {
            options.setServerURIs(Strings.splitIgnoreBlank((String)this.conf.get(PROP_OPTIONS_URLS), (String)" "));
        }
        return options;
    }

    @IocBean(name="mqttClientPersistence")
    public MqttClientPersistence createMqttClientPersistence() {
        switch (this.conf.get(PROP_PERSISTENCE_TYPE, "memory")) {
            case "file": {
                return new MqttDefaultFilePersistence(this.conf.get(PROP_PERSISTENCE_PATH, System.getProperty("user.dir")));
            }
        }
        return new MemoryPersistence();
    }

    @IocBean(name="mqttClient", depose="close")
    public MqttClient createMqttClient(@Inject MqttConnectOptions mqttConnectOptions, @Inject MqttClientPersistence mqttClientPersistence) throws MqttException {
        IMqttToken token;
        String clientId = this.conf.get(PROP_CLIENT_ID);
        if (Strings.isBlank((CharSequence)clientId)) {
            clientId = MqttClient.generateClientId();
        }
        log.info((Object)("Client Id = " + clientId));
        MqttClient client = new MqttClient(this.conf.get(PROP_URL, "tcp://127.0.0.1:1883"), clientId, mqttClientPersistence);
        if (this.ioc.has("mqttCallback")) {
            client.setCallback((MqttCallback)this.ioc.get(MqttCallback.class, "mqttCallback"));
        }
        client.setTimeToWait(this.conf.getLong(PROP_TIME_TO_WAIT, -1L));
        if (this.conf.getBoolean(PROP_CONNECT_ON_START, true) && (token = client.connectWithResult(mqttConnectOptions)).getException() != null) {
            throw token.getException();
        }
        return client;
    }

    @IocBean(name="mqttAsyncClient", depose="close")
    public MqttAsyncClient createMqttAsyncClient(@Inject MqttConnectOptions mqttConnectOptions, @Inject MqttClientPersistence mqttClientPersistence) throws MqttException {
        String clientId = this.conf.get(PROP_CLIENT_ID);
        if (Strings.isBlank((CharSequence)clientId)) {
            clientId = MqttClient.generateClientId();
        }
        log.info((Object)("Client Id = " + clientId));
        MqttAsyncClient client = new MqttAsyncClient(this.conf.get(PROP_URL, "tcp://127.0.0.1:1883"), clientId, mqttClientPersistence);
        if (this.ioc.has("mqttCallback")) {
            client.setCallback((MqttCallback)this.ioc.get(MqttCallback.class, "mqttCallback"));
        }
        if (this.conf.getBoolean(PROP_CONNECT_ON_START, true)) {
            IMqttToken token = client.connect(mqttConnectOptions, null, null);
            token.waitForCompletion(this.conf.getLong(PROP_TIME_TO_WAIT, -1L));
            if (token.getException() != null) {
                throw token.getException();
            }
        }
        return client;
    }
}

