/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.tio.mvc;

import org.nutz.boot.AppContext;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.common.session.id.ISessionIdGenerator;
import org.tio.http.server.HttpServerStarter;
import org.tio.http.server.handler.DefaultHttpRequestHandler;
import org.tio.http.server.intf.HttpServerInterceptor;
import org.tio.http.server.mvc.Routes;
import org.tio.http.server.mvc.intf.ControllerFactory;
import org.tio.utils.cache.ICache;

@IocBean
public class TioMvcHttpServerBeans
implements ControllerFactory {
    private static final Log log = Logs.get();
    @Inject
    private AppContext appContext;
    protected static final String PRE = "tio_mvc.";
    @Inject
    protected PropertiesProxy conf;
    @PropDoc(value="tio\u76d1\u542c\u7aef\u53e3", defaultValue="8080")
    public static final String PROP_PORT = "tio_mvc.port";
    @PropDoc(value="tio\u76d1\u542cip/\u4e3b\u673a\u540d", defaultValue="0.0.0.0")
    public static final String PROP_IP = "tio_mvc.host";
    @PropDoc(value="tio mvc\u4f1a\u8bdd\u8d85\u65f6\u65f6\u95f4", defaultValue="1800")
    public static final String PROP_SESSION_TIMEOUT = "tio_mvc.sessionTimeout";
    @PropDoc(value="tio mvc\u4e0a\u4e0b\u6587\u8def\u5f84")
    public static final String PROP_CONTEXT_PATH = "tio_mvc.contextPath";
    @PropDoc(value="\u670d\u52a1\u5668\u4fe1\u606f")
    public static final String PROP_SERVER_INFO = "tio_mvc.serverInfo";
    @PropDoc(value="\u9ed8\u8ba4\u540e\u7f00")
    public static final String PROP_SUFFIX = "tio_mvc.suffix";
    @PropDoc(value="\u5b57\u7b26\u96c6", defaultValue="UTF-8")
    public static final String PROP_CHARSET = "tio_mvc.charset";
    @PropDoc(value="\u9ed8\u8ba4Welcome File", defaultValue="index.html")
    public static final String PROP_WELCOME_FILE = "tio_mvc.welcomeFile";
    @PropDoc(value="\u5141\u8bb8\u8bbf\u95ee\u7684\u57df\u540d,\u9017\u53f7\u5206\u9694")
    public static final String PROP_ALLOW_DOMAINS = "tio_mvc.allowDomains";
    @PropDoc(value="\u4f1a\u8bdd\u7f13\u5b58\u7684\u540d\u79f0")
    public static final String PROP_SESSION_CACHE_NAME = "tio_mvc.sessionCacheName";
    @PropDoc(value="\u4f1a\u8bddcookie\u7684\u540d\u5b57")
    public static final String PROP_SESSION_COOKIE_NAME = "tio_mvc.sessionCookieName";
    @PropDoc(value="maxLiveTimeOfStaticRes\u8bbe\u7f6e")
    public static final String PROP_MAX_LIVE_TIME_OF_STATIC_RES = "tio_mvc.maxLiveTimeOfStaticRes";
    @PropDoc(value="404\u9875\u9762", defaultValue="/404.html")
    public static final String PROP_PAGE_404 = "tio_mvc.page404";
    @PropDoc(value="500\u9875\u9762", defaultValue="/500.html")
    public static final String PROP_PAGE_500 = "tio_mvc.page500";
    @PropDoc(value="\u662f\u5426\u4f7f\u7528Session\u673a\u5236", defaultValue="true")
    public static final String PROP_USE_SESSION = "tio_mvc.useSession";
    @PropDoc(value="\u62e6\u622a\u5668", defaultValue="apiInterceptor")
    public static final String PROP_API_INTERCEPTOR = "tio_mvc.apiInterceptor";
    @PropDoc(value="\u4f1a\u8bddid\u751f\u6210\u5668", defaultValue="sessionIdGenerator")
    public static final String PROP_SESSION_ID_GENERATOR = "tio_mvc.sessionIdGenerator";
    @PropDoc(value="\u4f1a\u8bddid\u7f13\u5b58\u63d0\u4f9b\u8005", defaultValue="sessionStore")
    public static final String PROP_SESSION_STORE = "tio_mvc.sessionStore";

    @IocBean
    public HttpConfig getHttpConfig() {
        String ip = this.appContext.getServerHost(PROP_IP);
        int port = this.appContext.getServerPort(PROP_PORT, 8080);
        HttpConfig httpConfig = new HttpConfig(Integer.valueOf(port), Long.valueOf(this.conf.getLong(PROP_SESSION_TIMEOUT, 1800L)), this.conf.get(PROP_CONTEXT_PATH), this.conf.get(PROP_SUFFIX));
        httpConfig.setBindIp(ip);
        if (this.conf.has(PROP_ALLOW_DOMAINS)) {
            httpConfig.setAllowDomains(Strings.splitIgnoreBlank((String)this.conf.get(PROP_ALLOW_DOMAINS)));
        }
        if (this.conf.has(PROP_SERVER_INFO)) {
            httpConfig.setServerInfo(this.conf.get(PROP_SERVER_INFO));
        }
        httpConfig.setCharset(this.conf.get(PROP_CHARSET, "UTF-8"));
        httpConfig.setWelcomeFile(this.conf.get(PROP_WELCOME_FILE, "index.html"));
        if (this.conf.has(PROP_SESSION_CACHE_NAME)) {
            httpConfig.setSessionCacheName(PROP_SESSION_CACHE_NAME);
        }
        if (this.conf.has(PROP_SESSION_COOKIE_NAME)) {
            httpConfig.setSessionCookieName(this.conf.get(PROP_SESSION_COOKIE_NAME));
        }
        if (this.conf.has(PROP_MAX_LIVE_TIME_OF_STATIC_RES)) {
            httpConfig.setMaxLiveTimeOfStaticRes(this.conf.getInt(PROP_MAX_LIVE_TIME_OF_STATIC_RES));
        }
        httpConfig.setPage404(this.conf.get(PROP_PAGE_404, "/404.html"));
        httpConfig.setPage500(this.conf.get(PROP_PAGE_500, "/500.html"));
        httpConfig.setUseSession(this.conf.getBoolean(PROP_USE_SESSION, true));
        if (httpConfig.isUseSession()) {
            String sessionIdGeneratorName = this.conf.get(PROP_SESSION_ID_GENERATOR, "sessionIdGenerator");
            if (this.appContext.getIoc().has(sessionIdGeneratorName)) {
                httpConfig.setSessionIdGenerator((ISessionIdGenerator)this.appContext.getIoc().get(ISessionIdGenerator.class, sessionIdGeneratorName));
            } else {
                log.debugf("sessionIdGenerator name=%s not found in ioc , skiped", new Object[]{sessionIdGeneratorName});
            }
            String sessionStoreName = this.conf.get(PROP_SESSION_STORE, "sessionStore");
            if (this.appContext.getIoc().has(sessionStoreName)) {
                httpConfig.setSessionStore((ICache)this.appContext.getIoc().get(ICache.class, sessionStoreName));
            } else {
                log.debugf("sessionStore name=%s not found in ioc , skiped", new Object[]{sessionStoreName});
            }
        }
        return httpConfig;
    }

    @IocBean
    public HttpServerStarter getHttpServerStarter(HttpConfig httpConfig) {
        String[] scanPackages = new String[]{this.appContext.getPackage()};
        Routes routes = new Routes(scanPackages, (ControllerFactory)this);
        DefaultHttpRequestHandler requestHandler = new DefaultHttpRequestHandler(httpConfig, routes);
        String apiInterceptorName = this.conf.get(PROP_API_INTERCEPTOR, "apiInterceptor");
        if (this.appContext.getIoc().has(apiInterceptorName)) {
            requestHandler.setHttpServerInterceptor((HttpServerInterceptor)this.appContext.ioc().get(HttpServerInterceptor.class, apiInterceptorName));
        } else {
            log.debugf("apiInterceptor name=%s not found in ioc , skiped", new Object[]{apiInterceptorName});
        }
        return new HttpServerStarter(httpConfig, (HttpRequestHandler)requestHandler);
    }

    public Object getInstance(Class<?> controllerClazz) throws Exception {
        if (controllerClazz.getAnnotation(IocBean.class) == null) {
            return controllerClazz.newInstance();
        }
        return this.appContext.getIoc().get(controllerClazz);
    }
}

