/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.tio.server;

import java.util.List;
import org.nutz.boot.AppContext;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.ServerFace;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.tio.server.AioServer;
import org.tio.server.ServerGroupContext;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;

@IocBean(create="init")
public class TioServerStarter
implements ServerFace {
    private static final Log log = Logs.get();
    @Inject
    private AppContext appContext;
    protected static final String PRE = "tio.";
    @Inject
    protected PropertiesProxy conf;
    @PropDoc(group="tio", value="tio\u76d1\u542c\u7aef\u53e3", defaultValue="9420")
    public static final String PROP_PORT = "tio.port";
    @PropDoc(group="tio", value="tio\u76d1\u542c\u7684ip", defaultValue="0.0.0.0")
    public static final String PROP_IP = "tio.host";
    @PropDoc(group="tio", value="\u662f\u5426\u542f\u52a8\u6846\u67b6\u5c42\u9762\u5fc3\u8df3", defaultValue="false")
    public static final String PROP_HEARTBEAT = "tio.heartbeat";
    @PropDoc(group="tio", value="\u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4(\u5355\u4f4d:\u6beb\u79d2)", defaultValue="120000")
    public static final String PROP_HEARTBEATTIMEOUT = "tio.heartbeatTimeout";
    @PropDoc(group="tio", value="\u4e0a\u4e0b\u6587\u540d\u79f0", defaultValue="NutzBoot GroupContext")
    public static final String PROP_NAME = "tio.name";
    protected ServerAioHandler serverAioHandler;
    protected ServerAioListener serverAioListener;
    public ServerGroupContext serverGroupContext;
    public AioServer server;
    private String ip;
    private int port;

    public void init() throws Exception {
        List hanlders = this.appContext.getBeans(ServerAioHandler.class);
        List listeners = this.appContext.getBeans(ServerAioListener.class);
        if (hanlders.size() > 0) {
            this.serverAioHandler = (ServerAioHandler)hanlders.get(0);
        }
        if (listeners.size() > 0) {
            this.serverAioListener = (ServerAioListener)listeners.get(0);
        }
        if (this.serverAioHandler == null) {
            throw new RuntimeException("Require ServerAioHandler!!!");
        }
        if (this.serverAioListener == null) {
            throw new RuntimeException("Require ServerAioListener!!!");
        }
        this.serverGroupContext = new ServerGroupContext(this.serverAioHandler, this.serverAioListener);
        this.serverGroupContext.setName(this.conf.get(PROP_NAME, "NutzBoot GroupContext"));
        this.serverGroupContext.setHeartbeatTimeout(0L);
        if ("true".equals(this.conf.get(PROP_HEARTBEAT))) {
            this.serverGroupContext.setHeartbeatTimeout(this.conf.getLong(PROP_HEARTBEATTIMEOUT, 120000L));
        }
        this.ip = this.appContext.getServerHost(PROP_IP);
        this.port = this.appContext.getServerPort(PROP_PORT, 9420);
        this.server = new AioServer(this.serverGroupContext);
    }

    public void start() throws Exception {
        if (this.server != null) {
            this.server.start(this.ip, this.port);
        } else {
            log.error((Object)"tio server is null!");
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        } else {
            log.error((Object)"tio server is null!");
        }
    }
}

