/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.undertow;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nutz.lang.Streams;

public class ComboResourceManager
implements ResourceManager {
    protected List<ResourceManager> managers = new ArrayList<ResourceManager>();

    public void close() throws IOException {
        this.managers.forEach(action -> Streams.safeClose((Closeable)action));
    }

    public Resource getResource(String path) throws IOException {
        for (ResourceManager manager : this.managers) {
            Resource resource = manager.getResource(path);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        for (ResourceManager manager : this.managers) {
            if (!manager.isResourceChangeListenerSupported()) continue;
            return true;
        }
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager manager : this.managers) {
            if (!manager.isResourceChangeListenerSupported()) continue;
            manager.registerResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager manager : this.managers) {
            if (!manager.isResourceChangeListenerSupported()) continue;
            manager.registerResourceChangeListener(listener);
        }
    }

    public void add(ResourceManager manager) {
        this.managers.add(manager);
    }

    public void remove(ResourceManager manager) {
        this.managers.remove(manager);
    }

    public void clear() {
        this.managers.clear();
    }
}

