/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.util.Map;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.MonitorObject;
import org.nutz.boot.starter.ServerFace;
import org.nutz.boot.starter.servlet3.AbstractServletContainerStarter;
import org.nutz.boot.starter.servlet3.NbServletContextListener;
import org.nutz.boot.starter.undertow.ComboResourceManager;
import org.nutz.boot.starter.undertow.WebSocketSupport;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class UndertowStarter
extends AbstractServletContainerStarter
implements ServerFace,
MonitorObject {
    private static final Log log = Logs.get();
    protected static final String PRE = "undertow.";
    @PropDoc(value="\u76d1\u542c\u7684ip\u5730\u5740", defaultValue="0.0.0.0")
    public static final String PROP_HOST = "undertow.host";
    @PropDoc(value="\u76d1\u542c\u7684\u7aef\u53e3", defaultValue="8080", type="int")
    public static final String PROP_PORT = "undertow.port";
    @PropDoc(value="\u4e0a\u4e0b\u6587\u8def\u5f84", defaultValue="/")
    public static final String PROP_CONTEXT_PATH = "undertow.contextPath";
    @PropDoc(value="Session\u7a7a\u95f2\u65f6\u95f4,\u5355\u4f4d\u5206\u949f", defaultValue="30", type="int")
    public static final String PROP_SESSION_TIMEOUT = "web.session.timeout";
    @PropDoc(value="\u9759\u6001\u6587\u4ef6\u8def\u5f84", defaultValue="static/")
    public static final String PROP_STATIC_PATH = "undertow.staticPath";
    @PropDoc(value="\u662f\u5426\u542f\u7528gzip", defaultValue="false")
    public static final String PROP_GZIP_ENABLE = "undertow.gzip.enable";
    @PropDoc(value="gzip\u538b\u7f29\u7ea7\u522b", defaultValue="-1")
    public static final String PROP_GZIP_LEVEL = "undertow.gzip.level";
    @PropDoc(value="gzip\u538b\u7f29\u6700\u5c0f\u89e6\u53d1\u5927\u5c0f", defaultValue="512")
    public static final String PROP_GZIP_MIN_CONTENT_SIZE = "undertow.gzip.minContentSize";
    @PropDoc(value="WelcomeFile\u5217\u8868", defaultValue="index.html,index.htm,index.do")
    public static final String PROP_WELCOME_FILES = "undertow.welcome_files";
    protected Undertow server;
    protected Undertow.Builder builder = Undertow.builder();
    protected DeploymentInfo deployment;

    public void start() throws Exception {
        this.server.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Undertow monitor props:\r\n" + this.getMonitorForPrint()));
        }
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isRunning() {
        return !this.server.getWorker().isShutdown();
    }

    public void init() throws Exception {
        this.updateMonitorValue("http.port", this.getPort());
        this.updateMonitorValue("http.host", this.getHost());
        String contextPath = this.getContextPath();
        this.deployment = Servlets.deployment().setDeploymentName("nb").setClassLoader(this.classLoader).setEagerFilterInit(true).setSecurityDisabled(true);
        this.deployment.setContextPath(contextPath).setDefaultSessionTimeout(this.getSessionTimeout());
        this.updateMonitorValue("contextPath", contextPath);
        this.updateMonitorValue("sessionTimeout", this.deployment.getDefaultSessionTimeout());
        ComboResourceManager resourceManager = new ComboResourceManager();
        for (String string : this.getResourcePaths()) {
            if (new File(string).exists()) {
                resourceManager.add((ResourceManager)new FileResourceManager(new File(string), 1024L));
            }
            try {
                resourceManager.add((ResourceManager)new ClassPathResourceManager(this.classLoader, string));
            }
            catch (Throwable throwable) {}
        }
        this.deployment.setResourceManager((ResourceManager)resourceManager);
        this.addNutzSupport();
        this.addWebSocketSupport();
        this.deployment.addWelcomePages(this.getWelcomeFiles());
        for (Map.Entry entry : this.getErrorPages().entrySet()) {
            String key = (String)entry.getKey();
            if (Strings.isNumber((String)key)) {
                log.debugf("add error page code=%s location=%s", new Object[]{key, entry.getValue()});
                this.deployment.addErrorPage(new ErrorPage((String)entry.getValue(), Integer.parseInt(key)));
                continue;
            }
            log.debugf("add error page Exception=%s location=%s", new Object[]{key, entry.getValue()});
            Class<?> klass = this.appContext.getClassLoader().loadClass((String)entry.getValue());
            this.deployment.addErrorPage(new ErrorPage((String)entry.getValue(), klass));
        }
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(this.deployment);
        manager.deploy();
        HttpHandler httpHandler = manager.start();
        PathHandler pathHandler = "/".equals(contextPath) ? Handlers.path((HttpHandler)httpHandler) : Handlers.path((HttpHandler)Handlers.redirect((String)contextPath)).addPrefixPath(contextPath, httpHandler);
        PathHandler handler = pathHandler;
        if (this.conf.getBoolean(PROP_GZIP_ENABLE, false)) {
            ContentEncodingRepository repo = new ContentEncodingRepository();
            GzipEncodingProvider gzip = new GzipEncodingProvider(this.conf.getInt(PROP_GZIP_LEVEL, -1));
            int minContentSize = this.conf.getInt(PROP_GZIP_MIN_CONTENT_SIZE, 512);
            if (minContentSize > 0) {
                repo.addEncodingHandler("gzip", (ContentEncodingProvider)gzip, 100, Predicates.minContentSize((long)minContentSize));
            } else {
                repo.addEncodingHandler("gzip", (ContentEncodingProvider)gzip, 100);
            }
            handler = new EncodingHandler((HttpHandler)pathHandler, repo);
        }
        this.builder.addHttpListener(this.getPort(), this.getHost()).setHandler((HttpHandler)handler);
        this.server = this.builder.build();
    }

    private void addNutzSupport() {
        NbServletContextListener nbsc = (NbServletContextListener)this.ioc.get(NbServletContextListener.class);
        ImmediateInstanceFactory factory = new ImmediateInstanceFactory((Object)nbsc);
        ListenerInfo listener = new ListenerInfo(nbsc.getClass(), (InstanceFactory)factory);
        this.deployment.addListener(listener);
    }

    private void addWebSocketSupport() {
        try {
            WebSocketSupport.addWebSocketSupport(this.deployment, this.appContext.getPackage());
        }
        catch (Error e) {
            log.info((Object)"Not find undertow-websockets-jsr, websocket disable.");
        }
    }

    public Undertow getServer() {
        return this.server;
    }

    protected String getConfigurePrefix() {
        return PRE;
    }

    public String getMonitorName() {
        return "undertow";
    }
}

