/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.zkclient;

import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.SerializableSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Strings;

@IocBean
public class ZkClientStarter {
    protected static final String PRE = "zookeeper.";
    @PropDoc(group="zookeeper", value="\u670d\u52a1\u5730\u5740", defaultValue="127.0.0.1:2181")
    public static final String PROP_ZK_SERVERS = "zookeeper.zkServers";
    @PropDoc(group="zookeeper", value="\u4f1a\u8bdd\u8d85\u65f6,\u5355\u4f4d\u6beb\u79d2", defaultValue="30000", type="int")
    public static final String PROP_SESSION_TIMOUT = "zookeeper.sessionTimeout";
    @PropDoc(group="zookeeper", value="\u8fde\u63a5\u8d85\u65f6,\u5355\u4f4d\u6beb\u79d2", defaultValue="30000", type="int")
    public static final String PROP_CONNECTION_TIMOUT = "zookeeper.connectionTimeout";
    @PropDoc(group="zookeeper", value="\u64cd\u4f5c\u8d85\u65f6,\u5355\u4f4d\u6beb\u79d2", defaultValue="-1", type="long")
    public static final String PROP_OPERATION_RETRY_TIMOUT = "zookeeper.operationRetryTimeout";
    @PropDoc(group="zookeeper", value="zookeeper\u7684\u5e8f\u5217\u5316\u7c7b", defaultValue="org.I0Itec.zkclient.serialize.SerializableSerializer", type="Object")
    public static final String PROP_SERIALIZER = "zookeeper.zkSerializer";
    @Inject
    protected PropertiesProxy conf;
    @Inject(value="refer:$ioc")
    protected Ioc ioc;

    @IocBean(name="zkClient")
    public ZkClient getZkClient() {
        return new ZkClient(this.getZkServers(), this.getSessionTimeout(), this.getConnectionTimeout(), this.getZkSerializer(), this.getOperationRetryTimeout());
    }

    public String getZkServers() {
        return this.conf.get(PROP_ZK_SERVERS, "127.0.0.1:2181");
    }

    public int getSessionTimeout() {
        return this.conf.getInt(PROP_SESSION_TIMOUT, 30000);
    }

    public int getConnectionTimeout() {
        return this.conf.getInt(PROP_CONNECTION_TIMOUT, 30000);
    }

    public long getOperationRetryTimeout() {
        return this.conf.getLong(PROP_OPERATION_RETRY_TIMOUT, -1L);
    }

    public ZkSerializer getZkSerializer() {
        SerializableSerializer serializer = null;
        String zkSerializer = this.conf.get(PROP_SERIALIZER);
        if (!Strings.isBlank((CharSequence)zkSerializer)) {
            serializer = (ZkSerializer)this.ioc.get(ZkSerializer.class, zkSerializer);
        }
        if (serializer == null) {
            serializer = new SerializableSerializer();
        }
        return serializer;
    }
}

