/*
 * Decompiled with CFR 0.152.
 */
package org.objectfabric;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ConcurrentMap;
import org.objectfabric.Memory;

public class GoogleCache
extends Memory {
    public GoogleCache() {
        this(CacheBuilder.newBuilder());
    }

    public GoogleCache(CacheBuilder builder) {
        super(true, (Memory.Backend)new GoogleCacheBackend(builder.build().asMap()));
        builder.removalListener(new RemovalListener(){

            public void onRemoval(RemovalNotification notification) {
                GoogleCache.this.onEviction(notification.getValue());
            }
        });
    }

    private static final class GoogleCacheBackend
    implements Memory.Backend {
        final ConcurrentMap _map;

        GoogleCacheBackend(ConcurrentMap map) {
            this._map = map;
        }

        public Object get(String key) {
            return this._map.get(key);
        }

        public Object putIfAbsent(String key, Object value) {
            return this._map.putIfAbsent(key, value);
        }
    }
}

