/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.mongodb.spring.sortconversion.internal;

import org.occurrent.eventstore.api.SortBy;
import org.springframework.data.domain.Sort;

public class SortConverter {
    private static final String NATURAL = "$natural";

    public static Sort convertToSpringSort(SortBy sortBy) {
        Sort sort;
        if (sortBy instanceof SortBy.NaturalImpl) {
            sort = Sort.by((Sort.Direction)SortConverter.toDirection(((SortBy.NaturalImpl)sortBy).direction), (String[])new String[]{NATURAL});
        } else if (sortBy instanceof SortBy.SingleFieldImpl) {
            SortBy.SingleFieldImpl singleField = (SortBy.SingleFieldImpl)sortBy;
            sort = Sort.by((Sort.Direction)SortConverter.toDirection(singleField.direction), (String[])new String[]{singleField.fieldName});
        } else if (sortBy instanceof SortBy.MultipleSortStepsImpl) {
            sort = ((SortBy.MultipleSortStepsImpl)sortBy).steps.stream().map(SortConverter::convertToSpringSort).reduce(Sort::and).orElseThrow(() -> new IllegalStateException("Internal error: Expecting " + SortBy.MultipleSortStepsImpl.class.getSimpleName() + " to have at least one step"));
        } else {
            throw new IllegalArgumentException("Internal error: Unrecognized " + SortBy.class.getSimpleName() + " instance: " + sortBy.getClass().getSimpleName());
        }
        return sort;
    }

    private static Sort.Direction toDirection(SortBy.SortDirection sortDirection) {
        return sortDirection == SortBy.SortDirection.ASCENDING ? Sort.Direction.ASC : Sort.Direction.DESC;
    }
}

