/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.domain;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.time.ZoneOffset;
import org.occurrent.domain.DomainEvent;
import org.occurrent.functional.CheckedFunction;
import org.occurrent.time.TimeConversion;

public class DomainEventConverter {
    private final ObjectMapper objectMapper;

    public DomainEventConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CloudEvent convertToCloudEvent(DomainEvent e) {
        return ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(e.getEventId()).withSource(URI.create("http://name")).withType(e.getClass().getName()).withTime(TimeConversion.toLocalDateTime(e.getTimestamp()).atOffset(ZoneOffset.UTC)).withSubject(e.getName()).withDataContentType("application/json").withData(CheckedFunction.unchecked(arg_0 -> ((ObjectMapper)this.objectMapper).writeValueAsBytes(arg_0)).apply(e))).build();
    }

    public DomainEvent convertToDomainEvent(CloudEvent cloudEvent) {
        return CheckedFunction.unchecked(e -> (DomainEvent)this.objectMapper.readValue(e.getData().toBytes(), Class.forName(e.getType()))).apply(cloudEvent);
    }
}

