/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.ResourceManage;
import org.ofdrw.converter.point.Tuple2;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.FontUtils;
import org.ofdrw.converter.utils.ImageUtils;
import org.ofdrw.converter.utils.MatrixUtils;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.annotation.pageannot.Appearance;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicStructure.res.MediaType;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.pageDescription.CT_GraphicUnit;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.colorSpace.OFDColorSpaceType;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.CT_CGTransform;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.DLOFDReader;
import org.ofdrw.reader.model.AnnotionVo;
import org.ofdrw.reader.model.OfdPageVo;
import org.ofdrw.reader.model.StampAnnotVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ujmp.core.Matrix;

public class ImageMaker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DLOFDReader ofdReader;
    private int dpi = 8;
    public final Config config = new Config();
    private boolean isStamp = false;
    private List<OfdPageVo> pages = null;
    private final ResourceManage resourceManage;

    public ImageMaker(DLOFDReader ofdReader, int dpi) {
        this.ofdReader = ofdReader;
        this.resourceManage = new ResourceManage(ofdReader);
        this.pages = ofdReader.getOFDDocumentVo().getOfdPageVoList();
        if (dpi > 0) {
            this.dpi = dpi;
        }
    }

    public int pageSize() {
        return this.pages.size();
    }

    public BufferedImage makePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            throw new GeneralConvertException(String.format("%s \u4e0d\u662f\u6709\u6548\u7d22\u5f15", pageIndex));
        }
        OfdPageVo pageVo = this.pages.get(pageIndex);
        Page contentPage = pageVo.getContentPage();
        Page templatePage = pageVo.getTemplatePage();
        ST_Box pageBox = CommonUtil.getPageBox(contentPage.getArea(), this.ofdReader.getOFDDocumentVo().getPageWidth(), this.ofdReader.getOFDDocumentVo().getPageHeight());
        double pageWidthPixel = (double)this.dpi * pageBox.getWidth();
        double pageHeightPixel = (double)this.dpi * pageBox.getHeight();
        BufferedImage image = this.createImage((int)pageWidthPixel, (int)pageHeightPixel);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        this.writePage(graphics, pageVo, null);
        for (int i = 0; i < this.ofdReader.getOFDDocumentVo().getStampAnnotVos().size(); ++i) {
            StampAnnotVo stampAnnotVo = (StampAnnotVo)this.ofdReader.getOFDDocumentVo().getStampAnnotVos().get(i);
            List stampAnnots = stampAnnotVo.getStampAnnots();
            for (int j = 0; j < stampAnnots.size(); ++j) {
                StampAnnot stampAnnot = (StampAnnot)stampAnnots.get(j);
                if (!stampAnnot.getPageRef().toString().equals(contentPage.getObjID().toString())) continue;
                this.writeStampAnnot(graphics, stampAnnotVo, stampAnnot);
            }
        }
        for (AnnotionVo annotionVo : this.ofdReader.getOFDDocumentVo().getAnnotaions()) {
            if (!pageVo.getContentPage().getObjID().toString().equals(annotionVo.getPageId()) || null == annotionVo.getAnnots()) continue;
            for (Annot annot : annotionVo.getAnnots()) {
                Appearance appearance = annot.getAppearance();
                this.writeContent(graphics, (CT_PageBlock)appearance, null, null);
            }
        }
        return image;
    }

    private BufferedImage createImage(int pageWidthPixel, int pageHeightPixel) {
        BufferedImage image = new BufferedImage(pageWidthPixel, pageHeightPixel, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setComposite(AlphaComposite.getInstance(10, 1.0f));
        if (this.isStamp) {
            graphics.setColor(Color.WHITE);
            image = graphics.getDeviceConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        } else {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return image;
    }

    private void writeStampAnnot(Graphics2D graphics, StampAnnotVo stampAnnotVo, StampAnnot stampAnnot) {
        BufferedImage stampImage = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(stampAnnotVo.getImgByte());){
            if (stampAnnotVo.getType().equals("ofd")) {
                ImageMaker imageMaker = new ImageMaker(new DLOFDReader((InputStream)inputStream), this.dpi);
                imageMaker.isStamp = true;
                imageMaker.config.setDrawBoundary(this.config.drawBoundary);
                if (imageMaker.pageSize() > 0) {
                    this.logger.debug("\u6e32\u67d3ofd\u683c\u5f0f\u5370\u7ae0");
                    stampImage = imageMaker.makePage(0);
                }
            } else {
                stampImage = ImageIO.read(inputStream);
            }
            if (stampImage != null) {
                ST_Box stBox = stampAnnot.getBoundary();
                Matrix m = MatrixUtils.base();
                graphics.setTransform(MatrixUtils.createAffineTransform(m));
                m = MatrixUtils.scale(m, stBox.getWidth() / (double)stampImage.getWidth(), stBox.getHeight() / (double)stampImage.getHeight());
                m = MatrixUtils.move(m, stBox.getTopLeftX() * (double)this.dpi, stBox.getTopLeftY() * (double)this.dpi);
                m = MatrixUtils.scale(m, this.dpi, this.dpi);
                graphics.setClip(null);
                graphics.setComposite(AlphaComposite.getInstance(10, this.config.stampOpacity));
                graphics.drawImage(stampImage, MatrixUtils.createAffineTransform(m), null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePage(Graphics2D graphics, OfdPageVo page, Matrix matrix) {
        Page contentPage = page.getContentPage();
        Page templatePage = page.getTemplatePage();
        ArrayList<CT_Layer> templateLayers = new ArrayList<CT_Layer>();
        ArrayList<CT_Layer> layers = new ArrayList<CT_Layer>(contentPage.getContent().getLayers());
        if (templatePage != null && templatePage.getContent() != null) {
            templateLayers.addAll(templatePage.getContent().getLayers());
        }
        Comparator<CT_Layer> comparator = new Comparator<CT_Layer>(){

            @Override
            public int compare(CT_Layer l1, CT_Layer l2) {
                return l1.getType().compareTo((Enum)l2.getType());
            }
        };
        layers.sort(comparator);
        templateLayers.sort(comparator);
        for (CT_Layer layer : templateLayers) {
            this.writeContent(graphics, (CT_PageBlock)layer, null, matrix);
        }
        for (CT_Layer layer : layers) {
            this.writeContent(graphics, (CT_PageBlock)layer, null, matrix);
        }
    }

    private void writeContent(Graphics2D graphics, CT_PageBlock pageBlock, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        if (drawParams == null) {
            drawParams = new ArrayList<CT_DrawParam>();
        }
        if (parentMatrix == null) {
            parentMatrix = MatrixUtils.base();
        }
        if (pageBlock.attribute("Boundary") != null) {
            String data = (String)pageBlock.attribute("Boundary").getData();
            ST_Box stBox = ST_Box.getInstance((String)data);
            parentMatrix = MatrixUtils.move(parentMatrix, stBox.getTopLeftX(), stBox.getTopLeftY());
        }
        for (PageBlockType object : pageBlock.getPageBlocks()) {
            if (object instanceof TextObject) {
                TextObject textObject = (TextObject)object;
                this.writeText(graphics, textObject, drawParams, parentMatrix);
                continue;
            }
            if (object instanceof ImageObject) {
                ImageObject imageObject = (ImageObject)object;
                this.writeImage(graphics, imageObject, drawParams, parentMatrix);
                continue;
            }
            if (object instanceof PathObject) {
                PathObject pathObject = (PathObject)object;
                this.writePath(graphics, pathObject, drawParams, parentMatrix);
                continue;
            }
            if (object instanceof CompositeObject) {
                this.logger.info("\u6682\u4e0d\u652f\u6301\u590d\u5408\u5bf9\u8c61");
                continue;
            }
            if (object instanceof CT_PageBlock) {
                CT_PageBlock block = (CT_PageBlock)object;
                this.writeContent(graphics, block, drawParams, parentMatrix);
                continue;
            }
            if (!(object instanceof CT_Layer)) continue;
            CT_Layer layer = (CT_Layer)object;
            ST_RefID drawParamRef = layer.getDrawParam();
            CT_DrawParam ctDrawParam = this.resourceManage.getDrawParam(drawParamRef.getRefId().toString());
            drawParams.add(ctDrawParam);
            this.writeContent(graphics, (CT_PageBlock)layer, drawParams, parentMatrix);
        }
    }

    private void writePath(Graphics2D graphics, PathObject pathObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        Color fillColor;
        ST_Box boundary = pathObject.getBoundary();
        Matrix baseMatrix = this.renderBoundaryAndSetClip(graphics, boundary, parentMatrix);
        Matrix matrix = MatrixUtils.base();
        if (pathObject.getCTM() != null) {
            matrix = matrix.mtimes(MatrixUtils.ctm(pathObject.getCTM().toDouble()));
        }
        if (boundary != null) {
            matrix = MatrixUtils.move(matrix, boundary.getTopLeftX(), boundary.getTopLeftY());
        }
        matrix = matrix.mtimes(baseMatrix);
        graphics.transform(MatrixUtils.createAffineTransform(matrix));
        Path2D path2D = this.buildPath(pathObject.getAbbreviatedData());
        if (pathObject.getStroke() == null || pathObject.getStroke().booleanValue()) {
            graphics.setStroke(new BasicStroke(this.getLineWidth((CT_GraphicUnit)pathObject, drawParams).floatValue()));
            Color strokeColor = this.getStrokeColor((CT_Color)pathObject.getStrokeColor(), CT_Color.rgb((int)0, (int)0, (int)0), drawParams);
            if (strokeColor != null) {
                graphics.setColor(strokeColor);
                graphics.draw(path2D);
            }
        }
        if (pathObject.getFill() != null && pathObject.getFill().booleanValue() && (fillColor = this.getFillColor(pathObject.getFillColor(), null, drawParams)) != null) {
            graphics.setColor(fillColor);
            graphics.fill(path2D);
        }
    }

    private void writeImage(Graphics2D graphics, ImageObject imageObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        ST_Box boundary = imageObject.getBoundary();
        Matrix baseMatrix = this.renderBoundaryAndSetClip(graphics, boundary, parentMatrix);
        BufferedImage image = this.getImage(imageObject.getResourceID());
        if (image == null) {
            return;
        }
        BufferedImage mask = this.getImage(imageObject.getImageMask());
        if (mask != null) {
            image = ImageUtils.renderMask(image, mask);
        }
        Matrix m = MatrixUtils.base();
        m = MatrixUtils.scale(m, Double.valueOf(1.0 / (double)image.getWidth()).floatValue(), Double.valueOf(1.0 / (double)image.getHeight()).floatValue());
        if (imageObject.getCTM() != null) {
            m = m.mtimes(MatrixUtils.ctm(imageObject.getCTM().toDouble()));
        }
        if (boundary != null) {
            m = MatrixUtils.move(m, boundary.getTopLeftX(), boundary.getTopLeftY());
        }
        m = m.mtimes(baseMatrix);
        graphics.setTransform(MatrixUtils.createAffineTransform(MatrixUtils.base()));
        float alpha = 1.0f;
        if (imageObject.attributeValue("Alpha") != null) {
            alpha = (float)imageObject.getAlpha().intValue() / 255.0f;
        }
        Composite oldComposite = graphics.getComposite();
        graphics.setComposite(AlphaComposite.getInstance(10, alpha));
        graphics.setTransform(MatrixUtils.createAffineTransform(MatrixUtils.base()));
        graphics.drawImage(image, MatrixUtils.createAffineTransform(m), null);
        graphics.setComposite(oldComposite);
    }

    private BufferedImage getImage(ST_RefID refID) {
        if (refID == null) {
            return null;
        }
        CT_MultiMedia multiMedia = this.resourceManage.getMultiMedia(refID.toString());
        if (multiMedia == null) {
            return null;
        }
        if (MediaType.Image != multiMedia.getType()) {
            return null;
        }
        ST_Loc loc = multiMedia.getMediaFile();
        if (loc == null) {
            return null;
        }
        String srcPath = this.getResFilePath(loc.toString());
        BufferedImage image = null;
        try (FileInputStream in = new FileInputStream(srcPath);){
            image = loc.toString().endsWith("jb2") ? ImageUtils.readJB2(in) : ImageIO.read(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private void writeText(Graphics2D graphics, TextObject textObject, List<CT_DrawParam> drawParams, Matrix parentMatrix) {
        this.logger.debug("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501TextObject\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513");
        Color strokeColor = this.getStrokeColor((CT_Color)textObject.getStrokeColor(), null, drawParams);
        Color fillColor = this.getStrokeColor((CT_Color)textObject.getFillColor(), null, drawParams);
        if (fillColor == null) {
            fillColor = Color.black;
        }
        ST_Box boundary = textObject.getBoundary();
        Matrix baseMatrix = this.renderBoundaryAndSetClip(graphics, boundary, parentMatrix);
        TrueTypeFont typeFont = this.getFont(textObject);
        List fontMatrix = null;
        if (typeFont == null) {
            this.logger.error("\u52a0\u8f7d\u5b57\u4f53\u5931\u8d25\uff1a" + textObject.getFont());
            return;
        }
        try {
            this.logger.debug("\u5b57\u4f53\u540d\uff1a" + typeFont.getName());
            this.logger.debug("\u5b57\u4f53\u8868\uff1a" + typeFont.getTables().stream().map(ttfTable -> ttfTable.getTag() + " ").collect(Collectors.joining()));
            fontMatrix = typeFont.getFontMatrix();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List transforms = textObject.getCGTransforms();
        int globalPoint = 0;
        int transPoint = -1;
        if (transforms != null && transforms.size() >= 1) {
            transPoint = 0;
            transforms.stream().forEach(transform -> {
                if (transform.getCodePosition() == null) {
                    transform.setCodePosition(Integer.valueOf(0));
                }
            });
            transforms.sort((t1, t2) -> t1.getCodePosition() - t2.getCodePosition());
        }
        for (TextCode textCode : textObject.getTextCodes()) {
            Double y;
            int deltaOffset = -1;
            this.logger.debug("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501TextCode\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513");
            this.logger.debug("TextCode: " + textCode.getContent());
            this.logger.debug("DeltaX:" + textCode.getDeltaX());
            this.logger.debug("DeltaY:" + textCode.getDeltaY());
            List<Double> deltaX = ImageMaker.parseDelta(textCode.getDeltaX());
            List<Double> deltaY = ImageMaker.parseDelta(textCode.getDeltaY());
            Double x = textCode.getX();
            if (x == null) {
                x = 0.0;
            }
            if ((y = textCode.getY()) == null) {
                y = 0.0;
            }
            for (int j = 0; j < textCode.getContent().length(); ++j) {
                if (transPoint == -1 || globalPoint < ((CT_CGTransform)transforms.get(transPoint)).getCodePosition()) {
                    if (deltaOffset != -1) {
                        x = x + (deltaX == null || deltaX.size() < 0 ? 0.0 : (deltaOffset < deltaX.size() ? deltaX.get(deltaOffset) : deltaX.get(deltaX.size() - 1)));
                        y = y + (deltaY == null || deltaY.size() < 0 ? 0.0 : (deltaOffset < deltaY.size() ? deltaY.get(deltaOffset) : deltaY.get(deltaY.size() - 1)));
                    }
                    char c = textCode.getContent().charAt(j);
                    this.logger.debug(String.format("\u7f16\u7801\u7d22\u5f15 <%s> DeltaX:%s DeltaY:%s", Character.valueOf(c), x, y));
                    try {
                        int gid = typeFont.getUnicodeCmap().getGlyphId((int)c);
                        typeFont.getFontMatrix();
                        GlyphData glyphData = typeFont.getGlyph().getGlyph(gid);
                        if (glyphData == null) {
                            this.logger.debug(String.format("\u627e\u4e0d\u5230\u5b57\u5f62 %s", Character.valueOf(c)));
                        } else {
                            GeneralPath shape = glyphData.getPath();
                            this.logger.debug(String.format("\u5b57\u5f62Shape %s", shape));
                            Matrix matrix = this.chatMatrix(textObject, x, y, textObject.getSize(), fontMatrix, baseMatrix);
                            this.renderChar(graphics, shape, matrix, strokeColor, fillColor);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++globalPoint;
                    ++deltaOffset;
                    continue;
                }
                CT_CGTransform transform2 = (CT_CGTransform)transforms.get(transPoint);
                List glyphs = transform2.getGlyphs().getArray();
                this.logger.debug("\u5b57\u5f62\u53d8\u6362\uff1a" + transform2);
                for (String glyphStr : glyphs) {
                    Integer glyph = new Integer(glyphStr);
                    if (deltaOffset != -1) {
                        x = x + (deltaX == null || deltaX.size() < 0 ? 0.0 : (deltaOffset < deltaX.size() ? deltaX.get(deltaOffset) : deltaX.get(deltaX.size() - 1)));
                        y = y + (deltaY == null || deltaY.size() < 0 ? 0.0 : (deltaOffset < deltaY.size() ? deltaY.get(deltaOffset) : deltaY.get(deltaY.size() - 1)));
                    }
                    this.logger.debug(String.format("\u5b57\u5f62\u7d22\u5f15 <%s> DeltaX:%s DeltaY:%s", glyph, x, y));
                    try {
                        typeFont.getGlyph().getGlyphs();
                        GlyphData glyphData = typeFont.getGlyph().getGlyph(glyph.intValue());
                        if (glyphData != null) {
                            GeneralPath shape = glyphData.getPath();
                            Matrix matrix = this.chatMatrix(textObject, x, y, textObject.getSize(), fontMatrix, baseMatrix);
                            this.renderChar(graphics, shape, matrix, strokeColor, fillColor);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++deltaOffset;
                }
                transPoint = transPoint + 1 >= transforms.size() ? -1 : ++transPoint;
                globalPoint += transform2.getCodeCount() != null ? transform2.getCodeCount().intValue() : glyphs.size();
                j += transform2.getCodeCount() != null ? transform2.getCodeCount().intValue() : glyphs.size();
            }
            this.logger.debug("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b");
            globalPoint += textCode.getContent().length();
        }
        this.logger.debug("\u2517\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b");
    }

    private Matrix chatMatrix(TextObject ctText, Double deltaX, Double deltaY, Double fontSize, List<Number> fontMatrix, Matrix baseMatrix) {
        Matrix m = MatrixUtils.base();
        m = MatrixUtils.imageMatrix(m, 0.0, 1.0, 0.0);
        if (ctText.getHScale() != null) {
            m = MatrixUtils.scale(m, ctText.getHScale(), 1.0);
        }
        m = m.mtimes(MatrixUtils.create(fontMatrix.get(0).doubleValue(), fontMatrix.get(1).doubleValue(), fontMatrix.get(2).doubleValue(), fontMatrix.get(3).doubleValue(), fontMatrix.get(4).doubleValue(), fontMatrix.get(5).doubleValue()));
        m = MatrixUtils.scale(m, fontSize, fontSize);
        m = MatrixUtils.move(m, deltaX, deltaY);
        if (ctText.getCTM() != null) {
            m = m.mtimes(MatrixUtils.ctm(ctText.getCTM().toDouble()));
        }
        if (ctText.getBoundary() != null) {
            m = MatrixUtils.move(m, ctText.getBoundary().getTopLeftX(), ctText.getBoundary().getTopLeftY());
        }
        m = m.mtimes(baseMatrix);
        return m;
    }

    private void renderChar(Graphics2D graphics, Shape shape, Matrix m, Color stroke, Color fill) {
        graphics.setClip(null);
        graphics.setTransform(MatrixUtils.createAffineTransform(m));
        graphics.setStroke(new BasicStroke(0.1f));
        graphics.setColor(Color.BLACK);
        graphics.setBackground(Color.white);
        if (stroke != null) {
            graphics.setColor(stroke);
            graphics.draw(shape);
        }
        if (fill != null) {
            graphics.setColor(fill);
            graphics.fill(shape);
        }
    }

    private String getResFilePath(String filename) {
        String srcPath = this.ofdReader.getOFDDir().getSysAbsPath() + "/" + this.ofdReader.getOFDDocumentVo().getDocPath() + "/Res/" + filename;
        if (!new File(srcPath).exists()) {
            File file;
            if (filename.indexOf("/") >= 0) {
                filename = filename.substring(filename.lastIndexOf("/") + 1);
            }
            if ((file = ImageMaker.findFile(new File(this.ofdReader.getOFDDir().getSysAbsPath()), filename)) != null) {
                return file.getAbsolutePath();
            }
        }
        return srcPath;
    }

    private static File findFile(File dir, String filename) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                File res = ImageMaker.findFile(file, filename);
                if (res == null) continue;
                return res;
            }
            if (!file.getName().toLowerCase().equals(filename.toLowerCase())) continue;
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TrueTypeFont getFont(TextObject textObject) {
        ST_RefID stRefID = textObject.getFont();
        if (stRefID == null) {
            return null;
        }
        CT_Font ctFont = this.resourceManage.getFont(stRefID.toString());
        if (ctFont == null) {
            return null;
        }
        if (ctFont.getFontFile() == null) {
            this.logger.debug("\u52a0\u8f7d\u7cfb\u7edf\u5b57\u4f53\uff1a" + ctFont.getFamilyName() + " " + ctFont.getFontName());
            return FontUtils.loadSystemFont(ctFont.getFamilyName(), ctFont.getFontName());
        }
        String getFilePath = this.getResFilePath(ctFont.getFontFile().toString());
        this.logger.debug("\u52a0\u8f7d\u5185\u5d4c\u5b57\u4f53\uff1a" + getFilePath);
        OTFParser parser = new OTFParser(true);
        try (FileInputStream inputStream = new FileInputStream(getFilePath);){
            OpenTypeFont openTypeFont = parser.parse((InputStream)inputStream);
            return openTypeFont;
        }
        catch (IOException e) {
            this.logger.error("\u52a0\u8f7d\u5b57\u4f53\u51fa\u9519\uff1a" + e.getMessage());
            return null;
        }
    }

    private Matrix renderBoundaryAndSetClip(Graphics2D graphics, ST_Box boundary, Matrix parentMatrix) {
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(0.1f * (float)this.dpi));
        Matrix m = MatrixUtils.base().mtimes(parentMatrix);
        graphics.setTransform(MatrixUtils.createAffineTransform(m));
        if (boundary != null) {
            Polygon shape = new Polygon();
            Tuple2<Double, Double> p00 = MatrixUtils.pointTransform(m, boundary.getTopLeftX(), boundary.getTopLeftY() - 1.0);
            Tuple2<Double, Double> p01 = MatrixUtils.pointTransform(m, boundary.getTopLeftX() + boundary.getWidth() + 2.0, boundary.getTopLeftY() - 1.0);
            Tuple2<Double, Double> p10 = MatrixUtils.pointTransform(m, boundary.getTopLeftX(), boundary.getTopLeftY() + boundary.getHeight() + 2.0);
            Tuple2<Double, Double> p11 = MatrixUtils.pointTransform(m, boundary.getTopLeftX() + boundary.getWidth() + 2.0, boundary.getTopLeftY() + boundary.getHeight() + 2.0);
            shape.addPoint(Double.valueOf(p00.getFirst() * (double)this.dpi).intValue(), Double.valueOf(p00.getSecond() * (double)this.dpi).intValue());
            shape.addPoint(Double.valueOf(p01.getFirst() * (double)this.dpi).intValue(), Double.valueOf(p01.getSecond() * (double)this.dpi).intValue());
            shape.addPoint(Double.valueOf(p11.getFirst() * (double)this.dpi).intValue(), Double.valueOf(p11.getSecond() * (double)this.dpi).intValue());
            shape.addPoint(Double.valueOf(p10.getFirst() * (double)this.dpi).intValue(), Double.valueOf(p10.getSecond() * (double)this.dpi).intValue());
            if (this.config.drawBoundary) {
                graphics.setClip(null);
                graphics.drawPolygon(shape);
            }
            graphics.setClip(shape);
        }
        m = MatrixUtils.scale(m, this.dpi, this.dpi);
        return m;
    }

    private Path2D buildPath(String abbreviatedData) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, 0.0);
        String[] s = abbreviatedData.split("\\s+");
        int i = 0;
        block17: while (i < s.length) {
            String operator;
            switch (operator = s[i]) {
                case "S": 
                case "M": {
                    ((Path2D)path).moveTo(Double.valueOf(s[i + 1]), Double.valueOf(s[i + 2]));
                    i += 3;
                    continue block17;
                }
                case "L": {
                    ((Path2D)path).lineTo(Double.valueOf(s[i + 1]), Double.valueOf(s[i + 2]));
                    i += 3;
                    continue block17;
                }
                case "Q": {
                    ((Path2D)path).quadTo(Double.valueOf(s[i + 1]), Double.valueOf(s[i + 2]), Double.valueOf(s[i + 3]), Double.valueOf(s[i + 4]));
                    i += 5;
                    continue block17;
                }
                case "B": {
                    ((Path2D)path).curveTo(Double.valueOf(s[i + 1]), Double.valueOf(s[i + 2]), Double.valueOf(s[i + 3]), Double.valueOf(s[i + 4]), Double.valueOf(s[i + 5]), Double.valueOf(s[i + 6]));
                    i += 7;
                    continue block17;
                }
                case "A": {
                    i += 7;
                    continue block17;
                }
                case "C": {
                    path.closePath();
                    ++i;
                    continue block17;
                }
            }
            ++i;
        }
        return path;
    }

    private Double getLineWidth(CT_GraphicUnit graphicUnit, List<CT_DrawParam> drawParams) {
        Double lineWidth = graphicUnit.getLineWidth();
        if (lineWidth != null) {
            return lineWidth;
        }
        this.logger.debug("LineWidth \u4e3a\u7a7a\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c0.4\u6beb\u7c73");
        return 0.4;
    }

    private Color getStrokeColor(CT_Color color, CT_Color defaultColor, List<CT_DrawParam> drawParams) {
        CT_Color c = color;
        if (c == null) {
            CT_DrawParam drawParam;
            Iterator<CT_DrawParam> iterator = drawParams.iterator();
            while (iterator.hasNext() && (c = (drawParam = iterator.next()).getStrokeColor()) == null) {
            }
        }
        if (c == null) {
            c = defaultColor;
        }
        return this.getColor(c);
    }

    private Color getFillColor(CT_Color color, CT_Color defaultColor, List<CT_DrawParam> drawParams) {
        CT_Color c = color;
        if (c == null) {
            CT_DrawParam drawParam;
            Iterator<CT_DrawParam> iterator = drawParams.iterator();
            while (iterator.hasNext() && (c = (drawParam = iterator.next()).getFillColor()) == null) {
            }
        }
        if (c == null) {
            c = defaultColor;
        }
        return this.getColor(c);
    }

    public Color getColor(CT_Color ctColor) {
        if (ctColor == null) {
            return null;
        }
        ST_Array array = ctColor.getValue();
        OFDColorSpaceType type = OFDColorSpaceType.RGB;
        ST_RefID refID = ctColor.getColorSpace();
        Object ctColorSpace = null;
        if (refID != null) {
            this.resourceManage.getColorSpace(refID.toString());
        }
        if (ctColorSpace != null) {
            if (ctColorSpace.getType() != null) {
                type = ctColorSpace.getType();
            }
            if (array == null && ctColor.getIndex() != null) {
                array = ctColorSpace.getPalette().getColorByIndex(ctColor.getIndex());
            }
        }
        if (array == null) {
            return null;
        }
        int[] color = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            String s = (String)array.getArray().get(i);
            color[i] = s.startsWith("#") ? Integer.parseInt(s.replaceAll("#", ""), 16) : ("0.0".equals(s) ? 0 : Integer.valueOf(s));
        }
        switch (type) {
            case GRAY: {
                return new Color(color[0], color[0], color[0]);
            }
            case CMYK: {
                int r = 255 * (100 - color[0]) * (100 - color[3]) / 10000;
                int g = 255 * (100 - color[1]) * (100 - color[3]) / 10000;
                int b = 255 * (100 - color[2]) * (100 - color[3]) / 10000;
                return new Color(r, g, b);
            }
        }
        return new Color(color[0], color[1], color[2]);
    }

    public static List<Double> parseDelta(ST_Array array) {
        if (array == null) {
            return null;
        }
        ArrayList<Double> arr = new ArrayList<Double>();
        int i = 0;
        int counter = 0;
        while (i < array.size()) {
            String current = (String)array.getArray().get(i);
            if ("g".equals(current)) {
                Integer num = Integer.valueOf((String)array.getArray().get(i + 1));
                Double delta = Double.valueOf((String)array.getArray().get(i + 2));
                for (int j = 1; j <= num; ++j) {
                    arr.add(delta);
                    ++counter;
                }
                i += 3;
                continue;
            }
            Double delta = Double.valueOf(current);
            arr.add(delta);
            ++counter;
            ++i;
        }
        return arr;
    }

    public static class Config {
        private float stampOpacity = 0.75f;
        private boolean drawBoundary;

        public float getStampOpacity() {
            return this.stampOpacity;
        }

        public void setStampOpacity(float stampOpacity) {
            if (stampOpacity >= 0.0f && stampOpacity <= 1.0f) {
                this.stampOpacity = stampOpacity;
            }
        }

        public boolean isDrawBoundary() {
            return this.drawBoundary;
        }

        public void setDrawBoundary(boolean drawBoundary) {
            this.drawBoundary = drawBoundary;
        }
    }
}

