/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.jbig2.io.DefaultInputStreamFactory;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.ofdrw.converter.PdfBoxFontHolder;
import org.ofdrw.converter.image.ImageMedia;
import org.ofdrw.converter.point.PathPoint;
import org.ofdrw.converter.point.TextCodePoint;
import org.ofdrw.converter.utils.CommonUtil;
import org.ofdrw.converter.utils.PointUtil;
import org.ofdrw.core.annotation.pageannot.Annot;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.layer.CT_Layer;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CompositeObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_Pos;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.graph.pathObj.FillColor;
import org.ofdrw.core.graph.pathObj.StrokeColor;
import org.ofdrw.core.pageDescription.color.color.CT_AxialShd;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.color.color.Segment;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.DLOFDReader;
import org.ofdrw.reader.model.AnnotionVo;
import org.ofdrw.reader.model.OfdPageVo;
import org.ofdrw.reader.model.StampAnnotVo;

public class PdfboxMaker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, PDFont> pdfFontMap;
    private final Map<String, ImageMedia> imageMap;
    private final Map<String, CT_DrawParam> ctDrawParamMap;
    private final DLOFDReader ofdReader;
    private final PDDocument pdf;
    private final PdfBoxFontHolder fontHolder;

    public PdfboxMaker(DLOFDReader ofdReader, PDDocument pdf) throws IOException {
        this.ofdReader = ofdReader;
        this.pdf = pdf;
        this.imageMap = new HashMap<String, ImageMedia>();
        this.pdfFontMap = new HashMap<String, PDFont>();
        this.ctDrawParamMap = new HashMap<String, CT_DrawParam>();
        this.fontHolder = new PdfBoxFontHolder(pdf);
        for (Object ctFont : ofdReader.getOFDDocumentVo().getCtFontList()) {
            this.pdfFontMap.put(ctFont.getObjID().toString(), this.fontHolder.getFont(ctFont.getFontName()));
        }
        for (CT_MultiMedia multiMedia : ofdReader.getOFDDocumentVo().getCtMultiMediaList()) {
            String srcPath = ofdReader.getOFDDir().getSysAbsPath() + "/" + ofdReader.getOFDDocumentVo().getDocPath() + "/" + multiMedia.getMediaFile().toString();
            File imgFile = new File(srcPath);
            ImageMedia image = new ImageMedia();
            image.setFromat(multiMedia.getFormat());
            if (imgFile.exists()) {
                image.setData(FileUtils.readFileToByteArray((File)imgFile));
                this.imageMap.put(multiMedia.getID().toString(), image);
                continue;
            }
            srcPath = ofdReader.getOFDDir().getSysAbsPath() + "/" + ofdReader.getOFDDocumentVo().getDocPath() + "/Res/" + multiMedia.getMediaFile().toString();
            imgFile = new File(srcPath);
            if (!imgFile.exists()) continue;
            image.setData(FileUtils.readFileToByteArray((File)imgFile));
            this.imageMap.put(multiMedia.getID().toString(), image);
        }
        for (int j = 0; j < ofdReader.getOFDDocumentVo().getCtDrawParamList().size(); ++j) {
            this.ctDrawParamMap.put(((CT_DrawParam)ofdReader.getOFDDocumentVo().getCtDrawParamList().get(j)).getID().toString(), (CT_DrawParam)ofdReader.getOFDDocumentVo().getCtDrawParamList().get(j));
        }
        for (int i = 0; i < ofdReader.getOFDDocumentVo().getStampAnnotVos().size(); ++i) {
            StampAnnotVo stampAnnotVo = (StampAnnotVo)ofdReader.getOFDDocumentVo().getStampAnnotVos().get(i);
            if (!stampAnnotVo.getType().equals("ofd")) continue;
            for (int j = 0; j < stampAnnotVo.getCtDrawParamList().size(); ++j) {
                this.ctDrawParamMap.put(((CT_DrawParam)stampAnnotVo.getCtDrawParamList().get(j)).getID().toString() + "s", (CT_DrawParam)stampAnnotVo.getCtDrawParamList().get(j));
            }
            for (CT_Font ctFont : stampAnnotVo.getCtFontList()) {
                this.pdfFontMap.put(ctFont.getObjID().toString() + "s", this.fontHolder.getFont(ctFont.getFontName()));
            }
        }
    }

    public PDPage makePage(OfdPageVo pageVo) throws IOException {
        List layerList;
        Page contentPage = pageVo.getContentPage();
        Page templatePage = pageVo.getTemplatePage();
        ST_Box pageBox = CommonUtil.getPageBox(contentPage.getArea(), this.ofdReader.getOFDDocumentVo().getPageWidth(), this.ofdReader.getOFDDocumentVo().getPageHeight());
        double pageWidthPixel = CommonUtil.converterDpi(pageBox.getWidth());
        double pageHeightPixel = CommonUtil.converterDpi(pageBox.getHeight());
        PDRectangle pageSize = new PDRectangle((float)pageWidthPixel, (float)pageHeightPixel);
        PDPage pdfPage = new PDPage(pageSize);
        this.pdf.addPage(pdfPage);
        PDPageContentStream contentStream = new PDPageContentStream(this.pdf, pdfPage);
        if (!Objects.isNull(templatePage)) {
            layerList = templatePage.getContent().getLayers();
            this.writeLayer(this.pdf, contentStream, layerList, pageBox, null);
        }
        layerList = contentPage.getContent().getLayers();
        this.writeLayer(this.pdf, contentStream, layerList, pageBox, null);
        for (int i = 0; i < this.ofdReader.getOFDDocumentVo().getStampAnnotVos().size(); ++i) {
            StampAnnotVo stampAnnotVo = (StampAnnotVo)this.ofdReader.getOFDDocumentVo().getStampAnnotVos().get(i);
            List stampAnnots = stampAnnotVo.getStampAnnots();
            for (int j = 0; j < stampAnnots.size(); ++j) {
                StampAnnot stampAnnot = (StampAnnot)stampAnnots.get(j);
                if (!stampAnnot.getPageRef().toString().equals(contentPage.getObjID().toString())) continue;
                ST_Box sealBox = stampAnnot.getBoundary();
                ST_Box clipBox = stampAnnot.getClip();
                if (stampAnnotVo.getType().equals("ofd")) {
                    for (int k = 0; k < stampAnnotVo.getOfdPageVoList().size(); ++k) {
                        OfdPageVo sealPageVo = (OfdPageVo)stampAnnotVo.getOfdPageVoList().get(k);
                        layerList = sealPageVo.getContentPage().getContent().getLayers();
                        this.writeLayer(this.pdf, contentStream, layerList, pageBox, sealBox);
                    }
                    continue;
                }
                if (!stampAnnotVo.getType().equals("png")) continue;
                this.writeSealImage(contentStream, pageBox, stampAnnotVo.getImgByte(), sealBox, clipBox);
            }
        }
        for (AnnotionVo amap : this.ofdReader.getOFDDocumentVo().getAnnotaions()) {
            if (!pageVo.getContentPage().getObjID().toString().equals(amap.getPageId()) || null == amap.getAnnots()) continue;
            this.writeAnnoAppearance(this.pdf, contentStream, amap.getAnnots(), pageBox);
        }
        contentStream.close();
        return pdfPage;
    }

    private void writeLayer(PDDocument pdf, PDPageContentStream contentStream, List<CT_Layer> layerList, ST_Box box, ST_Box sealBox) throws IOException {
        for (CT_Layer layer : layerList) {
            List pageBlockTypeList = layer.getPageBlocks();
            this.writePageBlock(pdf, contentStream, box, sealBox, pageBlockTypeList, layer.getDrawParam(), null, null, null, null);
        }
    }

    private void writeAnnoAppearance(PDDocument pdf, PDPageContentStream contentStream, List<Annot> annotList, ST_Box box) throws IOException {
        for (Annot annot : annotList) {
            List pageBlockTypeList = annot.getAppearance().getPageBlocks();
            ST_Box annotBox = annot.getAppearance().getBoundary();
            this.writePageBlock(pdf, contentStream, box, null, pageBlockTypeList, null, annotBox, null, null, null);
        }
    }

    private void writePageBlock(PDDocument pdf, PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, List<PageBlockType> pageBlockTypeList, ST_RefID drawparam, ST_Box annotBox, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        CT_DrawParam ctDrawParam;
        PDColor defaultFillColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        PDColor defaultStrokeColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        float defaultLineWidth = 0.353f;
        if (drawparam != null && (ctDrawParam = this.ctDrawParamMap.get(drawparam.getRefId().toString() + (sealBox == null ? "" : "s"))) != null) {
            if (ctDrawParam.getRelative() != null) {
                CT_DrawParam re = this.ctDrawParamMap.get(ctDrawParam.getRelative().getRefId().toString() + (sealBox == null ? "" : "s"));
                if (re == null) {
                    return;
                }
                if (re.getStrokeColor() != null) {
                    defaultStrokeColor = CommonUtil.convertPDColor(re.getStrokeColor().getValue());
                }
                if (re.getFillColor() != null) {
                    defaultFillColor = CommonUtil.convertPDColor(re.getFillColor().getValue());
                }
                if (re.getLineWidth() != null) {
                    defaultLineWidth = re.getLineWidth().floatValue();
                }
            }
            if (ctDrawParam.getStrokeColor() != null) {
                defaultStrokeColor = CommonUtil.convertPDColor(ctDrawParam.getStrokeColor().getValue());
            }
            if (ctDrawParam.getFillColor() != null) {
                defaultFillColor = CommonUtil.convertPDColor(ctDrawParam.getFillColor().getValue());
            }
            if (ctDrawParam.getLineWidth() != null) {
                defaultLineWidth = ctDrawParam.getLineWidth().floatValue();
            }
        }
        block0: for (PageBlockType block : pageBlockTypeList) {
            if (block instanceof TextObject) {
                PDColor fillColor = defaultFillColor;
                TextObject textObject = (TextObject)block;
                int alpha = 255;
                if (textObject.getFillColor() != null) {
                    if (textObject.getFillColor().getValue() != null) {
                        fillColor = CommonUtil.convertPDColor(textObject.getFillColor().getValue());
                    } else if (textObject.getFillColor().getColorByType() != null) {
                        CT_AxialShd ctAxialShd = (CT_AxialShd)textObject.getFillColor().getColorByType();
                        fillColor = CommonUtil.convertPDColor(((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue());
                    }
                    alpha = textObject.getFillColor().getAlpha();
                }
                this.writeText(contentStream, box, sealBox, textObject, fillColor, alpha);
                continue;
            }
            if (block instanceof ImageObject) {
                ImageObject imageObject = (ImageObject)block;
                this.writeImage(contentStream, box, imageObject, annotBox);
                continue;
            }
            if (block instanceof PathObject) {
                PathObject pathObject = (PathObject)block;
                this.writePath(contentStream, box, sealBox, annotBox, pathObject, defaultFillColor, defaultStrokeColor, defaultLineWidth, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
                continue;
            }
            if (block instanceof CompositeObject) {
                CompositeObject compositeObject = (CompositeObject)block;
                for (CT_VectorG vectorG : this.ofdReader.getOFDDocumentVo().getCtVectorGList()) {
                    if (!vectorG.getID().toString().equals(compositeObject.getResourceID().toString())) continue;
                    Integer currentCompositeObjectAlpha = compositeObject.getAlpha();
                    ST_Box currentCompositeObjectBoundary = compositeObject.getBoundary();
                    ST_Array currentCompositeObjectCTM = compositeObject.getCTM();
                    this.writePageBlock(pdf, contentStream, box, sealBox, vectorG.getContent().getPageBlocks(), drawparam, annotBox, currentCompositeObjectAlpha, currentCompositeObjectBoundary, currentCompositeObjectCTM);
                    continue block0;
                }
                continue;
            }
            if (!(block instanceof CT_PageBlock)) continue;
            this.writePageBlock(pdf, contentStream, box, sealBox, ((CT_PageBlock)block).getPageBlocks(), drawparam, annotBox, compositeObjectAlpha, compositeObjectBoundary, compositeObjectCTM);
        }
    }

    private void writePath(PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, PDColor defaultFillColor, PDColor defaultStrokeColor, float defaultLineWidth, Integer compositeObjectAlpha, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        CT_DrawParam ctDrawParam;
        float lineWidth;
        contentStream.saveGraphicsState();
        if (pathObject.getStrokeColor() != null) {
            StrokeColor strokeColor = pathObject.getStrokeColor();
            if (strokeColor.getValue() != null) {
                contentStream.setStrokingColor(CommonUtil.convertPDColor(strokeColor.getValue()));
            } else {
                this.setShadingFill(contentStream, (CT_Color)strokeColor, false);
            }
        } else {
            contentStream.setStrokingColor(defaultStrokeColor);
        }
        float f = lineWidth = pathObject.getLineWidth() != null ? pathObject.getLineWidth().floatValue() : defaultLineWidth;
        if (pathObject.getDrawParam() != null && (ctDrawParam = this.ctDrawParamMap.get(pathObject.getDrawParam().getRefId().toString())) != null && ctDrawParam.getLineWidth() != null) {
            lineWidth = ctDrawParam.getLineWidth().floatValue();
        }
        if (pathObject.getCTM() != null && pathObject.getLineWidth() != null) {
            Double[] ctm = pathObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double e = ctm[4];
            double f2 = ctm[5];
            double sx = Math.signum(a) * Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            lineWidth = (float)((double)lineWidth * sx);
        }
        if (pathObject.getStroke().booleanValue()) {
            if (compositeObjectAlpha != null) {
                PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                graphicsState.setStrokingAlphaConstant(Float.valueOf((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f));
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            if (pathObject.getDashPattern() != null) {
                float unitsOn = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[0].floatValue());
                float unitsOff = (float)CommonUtil.converterDpi(pathObject.getDashPattern().toDouble()[1].floatValue());
                float phase = (float)CommonUtil.converterDpi(pathObject.getDashOffset().floatValue());
                contentStream.setLineDashPattern(new float[]{unitsOn, unitsOff}, phase);
            }
            contentStream.setLineJoinStyle(pathObject.getJoin().ordinal());
            contentStream.setLineCapStyle(pathObject.getCap().ordinal());
            contentStream.setMiterLimit(pathObject.getMiterLimit().floatValue());
            this.path(contentStream, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            contentStream.setLineWidth((float)CommonUtil.converterDpi(lineWidth));
            contentStream.stroke();
            contentStream.restoreGraphicsState();
        }
        if (pathObject.getFill().booleanValue()) {
            FillColor fillColor;
            contentStream.saveGraphicsState();
            if (compositeObjectAlpha != null) {
                PDExtendedGraphicsState graphicsState = new PDExtendedGraphicsState();
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)compositeObjectAlpha.intValue() * 1.0f / 255.0f));
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            if ((fillColor = (FillColor)pathObject.getFillColor()) != null) {
                if (fillColor.getValue() != null) {
                    contentStream.setNonStrokingColor(CommonUtil.convertPDColor(fillColor.getValue()));
                } else {
                    this.setShadingFill(contentStream, (CT_Color)fillColor, true);
                }
            } else {
                contentStream.setNonStrokingColor(defaultFillColor);
            }
            this.path(contentStream, box, sealBox, annotBox, pathObject, compositeObjectBoundary, compositeObjectCTM);
            contentStream.fill();
            contentStream.restoreGraphicsState();
        }
    }

    private void setShadingFill(PDPageContentStream contentStream, CT_Color ctColor, boolean isFill) throws IOException {
        CT_AxialShd ctAxialShd = (CT_AxialShd)ctColor.getColorByType();
        if (ctAxialShd == null) {
            return;
        }
        ST_Array start = ((Segment)ctAxialShd.getSegments().get(0)).getColor().getValue();
        ST_Array end = ((Segment)ctAxialShd.getSegments().get(ctAxialShd.getSegments().size() - 1)).getColor().getValue();
        ST_Pos startPos = ctAxialShd.getStartPoint();
        ST_Pos endPos = ctAxialShd.getEndPoint();
        if (isFill) {
            contentStream.setNonStrokingColor(CommonUtil.convertPDColor(end));
        } else {
            contentStream.setStrokingColor(CommonUtil.convertPDColor(end));
        }
    }

    private void path(PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, ST_Box annotBox, PathObject pathObject, ST_Box compositeObjectBoundary, ST_Array compositeObjectCTM) throws IOException {
        if (pathObject.getBoundary() == null) {
            return;
        }
        if (sealBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        if (annotBox != null) {
            pathObject.setBoundary(pathObject.getBoundary().getTopLeftX() + annotBox.getTopLeftX(), pathObject.getBoundary().getTopLeftY() + annotBox.getTopLeftY(), pathObject.getBoundary().getWidth().doubleValue(), pathObject.getBoundary().getHeight().doubleValue());
        }
        List<PathPoint> listPoint = PointUtil.calPdfPathPoint(box.getWidth(), box.getHeight(), pathObject.getBoundary(), PointUtil.convertPathAbbreviatedDatatoPoint(pathObject.getAbbreviatedData()), pathObject.getCTM() != null, pathObject.getCTM(), compositeObjectBoundary, compositeObjectCTM, true);
        for (int i = 0; i < listPoint.size(); ++i) {
            if (listPoint.get((int)i).type.equals("M") || listPoint.get((int)i).type.equals("S")) {
                contentStream.moveTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("L")) {
                contentStream.lineTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1);
                continue;
            }
            if (listPoint.get((int)i).type.equals("B")) {
                contentStream.curveTo(listPoint.get((int)i).x1, listPoint.get((int)i).y1, listPoint.get((int)i).x2, listPoint.get((int)i).y2, listPoint.get((int)i).x3, listPoint.get((int)i).y3);
                continue;
            }
            if (listPoint.get((int)i).type.equals("Q")) {
                contentStream.curveTo1(listPoint.get((int)i).x1, listPoint.get((int)i).y1, listPoint.get((int)i).x2, listPoint.get((int)i).y2);
                continue;
            }
            if (!listPoint.get((int)i).type.equals("C")) continue;
            contentStream.closePath();
        }
    }

    private void writeImage(PDPageContentStream contentStream, ST_Box box, ImageObject imageObject, ST_Box annotBox) throws IOException {
        if (this.imageMap.get(imageObject.getResourceID().toString()) == null) {
            return;
        }
        contentStream.saveGraphicsState();
        ImageMedia image = this.imageMap.get(imageObject.getResourceID().toString());
        boolean isJb2 = "GBIG2".equals(image.getFromat()) || "JB2".equals(image.getFromat());
        PDImageXObject pdfImageObject = LosslessFactory.createFromImage((PDDocument)this.pdf, (BufferedImage)this.readImageFile(isJb2, new ByteArrayInputStream(image.getData())));
        if (annotBox != null) {
            float x = annotBox.getTopLeftX().floatValue();
            float y = box.getHeight().floatValue() - (annotBox.getTopLeftY().floatValue() + annotBox.getHeight().floatValue());
            float width = annotBox.getWidth().floatValue();
            float height = annotBox.getHeight().floatValue();
            contentStream.drawImage(pdfImageObject, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        } else {
            Matrix matrix = CommonUtil.toPFMatrix(CommonUtil.getImageMatrixFromOfd(imageObject, box));
            contentStream.drawImage(pdfImageObject, matrix);
        }
        contentStream.restoreGraphicsState();
    }

    public BufferedImage readImageFile(boolean isJb2, InputStream image) throws IOException {
        if (isJb2) {
            DefaultInputStreamFactory defaultInputStreamFactory = new DefaultInputStreamFactory();
            ImageInputStream imageInputStream = defaultInputStreamFactory.getInputStream(image);
            JBIG2ImageReader imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
            imageReader.setInput((Object)imageInputStream);
            return imageReader.read(0, (ImageReadParam)imageReader.getDefaultReadParam());
        }
        return ImageIO.read(image);
    }

    private void writeSealImage(PDPageContentStream contentStream, ST_Box box, byte[] image, ST_Box sealBox, ST_Box clipBox) throws IOException {
        if (image == null) {
            return;
        }
        contentStream.saveGraphicsState();
        PDImageXObject pdfImageObject = PDImageXObject.createFromByteArray((PDDocument)this.pdf, (byte[])image, (String)"");
        float x = sealBox.getTopLeftX().floatValue();
        float y = box.getHeight().floatValue() - (sealBox.getTopLeftY().floatValue() + sealBox.getHeight().floatValue());
        float width = sealBox.getWidth().floatValue();
        float height = sealBox.getHeight().floatValue();
        if (clipBox != null) {
            contentStream.addRect((float)CommonUtil.converterDpi(x) + (float)CommonUtil.converterDpi(clipBox.getTopLeftX()), (float)CommonUtil.converterDpi(y) + (float)(CommonUtil.converterDpi(height) - (CommonUtil.converterDpi(clipBox.getTopLeftY()) + CommonUtil.converterDpi(clipBox.getHeight()))), (float)CommonUtil.converterDpi(clipBox.getWidth()), (float)CommonUtil.converterDpi(clipBox.getHeight()));
            contentStream.closePath();
            contentStream.clip();
            contentStream.stroke();
        }
        contentStream.drawImage(pdfImageObject, (float)CommonUtil.converterDpi(x), (float)CommonUtil.converterDpi(y), (float)CommonUtil.converterDpi(width), (float)CommonUtil.converterDpi(height));
        contentStream.restoreGraphicsState();
    }

    private void writeText(PDPageContentStream contentStream, ST_Box box, ST_Box sealBox, TextObject textObject, PDColor fillColor, int alpha) throws IOException {
        PDFont font;
        float fontSize = textObject.getSize().floatValue();
        String fontAno = "";
        if (sealBox != null && textObject.getBoundary() != null) {
            fontAno = "s";
            textObject.setBoundary(textObject.getBoundary().getTopLeftX() + sealBox.getTopLeftX(), textObject.getBoundary().getTopLeftY() + sealBox.getTopLeftY(), textObject.getBoundary().getWidth().doubleValue(), textObject.getBoundary().getHeight().doubleValue());
        }
        if (textObject.getCTM() != null) {
            Double[] ctm = textObject.getCTM().toDouble();
            double a = ctm[0];
            double b = ctm[1];
            double c = ctm[2];
            double d = ctm[3];
            double sx = a > 0.0 ? Math.signum(a) * Math.sqrt(a * a + c * c) : Math.sqrt(a * a + c * c);
            double sy = Math.signum(d) * Math.sqrt(b * b + d * d);
            double angel = Math.atan2(-b, d);
            if (angel != 0.0 || a == 0.0 || d != 1.0) {
                fontSize = (float)((double)fontSize * sx);
            }
        }
        if (Objects.isNull(font = this.pdfFontMap.get(textObject.getFont().toString() + fontAno))) {
            font = this.fontHolder.getFont("\u5b8b\u4f53");
        }
        List<TextCodePoint> textCodePointList = PointUtil.calPdfTextCoordinate(box.getWidth(), box.getHeight(), textObject.getBoundary(), fontSize, textObject.getTextCodes(), textObject.getCTM() != null, textObject.getCTM(), true);
        double rx = 0.0;
        double ry = 0.0;
        for (int i = 0; i < textCodePointList.size(); ++i) {
            TextCodePoint textCodePoint = textCodePointList.get(i);
            if (i == 0) {
                rx = textCodePoint.x;
                ry = textCodePoint.y;
            }
            contentStream.saveGraphicsState();
            contentStream.beginText();
            contentStream.setNonStrokingColor(fillColor);
            contentStream.newLineAtOffset((float)textCodePoint.getX(), (float)textCodePoint.getY());
            if (textObject.getCTM() != null) {
                Double[] ctm = textObject.getCTM().toDouble();
                double a = ctm[0];
                double b = ctm[1];
                double c = ctm[2];
                double d = ctm[3];
                AffineTransform transform = new AffineTransform();
                double angel = Math.atan2(-b, d);
                transform.rotate(angel, rx, ry);
                contentStream.concatenate2CTM(transform);
                if (angel == 0.0 && a != 0.0 && d == 1.0) {
                    textObject.setHScale(Double.valueOf(a));
                }
            }
            if (textObject.getHScale().floatValue() < 1.0f) {
                AffineTransform transform = new AffineTransform();
                transform.setTransform(textObject.getHScale().floatValue(), 0.0, 0.0, 1.0, (double)(1.0f - textObject.getHScale().floatValue()) * textCodePoint.getX(), 0.0);
                contentStream.concatenate2CTM(transform);
            }
            contentStream.setFont(font, (float)CommonUtil.converterDpi(fontSize));
            try {
                contentStream.showText(textCodePoint.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            contentStream.endText();
            contentStream.restoreGraphicsState();
        }
    }
}

