/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.util.HashMap;
import java.util.Map;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.DLOFDReader;

public class ResourceManage {
    private final Map<String, CT_DrawParam> ctDrawParamMap = new HashMap<String, CT_DrawParam>();
    private final Map<String, CT_MultiMedia> ctMultiMediaMap = new HashMap<String, CT_MultiMedia>();
    private final Map<String, CT_Font> ctFontMap = new HashMap<String, CT_Font>();
    private final Map<String, CT_ColorSpace> ctColorSpaceMap = new HashMap<String, CT_ColorSpace>();
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final DLOFDReader ofdReader;

    public ResourceManage(DLOFDReader ofdReader) {
        this.ofdReader = ofdReader;
        for (CT_DrawParam drawParam : ofdReader.getOFDDocumentVo().getCtDrawParamList()) {
            this.ctDrawParamMap.put(drawParam.getID().toString(), drawParam);
        }
        for (CT_MultiMedia multiMedia : ofdReader.getOFDDocumentVo().getCtMultiMediaList()) {
            this.ctMultiMediaMap.put(multiMedia.getID().toString(), multiMedia);
        }
        for (CT_Font ct_font : ofdReader.getOFDDocumentVo().getCtFontList()) {
            this.ctFontMap.put(ct_font.getID().toString(), ct_font);
        }
        for (CT_ColorSpace ctColorSpace : ofdReader.getOFDDocumentVo().getCtColorSpaceList()) {
            this.ctColorSpaceMap.put(ctColorSpace.getID().toString(), ctColorSpace);
        }
    }

    public CT_DrawParam getDrawParam(String id) {
        return this.ctDrawParamMap.get(id);
    }

    public CT_MultiMedia getMultiMedia(String id) {
        return this.ctMultiMediaMap.get(id);
    }

    public CT_Font getFont(String id) {
        return this.ctFontMap.get(id);
    }

    public CT_ColorSpace getColorSpace(String id) {
        return this.ctColorSpaceMap.get(id);
    }
}

