/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.ofdrw.converter.utils.OSinfo;
import org.ofdrw.converter.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtils {
    private static final Logger log = LoggerFactory.getLogger(FontUtils.class);
    private static Map<String, String> pathMapping = new HashMap<String, String>();
    private static Map<String, String> nameMapping = new HashMap<String, String>();
    private static Map<String, String> aliasMapping = new HashMap<String, String>();
    public static final String Separator = "$$$$";
    private static final String DEFAULT_FONT_DIR_MAC = "/System/Library/Fonts";
    private static final String DEFAULT_FONT_DIR_WINDOWS = "C:/Windows/Fonts";
    private static final String DEFAULT_FONT_DIR_LINUX = "/usr/share/fonts";
    private static TrueTypeFont defaultFont;

    public static void init() {
        try (InputStream in = FontUtils.class.getResourceAsStream("/fonts/simhei.ttf");){
            OTFParser parser = new OTFParser(false);
            defaultFont = parser.parse(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (OSinfo.isWindows()) {
            FontUtils.scanFontDir(new File(DEFAULT_FONT_DIR_WINDOWS));
        } else if (OSinfo.isMacOS()) {
            FontUtils.scanFontDir(new File(DEFAULT_FONT_DIR_MAC));
        } else if (OSinfo.isMacOSX()) {
            FontUtils.scanFontDir(new File(DEFAULT_FONT_DIR_MAC));
        } else if (OSinfo.isLinux()) {
            FontUtils.scanFontDir(new File(DEFAULT_FONT_DIR_LINUX));
        }
    }

    public static void addAliasMapping(String familyName, String fontName, String aliasFamilyName, String aliasFontName) {
        String key1 = familyName + Separator + fontName;
        String key2 = aliasFamilyName + Separator + aliasFontName;
        if (nameMapping.get(key2) == null || pathMapping.get(key2) == null) {
            log.error("\u8981\u8bbe\u7f6e\u522b\u540d\u7684\u5b57\u4f53\u4e0d\u5b58\u5728");
            return;
        }
        aliasMapping.put(key1, key2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSystemFontMapping(String familyName, String fontName, String fontFilePath) {
        File file;
        if (StringUtils.isBlank(familyName) || StringUtils.isBlank(fontName) || StringUtils.isBlank(fontFilePath)) {
            log.error(String.format("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0cFamilyName:%s FontName:%s \u8def\u5f84\uff1a%s", familyName, fontName, fontFilePath));
        }
        if (!(file = new File(fontFilePath)).exists()) {
            log.error(String.format("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0c\u5b57\u4f53\u6587\u4ef6\uff1a%s \u4e0d\u5b58\u5728", fontFilePath));
        }
        if (file.isDirectory()) {
            log.error(String.format("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0c%s \u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6", fontFilePath));
        }
        if (!(file.getName().toLowerCase().endsWith("otf") || file.getName().toLowerCase().endsWith("ttf") || file.getName().toLowerCase().endsWith("ttc"))) {
            log.error(String.format("\u6dfb\u52a0\u7cfb\u7edf\u5b57\u4f53\u6620\u5c04\u5931\u8d25\uff0c%s \u4e0d\u662f\u4e00\u4e2aOpenType\u5b57\u4f53\u6587\u4ef6", fontFilePath));
        }
        Map<String, String> map = pathMapping;
        synchronized (map) {
            pathMapping.put(familyName + Separator + fontName, fontFilePath);
        }
    }

    public static String getSystemFontPath(String familyName, String fontName) {
        String key;
        if (familyName == null) {
            familyName = "null";
        }
        if (aliasMapping.get(key = familyName + Separator + fontName) != null) {
            key = aliasMapping.get(key);
        }
        if (nameMapping.get(key) != null) {
            fontName = nameMapping.get(key);
        }
        String fontFilePath = pathMapping.get(key);
        return fontFilePath;
    }

    public static TrueTypeFont loadSystemFont(String familyName, String fontName) {
        String fontFilePath;
        String key;
        if (familyName == null) {
            familyName = "null";
        }
        if (aliasMapping.get(key = familyName + Separator + fontName) != null) {
            key = aliasMapping.get(key);
        }
        if (nameMapping.get(key) != null) {
            fontName = nameMapping.get(key);
        }
        if ((fontFilePath = pathMapping.get(key)) == null) {
            log.error("\u52a0\u8f7d\u7cfb\u7edf\u5b57\u4f53\u5931\u8d25\uff1a" + familyName + "," + fontName);
            return FontUtils.loadDefaultFont();
        }
        File file = new File(fontFilePath);
        try {
            if (fontFilePath.endsWith("ttc")) {
                TrueTypeCollection trueTypeCollection = new TrueTypeCollection(file);
                TrueTypeFont trueTypeFont = trueTypeCollection.getFontByName(fontName);
                return trueTypeFont;
            }
            OTFParser parser = new OTFParser(false);
            OpenTypeFont openTypeFont = parser.parse(file);
            return openTypeFont;
        }
        catch (IOException e) {
            e.printStackTrace();
            return FontUtils.loadSystemFont(null, fontName);
        }
    }

    private static TrueTypeFont loadDefaultFont() {
        return defaultFont;
    }

    public static void scanFontDir(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                FontUtils.scanFontDir(file);
                continue;
            }
            FontUtils.loadFont(file);
        }
    }

    public static void loadFont(final File file) {
        if (file.getName().toLowerCase().endsWith("ttc")) {
            try {
                TrueTypeCollection trueTypeCollection = new TrueTypeCollection(file);
                trueTypeCollection.processAllFonts(new TrueTypeCollection.TrueTypeFontProcessor(){

                    public void process(TrueTypeFont trueTypeFont) throws IOException {
                        NamingTable namingTable = trueTypeFont.getNaming();
                        FontUtils.addSystemFontMapping(namingTable, file.getPath());
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                log.warn("\u52a0\u8f7d\u5b57\u4f53\u5931\u8d25\uff1a" + file.getAbsolutePath());
            }
        }
        if (!file.getName().toLowerCase().endsWith("otf") && !file.getName().toLowerCase().endsWith("ttf")) {
            return;
        }
        try {
            OTFParser parser = new OTFParser(true);
            OpenTypeFont openTypeFont = parser.parse(file);
            NamingTable namingTable = openTypeFont.getNaming();
            FontUtils.addSystemFontMapping(namingTable, file.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("\u52a0\u8f7d\u5b57\u4f53\u5931\u8d25\uff1a" + file.getAbsolutePath());
        }
    }

    private static void addSystemFontMapping(NamingTable namingTable, String path) {
        String name = null;
        HashSet<String> familyNames = new HashSet<String>();
        HashSet<String> fontNames = new HashSet<String>();
        familyNames.add(namingTable.getFontFamily());
        fontNames.add(namingTable.getPostScriptName());
        name = namingTable.getPostScriptName();
        for (NameRecord record : namingTable.getNameRecords()) {
            if (record.getNameId() == 1) {
                familyNames.add(record.getString());
            } else if (record.getNameId() == 4) {
                fontNames.add(record.getString());
            }
            if (record.getLanguageId() != 0 || record.getNameId() != 4) continue;
            name = record.getString();
        }
        String finalName = name;
        familyNames.forEach(familyName -> fontNames.forEach(fontName -> {
            nameMapping.put(familyName + Separator + fontName, finalName);
            nameMapping.put("null$$$$" + fontName, finalName);
            log.info(String.format("\u6ce8\u518c\u5b57\u4f53 %s,%s,%s", familyName, fontName, path));
            FontUtils.addSystemFontMapping(familyName, fontName, path);
            FontUtils.addSystemFontMapping("null", fontName, path);
        }));
    }

    public static void main(String[] args) throws IOException {
        FontUtils.scanFontDir(new File(DEFAULT_FONT_DIR_WINDOWS));
        System.out.println(FontUtils.loadSystemFont("Microsoft YaHei", "MicrosoftYaHei"));
        System.out.println(FontUtils.loadSystemFont("Microsoft YaHei", "\u5fae\u8f6f\u96c5\u9ed1"));
        System.out.println(FontUtils.loadSystemFont("\u5fae\u8f6f\u96c5\u9ed1", "MicrosoftYaHei"));
        System.out.println(FontUtils.loadSystemFont("\u5fae\u8f6f\u96c5\u9ed1", "\u5fae\u8f6f\u96c5\u9ed1"));
    }
}

