/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.jbig2.io.DefaultInputStreamFactory;

public class ImageUtils {
    public static byte[] toBytes(BufferedImage bufferedImage, String type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean flag = ImageIO.write((RenderedImage)bufferedImage, type, out);
        byte[] bytes = out.toByteArray();
        return bytes;
    }

    public static BufferedImage readJB2(InputStream inputStream) {
        int imageIndex = 0;
        JBIG2ImageReader imageReader = null;
        try {
            DefaultInputStreamFactory disf = new DefaultInputStreamFactory();
            ImageInputStream imageInputStream = disf.getInputStream(inputStream);
            imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
            imageReader.setInput((Object)imageInputStream);
            BufferedImage bufferedImage = imageReader.read(imageIndex, (ImageReadParam)imageReader.getDefaultReadParam());
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage renderMask(BufferedImage image, BufferedImage mask) {
        if (image.getWidth() != mask.getWidth() || image.getHeight() != mask.getHeight()) {
            return image;
        }
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D graphics = out.createGraphics();
        graphics.setColor(Color.WHITE);
        out = graphics.getDeviceConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                boolean sholdMask;
                int rgb = mask.getRGB(x, y);
                int r = 0xFF & rgb;
                int g = 0xFF00 & rgb;
                int b = 0xFF0000 & rgb;
                boolean bl = sholdMask = (r + (g >>= 8) + (b >>= 16)) / 3 > 244;
                if (!sholdMask) continue;
                out.setRGB(x, y, image.getRGB(x, y));
            }
        }
        return out;
    }
}

