/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.ofdrw.converter.AWTMaker;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.tools.ImageUtils;

public class ImageMaker
extends AWTMaker {
    public ImageMaker(OFDReader reader, int ppm) {
        super(reader, ppm);
    }

    public ImageMaker(OFDReader reader, double ppm) {
        super(reader, ppm);
    }

    public BufferedImage makePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pages.size()) {
            throw new GeneralConvertException(String.format("%s \u4e0d\u662f\u6709\u6548\u7d22\u5f15", pageIndex));
        }
        PageInfo pageInfo = (PageInfo)this.pages.get(pageIndex);
        ST_Box pageBox = pageInfo.getSize();
        int pageWidthPixel = (int)Math.round(this.ppm * pageBox.getWidth());
        int pageHeightPixel = (int)Math.round(this.ppm * pageBox.getHeight());
        BufferedImage image = this.createImage(pageWidthPixel, pageHeightPixel);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        this.writePage(graphics, pageInfo, null);
        return image;
    }

    private BufferedImage createImage(int pageWidthPixel, int pageHeightPixel) {
        return ImageUtils.createImage((int)pageWidthPixel, (int)pageHeightPixel, (boolean)this.isStamp);
    }
}

