/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.basicStructure.ofd.docInfo;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.UUID;
import org.dom4j.Element;
import org.ofdrw.core.Const;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicStructure.ofd.docInfo.CustomDatas;
import org.ofdrw.core.basicStructure.ofd.docInfo.DocUsage;
import org.ofdrw.core.basicStructure.ofd.docInfo.Keywords;
import org.ofdrw.core.basicType.ST_Loc;

public class CT_DocInfo
extends OFDElement {
    public CT_DocInfo(Element proxy) {
        super(proxy);
    }

    public CT_DocInfo() {
        super("DocInfo");
    }

    public CT_DocInfo setDocID(UUID docID) {
        this.setOFDEntity("DocID", (Serializable)((Object)docID.toString().replace("-", "")));
        return this;
    }

    public CT_DocInfo randomDocID() {
        return this.setDocID(UUID.randomUUID());
    }

    public String getDocID() {
        return this.getOFDElementText("DocID");
    }

    public CT_DocInfo setTile(String title) {
        this.setOFDEntity("Title", (Serializable)((Object)title));
        return this;
    }

    public String getTile() {
        return this.getOFDElementText("Title");
    }

    public CT_DocInfo setAuthor(String author) {
        this.setOFDEntity("Author", (Serializable)((Object)author));
        return this;
    }

    public String getAuthor() {
        return this.getOFDElementText("Author");
    }

    public CT_DocInfo setSubject(String subject) {
        this.setOFDEntity("Subject", (Serializable)((Object)subject));
        return this;
    }

    public String getSubject() {
        return this.getOFDElementText("Subject");
    }

    public CT_DocInfo setAbstract(String abstractTxt) {
        this.setOFDEntity("Abstract", (Serializable)((Object)abstractTxt));
        return this;
    }

    public String getAbstract() {
        return this.getOFDElementText("Abstract");
    }

    public CT_DocInfo setCreationDate(LocalDate creationDate) {
        this.setOFDEntity("CreationDate", (Serializable)((Object)creationDate.toString()));
        return this;
    }

    public LocalDate getCreationDate() {
        String dateStr = this.getOFDElementText("CreationDate");
        return dateStr != null ? LocalDate.parse(dateStr, Const.DATE_FORMATTER) : null;
    }

    public CT_DocInfo setModDate(LocalDate modDate) {
        this.setOFDEntity("ModDate", (Serializable)((Object)modDate.toString()));
        return this;
    }

    public LocalDate getModDate() {
        String dateStr = this.getOFDElementText("ModDate");
        return dateStr != null ? LocalDate.parse(dateStr, Const.DATE_FORMATTER) : null;
    }

    public CT_DocInfo setDocUsage(DocUsage docUsage) {
        if (docUsage == null) {
            this.setOFDEntity("DocUsage", (Serializable)((Object)DocUsage.Normal.toString()));
        } else {
            this.setOFDEntity("DocUsage", (Serializable)((Object)docUsage.toString()));
        }
        return this;
    }

    public DocUsage getDocUsage() {
        String usageStr = this.getOFDElementText("DocUsage");
        return DocUsage.getInstance(usageStr);
    }

    public CT_DocInfo setCover(ST_Loc cover) {
        this.set(cover.getElement("Cover"));
        return this;
    }

    public ST_Loc getCover() {
        String locStr = this.getOFDElementText("Cover");
        if (locStr == null || locStr.trim().length() == 0) {
            return null;
        }
        return new ST_Loc(locStr);
    }

    public CT_DocInfo setKeywords(Keywords keywords) {
        this.set(keywords);
        return this;
    }

    public CT_DocInfo addKeyword(String keyword) {
        Keywords keywords = this.getKeywords();
        if (keywords == null) {
            keywords = new Keywords();
            this.add(keywords);
        }
        keywords.addKeyword(keyword);
        return this;
    }

    public Keywords getKeywords() {
        Element element = this.getOFDElement("Keywords");
        return element == null ? null : new Keywords(element);
    }

    public CT_DocInfo setCreator(String creator) {
        this.setOFDEntity("Creator", (Serializable)((Object)creator));
        return this;
    }

    public String getCreator() {
        return this.getOFDElementText("Creator");
    }

    public CT_DocInfo setCreatorVersion(String creatorVersion) {
        this.setOFDEntity("CreatorVersion", (Serializable)((Object)creatorVersion));
        return this;
    }

    public String getCreatorVersion() {
        return this.getOFDElementText("CreatorVersion");
    }

    public CT_DocInfo setCustomDatas(CustomDatas customDatas) {
        this.set(customDatas);
        return this;
    }

    public CustomDatas getCustomDatas() {
        Element element = this.getOFDElement("CustomDatas");
        return element == null ? null : new CustomDatas(element);
    }

    @Override
    public String getQualifiedName() {
        return "ofd:DocInfo";
    }
}

