/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.crypto.encryt;

import java.io.Serializable;
import java.time.LocalDateTime;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.core.Const;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.crypto.encryt.Provider;
import org.ofdrw.core.signatures.sig.Parameters;

public class CT_EncryptInfo
extends OFDElement {
    public CT_EncryptInfo(Element proxy) {
        super(proxy);
    }

    public CT_EncryptInfo() {
        super("EncryptInfo");
    }

    public CT_EncryptInfo setID(@NotNull String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u64cd\u4f5c\u6807\u8bc6(id)\u4e3a\u7a7a");
        }
        this.addAttribute("ID", id);
        return this;
    }

    @NotNull
    public String getID() {
        return this.attributeValue("ID");
    }

    public CT_EncryptInfo setRelative(String id) {
        if (id == null) {
            this.removeAttr("Relative");
            return this;
        }
        this.addAttribute("Relative", id);
        return this;
    }

    @Nullable
    public String getRelative() {
        return this.attributeValue("Relative");
    }

    public CT_EncryptInfo setProvider(@NotNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u7ec4\u4ef6\u7684\u76f8\u5173\u4fe1\u606f\uff08Provider\uff09\u4e3a\u7a7a");
        }
        this.set(provider);
        return this;
    }

    @NotNull
    public Provider getProvider() {
        Element e = this.getOFDElement("Provider");
        if (e == null) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u7ec4\u4ef6\u7684\u76f8\u5173\u4fe1\u606f\uff08Provider\uff09\u4e3a\u7a7a");
        }
        return new Provider(e);
    }

    public CT_EncryptInfo setEncryptScope(@NotNull String encryptScope) {
        if (encryptScope == null) {
            throw new IllegalArgumentException("\u6587\u6863\u52a0\u5bc6\u76f8\u5173\u5185\u5bb9\u7684\u63cf\u8ff0\uff08EncryptScope\uff09\u4e3a\u7a7a");
        }
        this.setOFDEntity("EncryptScope", (Serializable)((Object)encryptScope));
        return this;
    }

    @NotNull
    public String getEncryptScope() {
        Element e = this.getOFDElement("EncryptScope");
        if (e == null) {
            throw new IllegalArgumentException("\u6587\u6863\u52a0\u5bc6\u76f8\u5173\u5185\u5bb9\u7684\u63cf\u8ff0\uff08EncryptScope\uff09\u4e3a\u7a7a");
        }
        return e.getTextTrim();
    }

    public CT_EncryptInfo setParameters(@Nullable Parameters parameters) {
        if (parameters == null) {
            this.removeOFDElemByNames("Parameters");
            return this;
        }
        this.set(parameters);
        return this;
    }

    @Nullable
    public Parameters getParameters() {
        Element e = this.getOFDElement("Parameters");
        return e == null ? null : new Parameters(e);
    }

    public CT_EncryptInfo setEncryptDate(LocalDateTime encryptDate) {
        if (encryptDate == null) {
            this.removeOFDElemByNames("EncryptDate");
            return this;
        }
        this.setOFDEntity("EncryptDate", (Serializable)((Object)encryptDate.format(Const.DATETIME_FORMATTER)));
        return this;
    }

    public LocalDateTime getEncryptDate() {
        String str = this.getOFDElementText("EncryptDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return LocalDateTime.parse(str, Const.DATETIME_FORMATTER);
    }

    public String getEncryptDateStr() {
        return this.getOFDElementText("EncryptDate");
    }

    public CT_EncryptInfo setDecryptSeedLoc(@NotNull ST_Loc decryptSeedLoc) {
        if (decryptSeedLoc == null) {
            throw new IllegalArgumentException("\u6307\u5411\u5305\u5185\u7684\u4e8c\u8fdb\u5236\u5bc6\u94a5\u63cf\u8ff0\u6587\u4ef6(decryptSeedLoc)\u4e3a\u7a7a");
        }
        this.setOFDEntity("DecryptSeedLoc", (Serializable)((Object)decryptSeedLoc.toString()));
        return this;
    }

    public CT_EncryptInfo setDecryptSeedLoc(@NotNull String decryptSeedLoc) {
        if (decryptSeedLoc == null) {
            throw new IllegalArgumentException("\u6307\u5411\u5305\u5185\u7684\u4e8c\u8fdb\u5236\u5bc6\u94a5\u63cf\u8ff0\u6587\u4ef6(decryptSeedLoc)\u4e3a\u7a7a");
        }
        this.setOFDEntity("DecryptSeedLoc", (Serializable)((Object)decryptSeedLoc));
        return this;
    }

    @NotNull
    public ST_Loc getDecryptSeedLoc() {
        return ST_Loc.getInstance(this.getOFDElementText("DecryptSeedLoc"));
    }

    public CT_EncryptInfo setEntriesMapLoc(ST_Loc entriesMapLoc) {
        if (entriesMapLoc == null) {
            throw new IllegalArgumentException("\u660e\u5bc6\u6587\u6620\u5c04\u8868\u6216\u5176\u52a0\u5bc6\u540e\u7684\u6587\u4ef6\u5b58\u50a8\u7684\u8def\u5f84\uff08entriesMapLoc\uff09\u4e3a\u7a7a");
        }
        this.setOFDEntity("EntriesMapLoc", (Serializable)((Object)entriesMapLoc.toString()));
        return this;
    }

    public CT_EncryptInfo setEntriesMapLoc(String entriesMapLoc) {
        if (entriesMapLoc == null) {
            throw new IllegalArgumentException("\u660e\u5bc6\u6587\u6620\u5c04\u8868\u6216\u5176\u52a0\u5bc6\u540e\u7684\u6587\u4ef6\u5b58\u50a8\u7684\u8def\u5f84\uff08entriesMapLoc\uff09\u4e3a\u7a7a");
        }
        this.setOFDEntity("EntriesMapLoc", (Serializable)((Object)entriesMapLoc));
        return this;
    }

    public ST_Loc getEntriesMapLoc() {
        String entriesMapLoc = this.getOFDElementText("EntriesMapLoc");
        if (entriesMapLoc == null) {
            throw new IllegalArgumentException("\u660e\u5bc6\u6587\u6620\u5c04\u8868\u6216\u5176\u52a0\u5bc6\u540e\u7684\u6587\u4ef6\u5b58\u50a8\u7684\u8def\u5f84\uff08entriesMapLoc\uff09\u4e3a\u7a7a");
        }
        return ST_Loc.getInstance(entriesMapLoc);
    }
}

