/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;
import org.ofdrw.core.Const;
import org.ofdrw.core.DefaultElementProxy;
import org.ofdrw.core.OFDCommonQName;
import org.ofdrw.core.OFDSimpleTypeElement;
import org.ofdrw.core.basicType.ST_ID;

public class OFDElement
extends DefaultElementProxy {
    public OFDElement(Element proxy) {
        super(proxy);
    }

    protected OFDElement(String name) {
        super(name, Const.OFD_NAMESPACE);
    }

    public static OFDElement getInstance(String name) {
        return new OFDElement(name);
    }

    public OFDElement addOFDEntity(String name, Serializable value) {
        this.add(new OFDSimpleTypeElement(name, value));
        return this;
    }

    public OFDElement setOFDEntity(String name, Serializable value) {
        if (value == null) {
            this.removeOFDElemByNames(name);
            return this;
        }
        Element e = this.getOFDElement(name);
        if (e == null) {
            return this.addOFDEntity(name, value);
        }
        e.setText(value.toString());
        return this;
    }

    public OFDElement setOFDName(String name) {
        this.setQName(new QName(name, Const.OFD_NAMESPACE));
        return this;
    }

    public Element getOFDElement(String name) {
        return this.element(new OFDCommonQName(name));
    }

    public <R extends OFDElement> R getOFDElement(String name, Function<? super Element, ? extends R> mapper) {
        Element e = this.getOFDElement(name);
        if (e == null) {
            return null;
        }
        return (R)((OFDElement)mapper.apply((Element)e));
    }

    public boolean removeAttr(String name) {
        Attribute a = this.attribute(name);
        if (a != null) {
            return this.remove(a);
        }
        return false;
    }

    public String getOFDElementText(String name) {
        Element element = this.getOFDElement(name);
        return element == null ? null : element.getText();
    }

    public <R> List<R> getOFDElements(String name, Function<? super Element, ? extends R> mapper) {
        List<Element> elements = this.elements(new OFDCommonQName(name));
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyList();
        }
        return elements.stream().map(mapper).collect(Collectors.toList());
    }

    public OFDElement set(Element element) {
        if (element == null) {
            return this;
        }
        List<Element> old = this.elements(element.getQName());
        if (old != null && !old.isEmpty()) {
            for (Element toBeReplace : old) {
                this.remove(toBeReplace);
            }
        }
        this.add(element);
        return this;
    }

    public List<Element> removeOFDElemByNames(String ... names) {
        LinkedList<Element> deleteElements = new LinkedList<Element>();
        if (names == null) {
            return null;
        }
        for (String name : names) {
            if (name == null || name.trim().length() == 0) continue;
            for (Element element : this.getOFDElements(name, OFDElement::new)) {
                if (element == null) continue;
                this.remove(element);
                deleteElements.add(element);
            }
        }
        return deleteElements;
    }

    public OFDElement setObjID(ST_ID objId) {
        this.addAttribute("ID", objId.toString());
        return this;
    }

    public OFDElement setObjID(long objId) {
        return this.setObjID(new ST_ID(objId));
    }

    public OFDElement removeAll() {
        this.elements().forEach(this::remove);
        return this;
    }

    public ST_ID getObjID() {
        return ST_ID.getInstance(this.attributeValue("ID"));
    }

    @Override
    public String getQualifiedName() {
        return this.proxy.getQualifiedName();
    }
}

