/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.frameworkgui;

import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.ogema.accesscontrol.AccessManager;
import org.ogema.accesscontrol.PermissionManager;
import org.ogema.core.administration.AdministrationManager;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.logging.OgemaLogger;
import org.ogema.core.resourcemanager.ResourceAccess;
import org.ogema.core.resourcemanager.ResourceManagement;
import org.ogema.frameworkgui.FrameworkGUIController;
import org.ogema.frameworkgui.FrameworkGUIServlet;
import org.osgi.framework.BundleContext;

@Component(specVersion="1.2", immediate=true)
@Service(value={Application.class})
public class FrameworkGUI
implements Application {
    protected OgemaLogger logger;
    protected ApplicationManager appMan;
    protected ResourceManagement resMan;
    protected ResourceAccess resAcc;
    @Reference
    private AdministrationManager administrationManager;
    @Reference
    private PermissionManager permissionManager;
    BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        this.logger = appManager.getLogger();
        this.resMan = appManager.getResourceManagement();
        this.resAcc = appManager.getResourceAccess();
        this.logger.debug("{} started", (Object)this.getClass().getName());
        AccessManager accessManager = this.permissionManager.getAccessManager();
        FrameworkGUIController controller = new FrameworkGUIController(this.administrationManager, this.bundleContext, accessManager, this.permissionManager);
        appManager.getWebAccessManager().registerWebResource("/ogema", "org/ogema/frameworkgui/gui");
        appManager.getWebAccessManager().registerWebResource("/apps/ogema/framework/gui", (Servlet)new FrameworkGUIServlet(controller));
    }

    public void stop(Application.AppStopReason reason) {
        if (this.appMan == null) {
            return;
        }
        this.appMan.getWebAccessManager().unregisterWebResource("/ogema");
        this.appMan.getWebAccessManager().unregisterWebResource("/apps/ogema/framework/gui");
        this.logger.debug("{} stopped", (Object)this.getClass().getName());
        this.appMan = null;
        this.resAcc = null;
        this.resMan = null;
        this.logger = null;
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext = null;
        try {
            this.stop(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void bindAdministrationManager(AdministrationManager administrationManager) {
        this.administrationManager = administrationManager;
    }

    protected void unbindAdministrationManager(AdministrationManager administrationManager) {
        if (this.administrationManager == administrationManager) {
            this.administrationManager = null;
        }
    }

    protected void bindPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    protected void unbindPermissionManager(PermissionManager permissionManager) {
        if (this.permissionManager == permissionManager) {
            this.permissionManager = null;
        }
    }
}

