/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.frameworkgui;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ogema.accesscontrol.AccessManager;
import org.ogema.accesscontrol.PermissionManager;
import org.ogema.core.administration.AdminApplication;
import org.ogema.core.administration.AdministrationManager;
import org.ogema.core.application.AppID;
import org.ogema.frameworkgui.json.AppsJsonGet;
import org.ogema.frameworkgui.json.AppsJsonWebResource;
import org.ogema.frameworkgui.utils.AppCompare;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class FrameworkGUIController {
    private final AdministrationManager administrationManager;
    private final BundleContext bundleContext;
    private final AccessManager accessManager;
    private final PermissionManager permissionManager;

    public FrameworkGUIController(AdministrationManager administrationManager, BundleContext bundleContext, AccessManager accessManager, PermissionManager permissionManager) {
        this.administrationManager = administrationManager;
        this.bundleContext = bundleContext;
        this.accessManager = accessManager;
        this.permissionManager = permissionManager;
    }

    public StringBuffer appsList2JSON(String user) {
        StringBuffer sb = new StringBuffer();
        ArrayList apps = (ArrayList)this.administrationManager.getAllApps();
        LinkedHashMap<String, AppsJsonGet> map = new LinkedHashMap<String, AppsJsonGet>();
        ObjectMapper mapper = new ObjectMapper();
        String result = "{}";
        for (AdminApplication entry : apps) {
            String name = entry.getID().getBundle().getSymbolicName();
            if (!this.accessManager.isAppPermitted(user, entry.getID())) continue;
            String fileName = entry.getID().getBundle().getLocation();
            int lastSeperator = fileName.lastIndexOf("/");
            fileName = fileName.substring(lastSeperator + 1, fileName.length());
            long id = entry.getBundleRef().getBundleId();
            HashMap<String, String> metainfo = new HashMap<String, String>();
            metainfo.put("File_Name", fileName);
            Bundle bundle = entry.getBundleRef();
            Dictionary bundleDictionary = bundle.getHeaders();
            Enumeration dictionaryEnums = bundleDictionary.keys();
            while (dictionaryEnums.hasMoreElements()) {
                String key = (String)dictionaryEnums.nextElement();
                String element = (String)bundleDictionary.get(key);
                if ("Import-Package".equals(key) || "Export-Package".equals(key)) continue;
                String formattedKey = key.replace('-', '_');
                metainfo.put(formattedKey, element);
            }
            AppsJsonGet singleApp = new AppsJsonGet();
            singleApp.setName(name);
            singleApp.setId(id);
            singleApp.setMetainfo(metainfo);
            StringBuffer jsonBuffer = this.webResourceTree2JSON(entry, "#", null);
            String jsonString = jsonBuffer.toString();
            List webResourcesApp = new ArrayList();
            try {
                webResourcesApp = (List)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, AppsJsonWebResource.class));
            }
            catch (IOException ex) {
                LoggerFactory.getLogger(this.getClass()).error(ex.toString());
            }
            if (((AppsJsonWebResource)webResourcesApp.get(0)).getAlias().equals("null")) {
                singleApp.setHasWebResources(false);
                continue;
            }
            singleApp.setHasWebResources(true);
            singleApp.getWebResourcePaths().add(((AppsJsonWebResource)webResourcesApp.get(0)).getAlias());
            map.put(name, singleApp);
        }
        ArrayList list = new ArrayList(map.values());
        Collections.sort(list, new AppCompare());
        try {
            result = mapper.writeValueAsString(list);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        sb.append(result);
        return sb;
    }

    public StringBuffer webResourceTree2JSON(AdminApplication app, String path, String alias) {
        int index = 0;
        StringBuffer sb = new StringBuffer();
        if (path.equals("#")) {
            AppID appid = app.getID();
            String baseUrl = this.permissionManager.getWebAccess(appid).getStartUrl();
            HashMap<String, String> entries = new HashMap<String, String>();
            entries.put(baseUrl, appid.getIDString());
            Set entrySet = entries.entrySet();
            sb.append('[');
            for (Map.Entry e : entrySet) {
                String key = (String)e.getKey();
                String name = (String)e.getValue();
                if (index++ != 0) {
                    sb.append(',');
                }
                sb.append("{\"text\":\"");
                sb.append(key);
                sb.append('\"');
                sb.append(',');
                sb.append("\"id\":\"");
                sb.append(name);
                sb.append('\"');
                sb.append(',');
                sb.append("\"alias\":\"");
                sb.append(key);
                sb.append('\"');
                sb.append(',');
                sb.append("\"children\":true");
                sb.append('}');
            }
            sb.append(']');
            return sb;
        }
        Bundle b = app.getBundleRef();
        Enumeration entries = b.findEntries(path, null, false);
        if (entries != null) {
            sb.append('[');
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                String file = url.getFile();
                boolean isDir = true;
                if (b.findEntries(file, null, false) == null) {
                    isDir = false;
                }
                if (index++ != 0) {
                    sb.append(',');
                }
                sb.append("{\"text\":\"");
                sb.append(file.replaceFirst(path, alias));
                sb.append('\"');
                sb.append(',');
                sb.append("\"id\":\"");
                sb.append(file);
                sb.append('\"');
                sb.append(',');
                sb.append("\"alias\":\"");
                sb.append(file.replaceFirst(path, alias));
                sb.append('\"');
                sb.append(',');
                if (isDir) {
                    sb.append("\"children\":true");
                } else {
                    sb.append("\"children\":false");
                }
                sb.append('}');
            }
            sb.append(']');
            return sb;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

