/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.frameworkgui;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ogema.accesscontrol.SessionAuth;
import org.ogema.frameworkgui.FrameworkGUIController;
import org.ogema.frameworkgui.utils.BundleIcon;

public class FrameworkGUIServlet
extends HttpServlet {
    private static final long serialVersionUID = -6186673043383854564L;
    private final FrameworkGUIController controller;
    private final BundleIcon defaultIcon = new BundleIcon(((Object)((Object)this)).getClass().getResource("/org/ogema/frameworkgui/gui/img/svg/appdefaultlogo.svg"), BundleIcon.IconType.SVG);

    public FrameworkGUIServlet(FrameworkGUIController controller) {
        this.controller = controller;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        String path = req.getPathInfo();
        String action = req.getParameter("action");
        if ("logout".equals(action)) {
            req.getSession().invalidate();
            resp.setStatus(200);
            return;
        }
        SessionAuth sesAuth = (SessionAuth)req.getSession().getAttribute("ogemaAuth");
        String user = null;
        if (sesAuth != null) {
            user = sesAuth.getName();
        }
        if ("/installedapps".equals(path)) {
            if ("listAll".equals(action)) {
                StringBuffer sb = this.controller.appsList2JSON(user);
                String data = sb.toString();
                this.printResponse(resp, data);
            } else if ("getIcon".equals(action)) {
                int id = Integer.valueOf(req.getParameter("id"));
                BundleIcon.forBundle(this.controller.getBundleContext().getBundle((long)id), this.defaultIcon).writeIcon(resp);
            }
        }
    }

    private void printResponse(HttpServletResponse resp, String data) throws IOException {
        PrintWriter pw = resp.getWriter();
        pw.print(data);
        resp.setStatus(200);
    }
}

