/*
 * Decompiled with CFR 0.152.
 */
package org.ogema.frameworkgui.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;

public class BundleIcon {
    private final URL url;
    private final IconType type;

    public BundleIcon(URL url, IconType type) {
        this.url = url;
        this.type = type;
    }

    public static BundleIcon forBundle(Bundle b, BundleIcon defaultIcon) {
        URL url = b.getResource("/icon.svg");
        if (url != null) {
            return new BundleIcon(url, IconType.SVG);
        }
        url = b.getResource("/icon.png");
        if (url != null) {
            return new BundleIcon(url, IconType.PNG);
        }
        url = b.getResource("/icon.jpg");
        if (url != null) {
            return new BundleIcon(url, IconType.JPG);
        }
        return defaultIcon;
    }

    public void writeIcon(HttpServletResponse resp) throws IOException {
        resp.setContentType(this.type.contentType);
        byte[] buf = new byte[4096];
        try (InputStream is = this.url.openStream();
             ServletOutputStream out = resp.getOutputStream();){
            int len;
            while ((len = is.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
    }

    public static enum IconType {
        PNG("image/png"),
        JPG("image/jpg"),
        SVG("image/svg+xml");

        private final String contentType;

        private IconType(String contentType) {
            this.contentType = contentType;
        }
    }
}

