/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.assertion;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.omnaest.utils.time.DurationCapture;

public class Assert {
    public static void fails() {
        Assert.fails("Operation failed");
    }

    public static void fails(String message) {
        throw new FailedOperationException(message);
    }

    public static void fails(String message, Exception cause) {
        throw new FailedOperationException(message, cause);
    }

    public static void fails(Exception cause) {
        throw new FailedOperationException("Operation failed", cause);
    }

    public static boolean isNotNull(Object object) {
        return Assert.isNotNull(object, "Object was null, but must be not null");
    }

    public static boolean isNotNull(Object object, Object ... objects) {
        Assert.isNotNull(object);
        for (Object iObject : objects) {
            Assert.isNotNull(iObject);
        }
        return true;
    }

    public static boolean isNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isNotNull(String message, Object object1, Object object2, Object ... objects) {
        Assert.isNotNull(object1, message);
        Assert.isNotNull(object2, message);
        for (Object iObject : objects) {
            Assert.isNotNull(iObject, message);
        }
        return true;
    }

    public static boolean isTrue(boolean expression) {
        return Assert.isTrue(new boolean[]{expression});
    }

    public static boolean isTrue(boolean ... expressions) {
        return Assert.isTrue("Expression must be true, but was false", expressions);
    }

    public static boolean isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isTrue(String message, boolean ... expressions) {
        for (boolean expression : expressions) {
            Assert.isTrue(expression, message);
        }
        return true;
    }

    public static boolean isFalse(boolean expression) {
        return Assert.isFalse(expression, "Expression must be false, but was true");
    }

    public static boolean isFalse(boolean expression, String message) {
        return Assert.isTrue(!expression, message);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return Assert.isNotEmpty(collection, "Collection must be not empty");
    }

    public static boolean isNotEmpty(Collection<?> collection, String message) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean areEqual(Object object1, Object object2) {
        return Assert.areEqual(object1, object2, "The two given objects must be equal");
    }

    public static boolean areEqual(Object object1, Object object2, String message) {
        if (!(object1 == object2 || object1 != null && object1.equals(object2) || object2 != null && object2.equals(object1))) {
            throw new IllegalArgumentException(message);
        }
        return true;
    }

    public static boolean isInterimTimeLowerThan(int durationLimit, TimeUnit timeUnit, DurationCapture durationCapture, Object[] intervalKeys) {
        boolean retval = false;
        if (timeUnit != null && durationCapture != null) {
            long durationLimitInMilliseconds;
            long interimTimeInMilliseconds = durationCapture.getInterimTimeInMilliseconds(intervalKeys);
            retval = Assert.isTrue(interimTimeInMilliseconds <= (durationLimitInMilliseconds = timeUnit.toMillis(durationLimit)), "Interim time for the interval keys " + String.valueOf(intervalKeys) + " should be lower than " + durationLimitInMilliseconds + " ms but actually was " + interimTimeInMilliseconds + " ms");
        }
        return retval;
    }

    public static class FailedOperationException
    extends RuntimeException {
        private static final long serialVersionUID = 8884612146655100366L;

        public FailedOperationException(String message) {
            super(message);
        }

        public FailedOperationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

