/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.assertion;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.time.DurationCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertLogger
implements Serializable {
    private static final long serialVersionUID = 830408918854821772L;
    public final Logger logger;
    public final Loglevel trace;
    public final Loglevel debug;
    public final Loglevel info;
    public final Loglevel warn;
    public final Loglevel error;

    public AssertLogger(Class<?> type) {
        this(LoggerFactory.getLogger(type));
    }

    public AssertLogger(final Logger logger) {
        Assert.isNotNull((Object)logger, "Logger reference must not be null, but a null reference has been given");
        this.logger = logger;
        this.trace = new LoglevelImpl(new LoglevelImpl.LoglevelSupport(){
            private static final long serialVersionUID = 7211946266092536103L;

            @Override
            public void writeMessage(String message, Throwable e) {
                logger.trace(message, e);
            }

            @Override
            public void writeMessage(String message) {
                logger.trace(message);
            }

            @Override
            public boolean isLoglevelEnabled() {
                return logger.isTraceEnabled();
            }
        });
        this.debug = new LoglevelImpl(new LoglevelImpl.LoglevelSupport(){
            private static final long serialVersionUID = -8205878887500731466L;

            @Override
            public void writeMessage(String message, Throwable e) {
                logger.debug(message, e);
            }

            @Override
            public void writeMessage(String message) {
                logger.debug(message);
            }

            @Override
            public boolean isLoglevelEnabled() {
                return logger.isDebugEnabled();
            }
        });
        this.info = new LoglevelImpl(new LoglevelImpl.LoglevelSupport(){
            private static final long serialVersionUID = -763948000020211389L;

            @Override
            public void writeMessage(String message, Throwable e) {
                logger.info(message, e);
            }

            @Override
            public void writeMessage(String message) {
                logger.info(message);
            }

            @Override
            public boolean isLoglevelEnabled() {
                return logger.isInfoEnabled();
            }
        });
        this.warn = new LoglevelImpl(new LoglevelImpl.LoglevelSupport(){
            private static final long serialVersionUID = -5760294798817317257L;

            @Override
            public void writeMessage(String message, Throwable e) {
                logger.warn(message, e);
            }

            @Override
            public void writeMessage(String message) {
                logger.warn(message);
            }

            @Override
            public boolean isLoglevelEnabled() {
                return logger.isWarnEnabled();
            }
        });
        this.error = new LoglevelImpl(new LoglevelImpl.LoglevelSupport(){
            private static final long serialVersionUID = 8052613300931257305L;

            @Override
            public void writeMessage(String message, Throwable e) {
                logger.error(message, e);
            }

            @Override
            public void writeMessage(String message) {
                logger.error(message);
            }

            @Override
            public boolean isLoglevelEnabled() {
                return logger.isErrorEnabled();
            }
        });
    }

    public DirectAssert assertThat() {
        return new DirectAssertImpl();
    }

    private class DirectAssertImpl
    implements DirectAssert,
    DirectAssertWithExpression,
    DirectAssertHandler,
    DirectAssertHandlerMessageChoice {
        private static final long serialVersionUID = -885293756532927338L;
        private boolean assertResult = true;
        private String message = null;
        private Exception catchedException = null;
        private boolean failureHandling = true;

        private DirectAssertImpl() {
        }

        @Override
        public DirectAssertWithExpression isInterimTimeLowerThan(int durationLimit, TimeUnit timeUnit, DurationCapture durationCapture, Object[] intervalKeys) {
            try {
                Assert.isInterimTimeLowerThan(durationLimit, timeUnit, durationCapture, intervalKeys);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression fails(Exception cause) {
            try {
                Assert.fails(cause);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression fails() {
            try {
                Assert.fails();
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression isNotNull(Object object, Object ... objects) {
            try {
                Assert.isNotNull(object, objects);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression isNotNull(Object object) {
            try {
                Assert.isNotNull(object);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression isNotEmpty(Collection<?> collection) {
            try {
                Assert.isNotEmpty(collection);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression areEqual(Object object1, Object object2) {
            try {
                Assert.areEqual(object1, object2);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression isFalse(boolean expression) {
            try {
                Assert.isFalse(expression);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public DirectAssertWithExpression isTrue(boolean expression) {
            try {
                Assert.isTrue(expression);
            }
            catch (Exception e) {
                this.assertResult = false;
                this.catchedException = e;
            }
            return this;
        }

        @Override
        public boolean getAssertResult() {
            return this.assertResult;
        }

        @Override
        public DirectAssert and() {
            return this;
        }

        @Override
        public DirectAssertHandler onFailure() {
            this.failureHandling = true;
            return this;
        }

        @Override
        public DirectAssertHandler onSuccess() {
            this.failureHandling = false;
            return this;
        }

        @Override
        public void throwException() throws Exception {
            if (!this.isTriggerEventProhibited()) {
                if (this.message != null) {
                    throw new RuntimeException(this.message, this.catchedException);
                }
                throw new Exception(this.catchedException);
            }
        }

        private boolean isTriggerEventProhibited() {
            return !this.failureHandling && !this.assertResult || this.failureHandling && this.assertResult;
        }

        @Override
        public void throwException(Exception exception) throws Exception {
            if (!this.isTriggerEventProhibited() && exception != null) {
                throw exception;
            }
        }

        @Override
        public void throwException(Throwable throwable) throws Throwable {
            if (!this.isTriggerEventProhibited() && throwable != null) {
                throw throwable;
            }
        }

        @Override
        public void throwException(RuntimeException runtimeException) {
            if (!this.isTriggerEventProhibited() && runtimeException != null) {
                throw runtimeException;
            }
        }

        @Override
        public void throwRuntimeException() {
            if (!this.isTriggerEventProhibited()) {
                if (this.message != null) {
                    throw new RuntimeException(this.message, this.catchedException);
                }
                throw new RuntimeException(this.catchedException);
            }
        }

        private void log(Loglevel loglevel) {
            if (!this.isTriggerEventProhibited()) {
                if (this.message != null) {
                    loglevel.message(this.message, (Throwable)this.catchedException);
                } else {
                    loglevel.message(this.catchedException);
                }
            }
        }

        @Override
        public DirectAssertHandler logWithMessage(DirectAssertHandlerMessageChoice.LogLevel logLevel, String message) {
            if (logLevel != null && !this.isTriggerEventProhibited()) {
                this.message = message;
                this.logAs(logLevel);
            }
            return this;
        }

        @Override
        public DirectAssertHandler logWithMessage(DirectAssertHandlerMessageChoice.LogLevel logLevel, Factory<String> messageFactory) {
            if (logLevel != null && !this.isTriggerEventProhibited()) {
                this.message = messageFactory != null ? messageFactory.newInstance() : null;
                this.logAs(logLevel);
            }
            return this;
        }

        @Override
        public DirectAssertHandler logAs(DirectAssertHandlerMessageChoice.LogLevel logLevel) {
            if (logLevel != null) {
                if (DirectAssertHandlerMessageChoice.LogLevel.ERROR.equals((Object)logLevel)) {
                    this.log(AssertLogger.this.error);
                } else if (DirectAssertHandlerMessageChoice.LogLevel.WARN.equals((Object)logLevel)) {
                    this.log(AssertLogger.this.warn);
                } else if (DirectAssertHandlerMessageChoice.LogLevel.INFO.equals((Object)logLevel)) {
                    this.log(AssertLogger.this.info);
                } else if (DirectAssertHandlerMessageChoice.LogLevel.DEBUG.equals((Object)logLevel)) {
                    this.log(AssertLogger.this.debug);
                } else if (DirectAssertHandlerMessageChoice.LogLevel.TRACE.equals((Object)logLevel)) {
                    this.log(AssertLogger.this.trace);
                }
            }
            return this;
        }
    }

    public static interface DirectAssert
    extends Serializable {
        public DirectAssertWithExpression isInterimTimeLowerThan(int var1, TimeUnit var2, DurationCapture var3, Object[] var4);

        public DirectAssertWithExpression fails(Exception var1);

        public DirectAssertWithExpression fails();

        public DirectAssertWithExpression isNotNull(Object var1, Object ... var2);

        public DirectAssertWithExpression isNotNull(Object var1);

        public DirectAssertWithExpression isNotEmpty(Collection<?> var1);

        public DirectAssertWithExpression areEqual(Object var1, Object var2);

        public DirectAssertWithExpression isFalse(boolean var1);

        public DirectAssertWithExpression isTrue(boolean var1);
    }

    public static interface DirectAssertWithExpression
    extends DirectAssert,
    DirectAssertResultValueProvider,
    DirectAssertSuccessFailureChoice {
        public DirectAssert and();
    }

    public static interface DirectAssertSuccessFailureChoice {
        public DirectAssertHandler onFailure();

        public DirectAssertHandler onSuccess();
    }

    public static interface DirectAssertHandler
    extends DirectAssertResultValueProvider,
    Serializable,
    DirectAssertHandlerMessageChoice,
    DirectAssertSuccessFailureChoice {
        public void throwException() throws Exception;

        public void throwRuntimeException();

        public void throwException(RuntimeException var1);

        public void throwException(Exception var1) throws Exception;

        public void throwException(Throwable var1) throws Throwable;

        public DirectAssertHandler logAs(DirectAssertHandlerMessageChoice.LogLevel var1);
    }

    public static interface DirectAssertResultValueProvider {
        public boolean getAssertResult();
    }

    public static interface DirectAssertHandlerMessageChoice {
        public DirectAssertHandler logWithMessage(LogLevel var1, String var2);

        public DirectAssertHandler logWithMessage(LogLevel var1, Factory<String> var2);

        public static enum LogLevel {
            ERROR,
            WARN,
            INFO,
            DEBUG,
            TRACE;

        }
    }

    protected static class LoglevelImpl
    implements Loglevel,
    LoglevelAssert {
        private static final long serialVersionUID = -1253381257506882164L;
        private final LoglevelSupport loglevelSupport;

        protected LoglevelImpl(LoglevelSupport loglevelSupport) {
            this.loglevelSupport = loglevelSupport;
        }

        @Override
        public Loglevel message(String message) {
            this.loglevelSupport.writeMessage(message);
            return this;
        }

        @Override
        public Loglevel message(String message, Throwable e) {
            if (e != null) {
                this.loglevelSupport.writeMessage(message, e);
            } else {
                this.loglevelSupport.writeMessage(message);
            }
            return this;
        }

        @Override
        public Loglevel message(Throwable e) {
            this.loglevelSupport.writeMessage("Exception occurred", e);
            return this;
        }

        @Override
        public Loglevel message(MessageFactory messageFactory) {
            if (this.loglevelSupport.isLoglevelEnabled()) {
                String message = messageFactory != null ? messageFactory.message() : "";
                this.loglevelSupport.writeMessage(message);
            }
            return this;
        }

        @Override
        public Loglevel message(MessageFactory messageFactory, Throwable e) {
            if (this.loglevelSupport.isLoglevelEnabled()) {
                String message = messageFactory != null ? messageFactory.message() : "";
                this.loglevelSupport.writeMessage(message, e);
            }
            return this;
        }

        @Override
        public boolean isTrue(boolean expression) {
            try {
                return Assert.isTrue(expression);
            }
            catch (Exception e) {
                this.message("Assert.isTrue(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isTrue(boolean expression, String message) {
            try {
                return Assert.isTrue(expression, message);
            }
            catch (Exception e) {
                this.message("Assert.isTrue(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isFalse(boolean expression) {
            try {
                return Assert.isFalse(expression);
            }
            catch (Exception e) {
                this.message("Assert.isFalse(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isFalse(boolean expression, String message) {
            try {
                return Assert.isFalse(expression, message);
            }
            catch (Exception e) {
                this.message("Assert.isFalse(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean areEqual(Object object1, Object object2) {
            try {
                return Assert.areEqual(object1, object2);
            }
            catch (Exception e) {
                this.message("Assert.isEqual(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean areEqual(Object object1, Object object2, String message) {
            try {
                return Assert.areEqual(object1, object2, message);
            }
            catch (Exception e) {
                this.message("Assert.isEqual(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isNotEmpty(Collection<?> collection) {
            try {
                return Assert.isNotEmpty(collection);
            }
            catch (Exception e) {
                this.message("Assert.isNotEmpty(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isNotEmpty(Collection<?> collection, String message) {
            try {
                return Assert.isNotEmpty(collection, message);
            }
            catch (Exception e) {
                this.message("Assert.isNotEmpty(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isNotNull(Object object) {
            try {
                return Assert.isNotNull(object);
            }
            catch (Exception e) {
                this.message("Assert.isNotNull(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isNotNull(Object object, Object ... objects) {
            try {
                return Assert.isNotNull(object, objects);
            }
            catch (Exception e) {
                this.message("Assert.isNotNull(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isNotNull(Object object, String message) {
            try {
                return Assert.isNotNull(object, message);
            }
            catch (Exception e) {
                this.message("Assert.isNotNull(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isNotNull(String message, Object object, Object ... objects) {
            try {
                return Assert.isNotNull(message, object, (Object)objects, new Object[0]);
            }
            catch (Exception e) {
                this.message("Assert.isNotNull(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public void fails() {
            try {
                Assert.fails();
            }
            catch (Exception e) {
                this.message("Assert.fails() notifies about an operation failureHandling", (Throwable)e);
            }
        }

        @Override
        public void fails(Exception cause) {
            try {
                Assert.fails(cause);
            }
            catch (Exception e) {
                this.message("Assert.fails() notifies about an operation failureHandling", (Throwable)e);
            }
        }

        @Override
        public void fails(String message) {
            try {
                Assert.fails(message);
            }
            catch (Exception e) {
                this.message("Assert.fails() notifies about an operation failureHandling", (Throwable)e);
            }
        }

        @Override
        public void fails(String message, Exception cause) {
            try {
                Assert.fails(message, cause);
            }
            catch (Exception e) {
                this.message("Assert.fails() notifies about an operation failureHandling", (Throwable)e);
            }
        }

        @Override
        public boolean isInterimTimeLowerThan(int durationLimit, TimeUnit timeUnit, DurationCapture durationCapture, Object[] intervalKeys) {
            try {
                return Assert.isInterimTimeLowerThan(durationLimit, timeUnit, durationCapture, intervalKeys);
            }
            catch (Exception e) {
                this.message("Assert.isInterimTimeLowerThan(...) failed", (Throwable)e);
                return false;
            }
        }

        @Override
        public LoglevelAssert assertThat() {
            return this;
        }

        public static interface LoglevelSupport
        extends Serializable {
            public boolean isLoglevelEnabled();

            public void writeMessage(String var1);

            public void writeMessage(String var1, Throwable var2);
        }
    }

    public static interface LoglevelAssert
    extends Serializable {
        public boolean isInterimTimeLowerThan(int var1, TimeUnit var2, DurationCapture var3, Object[] var4);

        public void fails(String var1, Exception var2);

        public void fails(String var1);

        public void fails(Exception var1);

        public void fails();

        public boolean isNotNull(String var1, Object var2, Object ... var3);

        public boolean isNotNull(Object var1, String var2);

        public boolean isNotNull(Object var1, Object ... var2);

        public boolean isNotNull(Object var1);

        public boolean isNotEmpty(Collection<?> var1, String var2);

        public boolean isNotEmpty(Collection<?> var1);

        public boolean areEqual(Object var1, Object var2, String var3);

        public boolean areEqual(Object var1, Object var2);

        public boolean isFalse(boolean var1, String var2);

        public boolean isFalse(boolean var1);

        public boolean isTrue(boolean var1, String var2);

        public boolean isTrue(boolean var1);
    }

    public static interface Loglevel
    extends Serializable {
        public LoglevelAssert assertThat();

        public Loglevel message(MessageFactory var1, Throwable var2);

        public Loglevel message(MessageFactory var1);

        public Loglevel message(Throwable var1);

        public Loglevel message(String var1, Throwable var2);

        public Loglevel message(String var1);
    }

    public static interface MessageFactory {
        public String message();
    }
}

