/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.beans.adapter.PropertynameMapToTypeAdapter;
import org.omnaest.utils.beans.mapconverter.BeanToNestedMapConverter;
import org.omnaest.utils.beans.result.BeanMethodInformation;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;
import org.omnaest.utils.beans.result.BeanPropertyAccessors;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentity;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.tuple.Tuple2;

public class BeanUtils {
    public static <B> Map<String, Object> transformBeanIntoMap(B bean) {
        LinkedHashMap<String, Object> retmap = new LinkedHashMap<String, Object>();
        if (bean != null) {
            Class<?> clazz = bean.getClass();
            Object beanAdapter = PropertynameMapToTypeAdapter.newInstance(retmap, clazz);
            BeanUtils.copyPropertyValues(bean, beanAdapter);
        }
        return retmap;
    }

    public static int numberOfProperties(Class<?> beanClass) {
        return BeanUtils.beanPropertyAccessorSet(beanClass).size();
    }

    public static <B> Set<BeanPropertyAccessor<B>> beanPropertyAccessorSet(Class<B> beanClass) {
        HashSet<BeanPropertyAccessor<B>> retset = new HashSet<BeanPropertyAccessor<B>>();
        if (beanClass != null) {
            Map<String, BeanPropertyAccessor<B>> fieldnameToBeanPropertyAccessorMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass);
            retset.addAll(fieldnameToBeanPropertyAccessorMap.values());
        }
        return retset;
    }

    public static <B> BeanPropertyAccessors<B> beanPropertyAccessors(Class<B> beanClass) {
        return new BeanPropertyAccessors<B>(BeanUtils.beanPropertyAccessorSet(beanClass));
    }

    public static <B> List<B> propertyValueList(B bean, String ... propertyNames) {
        return new ArrayList<B>(BeanUtils.propertyValueList(bean, Arrays.asList(propertyNames)));
    }

    public static <B> List<B> propertyValueList(B bean, Collection<String> propertyNameCollection) {
        return new ArrayList(BeanUtils.propertyNameToBeanPropertyValueMap(bean, propertyNameCollection).values());
    }

    public static <B> List<B> propertyValueList(B bean) {
        Class<?> type = bean != null ? bean.getClass() : null;
        String[] propertyNames = BeanUtils.propertyNamesForMethodAccess(type);
        return BeanUtils.propertyValueList(bean, propertyNames);
    }

    public static <B, A extends Annotation> Map<String, A> propertyNameToBeanPropertyAnnotationMap(Class<B> beanClass, final Class<A> annotationType) {
        Map retmap = null;
        if (beanClass != null && annotationType != null) {
            Map<String, Set<Annotation>> propertyNameToBeanPropertyAnnotationSetMap = BeanUtils.propertyNameToBeanPropertyAnnotationSetMap(beanClass);
            ElementConverterIdentity keyElementConverter = new ElementConverterIdentity();
            ElementConverter valueElementConverter = new ElementConverter<Set<Annotation>, A>(){

                @Override
                public A convert(Set<Annotation> annotationSet) {
                    Annotation retval = null;
                    if (annotationSet != null) {
                        for (Annotation annotation : annotationSet) {
                            Class<? extends Annotation> currentAnnotationType = annotation.annotationType();
                            if (!annotationType.isAssignableFrom(currentAnnotationType)) continue;
                            retval = annotation;
                            break;
                        }
                    }
                    return retval;
                }
            };
            retmap = MapUtils.convertMap(propertyNameToBeanPropertyAnnotationSetMap, keyElementConverter, valueElementConverter);
        }
        return retmap;
    }

    public static <B> Map<String, Set<Annotation>> propertyNameToBeanPropertyAnnotationSetMap(Class<B> beanClass) {
        HashMap<String, Set<Annotation>> retmap = new HashMap<String, Set<Annotation>>();
        Map<String, BeanPropertyAccessor<B>> propertyNameToBeanPropertyAccessorMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass);
        for (String propertyName : propertyNameToBeanPropertyAccessorMap.keySet()) {
            Method methodSetter;
            Method methodGetter;
            Annotation[] annotations;
            BeanPropertyAccessor<B> beanPropertyAccessor = propertyNameToBeanPropertyAccessorMap.get(propertyName);
            HashSet<Annotation> annotationSet = new HashSet<Annotation>();
            Field field = beanPropertyAccessor.getField();
            if (field != null && (annotations = field.getDeclaredAnnotations()) != null) {
                annotationSet.addAll(Arrays.asList(annotations));
            }
            if ((methodGetter = beanPropertyAccessor.getMethodGetter()) != null && (annotations = methodGetter.getDeclaredAnnotations()) != null) {
                annotationSet.addAll(Arrays.asList(annotations));
            }
            if ((methodSetter = beanPropertyAccessor.getMethodSetter()) != null && (annotations = methodSetter.getDeclaredAnnotations()) != null) {
                annotationSet.addAll(Arrays.asList(annotations));
            }
            retmap.put(propertyName, annotationSet);
        }
        return retmap;
    }

    public static <B, V> Map<String, V> propertyNameToBeanPropertyValueMap(B bean, String ... propertyNames) {
        return BeanUtils.propertyNameToBeanPropertyValueMap(bean, Arrays.asList(propertyNames));
    }

    public static <B, V> Map<String, V> propertyNameToBeanPropertyValueMap(B bean, Collection<String> propertyNameCollection) {
        LinkedHashMap<String, V> retmap = new LinkedHashMap<String, V>();
        if (bean != null && propertyNameCollection != null) {
            Map<String, V> propertyNameToBeanPropertyValueMap = BeanUtils.propertyNameToBeanPropertyValueMap(bean);
            for (String propertyName : propertyNameCollection) {
                if (!propertyNameToBeanPropertyValueMap.containsKey(propertyName)) continue;
                retmap.put(propertyName, propertyNameToBeanPropertyValueMap.get(propertyName));
            }
        }
        return retmap;
    }

    public static <B, V> Map<String, V> propertyNameToBeanPropertyValueMap(B bean) {
        Class<?> beanClass;
        Map<String, BeanPropertyAccessor<?>> propertynameToBeanPropertyAccessorMap;
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        if (bean != null && (propertynameToBeanPropertyAccessorMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass = bean.getClass())) != null) {
            for (String propertyName : propertynameToBeanPropertyAccessorMap.keySet()) {
                BeanPropertyAccessor<?> beanPropertyAccessor = propertynameToBeanPropertyAccessorMap.get(propertyName);
                if (beanPropertyAccessor == null || !beanPropertyAccessor.hasGetter()) continue;
                try {
                    Object propertyValue = beanPropertyAccessor.getPropertyValue(bean);
                    retmap.put(propertyName, propertyValue);
                }
                catch (Exception e) {}
            }
        }
        return retmap;
    }

    public static <B> Map<String, BeanPropertyAccessor<B>> propertyNameToBeanPropertyAccessorMap(Class<B> beanClass, Field ... fields) {
        LinkedHashMap<String, BeanPropertyAccessor<B>> retmap = new LinkedHashMap<String, BeanPropertyAccessor<B>>();
        if (beanClass != null && fields != null) {
            for (Field field : fields) {
                String fieldname = field.getName();
                Method methodGetter = null;
                Method methodSetter = null;
                retmap.put(fieldname, new BeanPropertyAccessor<B>(field, methodGetter, methodSetter, fieldname, beanClass));
            }
        }
        return retmap;
    }

    public static <B> Map<String, BeanPropertyAccessor<B>> propertyNameToBeanPropertyAccessorMap(Class<B> beanClass, Method ... methods) {
        LinkedHashMap<String, BeanPropertyAccessor<B>> retmap = new LinkedHashMap<String, BeanPropertyAccessor<B>>();
        if (beanClass != null && methods != null) {
            Map<String, Set<BeanMethodInformation>> fieldnameToBeanMethodInformationMap = BeanUtils.propertyNameToBeanMethodInformationMap(methods);
            for (String fieldname : fieldnameToBeanMethodInformationMap.keySet()) {
                if (StringUtils.isBlank((CharSequence)fieldname) || "class".equals(fieldname)) continue;
                Method methodGetter = null;
                Method methodSetter = null;
                for (BeanMethodInformation beanMethodInformation : fieldnameToBeanMethodInformationMap.get(fieldname)) {
                    if (beanMethodInformation.isGetter() || beanMethodInformation.isGetterWithAdditionalArguments()) {
                        methodGetter = beanMethodInformation.getMethod();
                        continue;
                    }
                    if (!beanMethodInformation.isSetter() && !beanMethodInformation.isSetterWithAdditionalArguments()) continue;
                    methodSetter = beanMethodInformation.getMethod();
                }
                if (methodGetter == null && methodSetter == null) continue;
                Field field = null;
                retmap.put(fieldname, new BeanPropertyAccessor<B>(field, methodGetter, methodSetter, fieldname, beanClass));
            }
        }
        return retmap;
    }

    public static <B> Map<Class<?>, Set<BeanPropertyAccessor<B>>> propertyTypeToBeanPropertyAccessorSetMap(Class<B> beanClass) {
        Set<BeanPropertyAccessor<B>> beanPropertyAccessorSet;
        HashMap retmap = new HashMap();
        if (beanClass != null && (beanPropertyAccessorSet = BeanUtils.beanPropertyAccessorSet(beanClass)) != null) {
            for (BeanPropertyAccessor<B> beanPropertyAccessor : beanPropertyAccessorSet) {
                Class<?> propertyType;
                if (beanPropertyAccessor == null || (propertyType = beanPropertyAccessor.getDeclaringPropertyType()) == null) continue;
                if (!retmap.containsKey(propertyType)) {
                    retmap.put(propertyType, new HashSet());
                }
                ((Set)retmap.get(propertyType)).add(beanPropertyAccessor);
            }
        }
        return retmap;
    }

    public static <B> Map<String, BeanPropertyAccessor<B>> propertyNameToBeanPropertyAccessorMap(Class<B> beanClass) {
        Map<String, BeanPropertyAccessor<Object>> retmap = new HashMap<String, BeanPropertyAccessor<B>>();
        if (beanClass != null) {
            try {
                MapUtils.MapElementMergeOperation mapElementMergeOperation = new MapUtils.MapElementMergeOperation<String, BeanPropertyAccessor<B>>(){

                    @Override
                    public void merge(String key, BeanPropertyAccessor<B> value, Map<String, BeanPropertyAccessor<B>> mergedMap) {
                        if (mergedMap.containsKey(key)) {
                            BeanPropertyAccessor beanPropertyAccessor = mergedMap.get(key);
                            BeanPropertyAccessor beanPropertyAccessorMerged = BeanPropertyAccessor.merge(beanPropertyAccessor, value);
                            mergedMap.put(key, beanPropertyAccessorMerged);
                        } else {
                            mergedMap.put(key, value);
                        }
                    }
                };
                retmap = MapUtils.mergeAll(mapElementMergeOperation, BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass, beanClass.getDeclaredFields()), BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass, beanClass.getDeclaredMethods()), BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass, beanClass.getFields()), BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass, beanClass.getMethods()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retmap;
    }

    public static <B> BeanPropertyAccessor<B> beanPropertyAccessor(Class<B> beanClass, String propertyName) {
        BeanPropertyAccessor<B> retval = null;
        if (beanClass != null && propertyName != null) {
            try {
                Set<BeanMethodInformation> beanMethodInformationSet = BeanUtils.propertyNameToBeanMethodInformationMap(beanClass).get(propertyName);
                Method methodGetter = null;
                Method methodSetter = null;
                for (BeanMethodInformation beanMethodInformation : beanMethodInformationSet) {
                    if (beanMethodInformation.isGetter()) {
                        methodGetter = beanMethodInformation.getMethod();
                        continue;
                    }
                    if (!beanMethodInformation.isSetter()) continue;
                    methodSetter = beanMethodInformation.getMethod();
                }
                Field field = null;
                try {
                    field = beanClass.getDeclaredField(propertyName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (field == null) {
                    try {
                        field = beanClass.getField(propertyName);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                retval = new BeanPropertyAccessor<B>(field, methodGetter, methodSetter, propertyName, beanClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static <B> BeanPropertyAccessor<B> beanPropertyAccessor(Class<B> beanClass, Field field) {
        BeanPropertyAccessor<B> retval = null;
        if (beanClass != null && field != null) {
            String propertyName = field.getName();
            retval = BeanUtils.beanPropertyAccessor(beanClass, propertyName);
        }
        return retval;
    }

    public static <B> BeanPropertyAccessor<B> beanPropertyAccessor(Class<B> beanClass, Method method) {
        BeanPropertyAccessor<B> retval = null;
        if (beanClass != null && method != null) {
            BeanMethodInformation beanMethodInformation = BeanUtils.beanMethodInformation(method);
            String propertyName = beanMethodInformation.getPropertyName();
            retval = BeanUtils.beanPropertyAccessor(beanClass, propertyName);
        }
        return retval;
    }

    public static Set<BeanMethodInformation> beanMethodInformationSet(Class<?> clazz) {
        HashSet<BeanMethodInformation> retset = new HashSet<BeanMethodInformation>();
        if (clazz != null) {
            for (Method method : clazz.getMethods()) {
                retset.add(BeanUtils.beanMethodInformation(method));
            }
        }
        return retset;
    }

    public static Map<String, Set<BeanMethodInformation>> propertyNameToBeanMethodInformationMap(Class<?> clazz) {
        Map<String, Set<BeanMethodInformation>> retmap = null;
        retmap = clazz != null ? BeanUtils.propertyNameToBeanMethodInformationMap(clazz.getMethods()) : new HashMap<String, Set<BeanMethodInformation>>();
        return retmap;
    }

    public static Map<String, BeanMethodInformation> methodNameToBeanMethodInformationMap(Class<?> type) {
        Map<String, BeanMethodInformation> retmap = null;
        retmap = type != null ? BeanUtils.methodNameToBeanMethodInformationMap(type.getMethods()) : new HashMap<String, BeanMethodInformation>();
        return retmap;
    }

    public static Map<String, Set<BeanMethodInformation>> propertyNameToBeanMethodInformationMap(Method ... methods) {
        HashMap<String, Set<BeanMethodInformation>> retmap = new HashMap<String, Set<BeanMethodInformation>>();
        if (methods != null) {
            for (Method method : methods) {
                BeanMethodInformation beanMethodInformation = BeanUtils.beanMethodInformation(method);
                if (beanMethodInformation == null) continue;
                String referencedFieldName = beanMethodInformation.getPropertyName();
                if (!retmap.containsKey(referencedFieldName)) {
                    retmap.put(referencedFieldName, new HashSet());
                }
                ((Set)retmap.get(referencedFieldName)).add(beanMethodInformation);
            }
        }
        return retmap;
    }

    public static Map<String, BeanMethodInformation> methodNameToBeanMethodInformationMap(Method ... methods) {
        HashMap<String, BeanMethodInformation> retmap = new HashMap<String, BeanMethodInformation>();
        if (methods != null) {
            for (Method method : methods) {
                BeanMethodInformation beanMethodInformation = BeanUtils.beanMethodInformation(method);
                if (beanMethodInformation == null) continue;
                String methodName = method.getName();
                retmap.put(methodName, beanMethodInformation);
            }
        }
        return retmap;
    }

    public static BeanMethodInformation beanMethodInformation(Method method) {
        BeanMethodInformation retval = null;
        if (method != null) {
            try {
                Class<?>[] parameterTypes = method.getParameterTypes();
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                boolean isGetter = parameterTypes != null && parameterTypes.length == 0 && returnType != null && methodName != null && !StringUtils.equals((CharSequence)methodName, (CharSequence)"getClass") && (methodName.startsWith("is") || methodName.startsWith("get"));
                boolean isSetter = parameterTypes != null && parameterTypes.length == 1 && methodName != null && methodName.startsWith("set");
                boolean isGetterWithAdditionalArguments = parameterTypes != null && parameterTypes.length >= 1 && returnType != null && methodName != null && !StringUtils.equals((CharSequence)methodName, (CharSequence)"getClass") && (methodName.startsWith("is") || methodName.startsWith("get"));
                boolean isSetterWithAdditionalArguments = parameterTypes != null && parameterTypes.length >= 2 && methodName != null && methodName.startsWith("set");
                String referencedFieldName = null;
                if ((isGetter || isSetter || isGetterWithAdditionalArguments || isSetterWithAdditionalArguments) && (referencedFieldName = methodName.replaceFirst("^(is|get|set)", "")).length() > 0) {
                    referencedFieldName = referencedFieldName.replaceFirst("^.", referencedFieldName.substring(0, 1).toLowerCase());
                }
                retval = new BeanMethodInformation(isGetter, isSetter, isGetterWithAdditionalArguments, isSetterWithAdditionalArguments, referencedFieldName, method);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static <FROM, TO> TO convert(FROM sourceBean, BeanConverter<FROM, TO> beanConverter) {
        TO retval = null;
        if (sourceBean != null && beanConverter != null) {
            try {
                retval = beanConverter.convert(sourceBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static <S, D> void copyPropertyValues(S beanSource, D beanDestination) {
        Collection<String> propertyNameCollection = null;
        BeanUtils.copyPropertyValues(beanSource, beanDestination, propertyNameCollection);
    }

    public static <S, D> void copyPropertyValues(S beanSource, D beanDestination, String ... propertyNames) {
        BeanUtils.copyPropertyValues(beanSource, beanDestination, Arrays.asList(propertyNames));
    }

    public static <S, D> void copyPropertyValues(S beanSource, D beanDestination, Collection<String> propertyNameCollection) {
        if (beanSource != null && beanDestination != null) {
            Map<String, BeanPropertyAccessor<?>> fieldnameToBeanPropertyAccessorSourceMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(beanSource.getClass());
            Map<String, BeanPropertyAccessor<?>> fieldnameToBeanPropertyAccessorDestinationMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(beanDestination.getClass());
            List<Tuple2<BeanPropertyAccessor<?>, BeanPropertyAccessor<?>>> joinTupleList = ListUtils.valueOf(MapUtils.innerJoinMapByKey(fieldnameToBeanPropertyAccessorSourceMap, fieldnameToBeanPropertyAccessorDestinationMap).values());
            for (Tuple2<BeanPropertyAccessor<?>, BeanPropertyAccessor<?>> tupleDuad : joinTupleList) {
                BeanPropertyAccessor<?> beanPropertySourceAccessor = tupleDuad.getValueFirst();
                BeanPropertyAccessor<?> beanPropertyDestinationAccessor = tupleDuad.getValueSecond();
                if (propertyNameCollection != null && (!propertyNameCollection.contains(beanPropertySourceAccessor.getPropertyName()) || !beanPropertySourceAccessor.hasGetter() || !beanPropertyDestinationAccessor.hasSetter())) continue;
                Object propertyValue = beanPropertySourceAccessor.getPropertyValue(beanSource);
                beanPropertyDestinationAccessor.setPropertyValue(beanDestination, propertyValue);
            }
        }
    }

    public static Set<String> propertyNameSetForMethodAccess(Class<?> clazz) {
        return new LinkedHashSet<String>(Arrays.asList(BeanUtils.propertyNamesForMethodAccess(clazz)));
    }

    public static String[] propertyNamesForMethodAccess(Class<?> type) {
        String[] retvals = new String[]{};
        HashSet<String> propertyNameSet = new HashSet<String>();
        if (type != null) {
            Map<String, Set<BeanMethodInformation>> fieldnameToBeanMethodInformationMap = BeanUtils.propertyNameToBeanMethodInformationMap(type);
            propertyNameSet.addAll(fieldnameToBeanMethodInformationMap.keySet());
            propertyNameSet.remove(null);
            propertyNameSet.remove("class");
            retvals = propertyNameSet.toArray(new String[0]);
        }
        return retvals;
    }

    public static <B> B cloneBean(B bean) {
        Object retval = null;
        if (bean != null) {
            try {
                retval = ReflectionUtils.newInstanceOf(bean.getClass(), new Object[0]);
                if (retval != null) {
                    BeanUtils.copyPropertyValues(bean, retval);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (B)retval;
    }

    public static <B> B cloneBeanUsingInstanceOfMap(B bean) {
        boolean underlyingMapAware = false;
        return BeanUtils.cloneBeanUsingInstanceOfMap(bean, underlyingMapAware);
    }

    public static <B> B cloneBeanUsingInstanceOfMap(B bean, boolean underlyingMapAware) {
        B retval = null;
        if (bean != null) {
            try {
                Map<String, Object> propertyNameToBeanPropertyValueMap = BeanUtils.propertyNameToBeanPropertyValueMap(bean);
                if (propertyNameToBeanPropertyValueMap != null) {
                    Class<?> type = bean.getClass();
                    PropertynameMapToTypeAdapter.Configuration configuration = new PropertynameMapToTypeAdapter.Configuration();
                    configuration.setUnderlyingMapAware(underlyingMapAware);
                    retval = (B)PropertynameMapToTypeAdapter.newInstance(propertyNameToBeanPropertyValueMap, type, configuration);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static <B> B cloneBeanUsingNestedfMap(B bean) {
        Map<Class<?>, Class<?>> sourceTypeTodestinationTypeMap = null;
        return BeanUtils.cloneBeanUsingNestedfMap(bean, sourceTypeTodestinationTypeMap);
    }

    public static <B> B cloneBeanUsingNestedfMap(B bean, Map<Class<?>, Class<?>> sourceTypeTodestinationTypeMap) {
        B retval = null;
        if (bean != null) {
            Class<?> beanClass = bean.getClass();
            BeanToNestedMapConverter beanToNestedMapConverter = new BeanToNestedMapConverter((BeanToNestedMapConverter.BeanConversionFilter)new BeanToNestedMapConverter.BeanConversionFilterExcludingPrimitiveAndString(), beanClass, sourceTypeTodestinationTypeMap);
            retval = (B)beanToNestedMapConverter.clone(bean);
        }
        return retval;
    }

    public static interface BeanConverter<FROM, TO> {
        public TO convert(FROM var1);
    }
}

