/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.result.BeanMethodInformation;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public class ListToTypeAdapter<T, L extends List<?>> {
    protected List<Object> list = null;
    protected T classAdapter = null;
    protected Class<? extends T> clazz = null;
    protected List<String> propertynameList = new ArrayList<String>();
    protected boolean hasAccessToUnderlyingData = false;

    public static <T> T newInstance(List<?> list, Class<T> clazz, Comparator<String> comparatorPropertyname, boolean underlyingListAware) {
        List<String> propertynameList = null;
        return ListToTypeAdapter.newInstance(list, clazz, comparatorPropertyname, propertynameList, underlyingListAware);
    }

    public static <T> T newInstance(List<?> list, Class<T> clazz, List<String> propertynameList, boolean underlyingListAware) {
        Comparator<String> comparatorPropertyname = null;
        return ListToTypeAdapter.newInstance(list, clazz, comparatorPropertyname, propertynameList, underlyingListAware);
    }

    public static <T> T newInstance(List<?> list, Class<T> clazz, boolean underlyingListAware) {
        List<String> propertynameList = null;
        Comparator<String> comparatorPropertyname = null;
        return ListToTypeAdapter.newInstance(list, clazz, comparatorPropertyname, propertynameList, underlyingListAware);
    }

    public static <T> T newInstance(List<?> list, Class<T> clazz) {
        List<String> propertynameList = null;
        Comparator<String> comparatorPropertyname = null;
        boolean underlyingListAware = false;
        return ListToTypeAdapter.newInstance(list, clazz, comparatorPropertyname, propertynameList, underlyingListAware);
    }

    protected static <T> T newInstance(List<?> list, Class<T> clazz, Comparator<String> comparatorPropertyname, List<String> propertynameList, boolean underlyingListAware) {
        T retval = null;
        if (list != null && clazz != null) {
            ListToTypeAdapter listToInterfaceAdapter = new ListToTypeAdapter(list, clazz, comparatorPropertyname, propertynameList, underlyingListAware);
            retval = listToInterfaceAdapter.classAdapter;
        }
        return retval;
    }

    protected ListToTypeAdapter(L list, Class<T> clazz, Comparator<String> comparatorPropertyname, List<String> propertynameList, boolean underlyingListAware) {
        this.list = list;
        this.clazz = clazz;
        if (propertynameList != null) {
            this.propertynameList.addAll(propertynameList);
        } else {
            ArrayList<String> propertynameResolvedList = new ArrayList<String>();
            Set<BeanPropertyAccessor<T>> beanPropertyAccessorList = BeanUtils.beanPropertyAccessorSet(clazz);
            ElementConverter elementTransformer = new ElementConverter<BeanPropertyAccessor<T>, String>(){

                @Override
                public String convert(BeanPropertyAccessor<T> beanPropertyAccessor) {
                    return beanPropertyAccessor.getPropertyName();
                }
            };
            propertynameResolvedList.addAll(ListUtils.convert(beanPropertyAccessorList, elementTransformer));
            this.propertynameList = propertynameResolvedList;
        }
        if (comparatorPropertyname != null) {
            Collections.sort(this.propertynameList, comparatorPropertyname);
        }
        this.hasAccessToUnderlyingData = underlyingListAware;
        this.initializeClassAdapter(clazz, underlyingListAware);
        this.ensureListSize();
    }

    protected void ensureListSize() {
        int numberOfDeclaredFields = this.propertynameList.size();
        while (this.list.size() < numberOfDeclaredFields) {
            this.list.add(null);
        }
    }

    protected void initializeClassAdapter(Class<? extends T> clazz, boolean underlyingListAware) {
        try {
            Class[] classArray;
            if (underlyingListAware) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = UnderlyingListAware.class;
            } else {
                classArray = null;
            }
            Class[] interfaces = classArray;
            ClassAdapterMethodInterceptor methodInterceptor = new ClassAdapterMethodInterceptor();
            this.classAdapter = StubCreator.newStubInstance(clazz, interfaces, methodInterceptor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class ClassAdapterMethodInterceptor
    implements MethodInterceptor {
        protected ClassAdapterMethodInterceptor() {
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            Class<Void> retval = null;
            try {
                BeanMethodInformation beanMethodInformation = BeanUtils.beanMethodInformation(method);
                if (beanMethodInformation != null) {
                    boolean isListNotNull;
                    String referencedFieldName = beanMethodInformation.getPropertyName();
                    boolean accessToUnderlyingMap = ListToTypeAdapter.this.hasAccessToUnderlyingData && StringUtils.equals((CharSequence)"underlyingList", (CharSequence)referencedFieldName);
                    boolean accessUnderlyingPropertynameList = ListToTypeAdapter.this.hasAccessToUnderlyingData && StringUtils.equals((CharSequence)"underlyingPropertynameList", (CharSequence)referencedFieldName);
                    boolean isGetter = beanMethodInformation.isGetter() && args.length == 0;
                    boolean isSetter = beanMethodInformation.isSetter() && args.length == 1;
                    boolean bl = isListNotNull = ListToTypeAdapter.this.list != null;
                    if (!accessToUnderlyingMap && !accessUnderlyingPropertynameList) {
                        int methodIndexPosition = ListToTypeAdapter.this.propertynameList.indexOf(referencedFieldName);
                        if (isListNotNull && methodIndexPosition >= 0) {
                            ListToTypeAdapter.this.ensureListSize();
                            if (isGetter) {
                                retval = ListToTypeAdapter.this.list.get(methodIndexPosition);
                            } else if (isSetter) {
                                ListToTypeAdapter.this.list.set(methodIndexPosition, args[0]);
                                retval = Void.TYPE;
                            }
                        }
                    } else if (accessToUnderlyingMap) {
                        if (isGetter) {
                            retval = ListToTypeAdapter.this.list;
                        } else if (isSetter) {
                            ListToTypeAdapter.this.list = (List)args[0];
                            retval = Void.TYPE;
                        }
                    } else if (accessUnderlyingPropertynameList) {
                        if (isGetter) {
                            retval = ListToTypeAdapter.this.propertynameList;
                        } else if (isSetter) {
                            ListToTypeAdapter.this.propertynameList = (List)args[0];
                            retval = Void.TYPE;
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return retval;
        }
    }

    public static interface UnderlyingListAware<L extends List<?>> {
        public L getUnderlyingList();

        public void setUnderlyingList(L var1);

        public void setUnderlyingPropertynameList(List<String> var1);

        public List<String> getUnderlyingPropertynameList();
    }
}

