/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.adapter.PropertyAccessOption;
import org.omnaest.utils.beans.adapter.SourcePropertyAccessorToTypeAdapter;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessor;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecorator;
import org.omnaest.utils.proxy.handler.MethodInvocationHandlerDecorator;
import org.omnaest.utils.proxy.handler.MethodInvocationHandlerDecoratorToString;
import org.omnaest.utils.proxy.handler.MethodInvocationHandlerDecoratorUnderlyingMapAware;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.structure.map.UnderlyingMapAware;

public class PropertynameMapToTypeAdapter<T>
implements Serializable {
    private static final long serialVersionUID = 2245226860618141171L;
    private final Builder<? extends T> builder;

    public static <T> T newInstance(Map<String, Object> map, Class<? extends T> type) {
        Configuration configuration = null;
        return PropertynameMapToTypeAdapter.newInstance(map, type, configuration);
    }

    public static <T> T newInstance(Map<String, Object> map, Class<? extends T> type, Configuration configuration) {
        T retval = null;
        if (type != null && map != null) {
            retval = PropertynameMapToTypeAdapter.builder(type, configuration).newTypeAdapter(map);
        }
        return retval;
    }

    public static <T> Builder<T> builder(Class<? extends T> type, Configuration configuration) {
        Builder<? extends T> retval = null;
        if (type != null) {
            PropertynameMapToTypeAdapter<? extends T> mapToInterfaceAdapter = new PropertynameMapToTypeAdapter<T>(type, configuration);
            retval = super.getBuilder();
        }
        return retval;
    }

    private PropertynameMapToTypeAdapter(Class<? extends T> type, Configuration configuration) {
        Configuration configuration2 = configuration = configuration != null ? configuration : new Configuration();
        if (configuration.isUnderlyingMapAware()) {
            configuration.addInterface(UnderlyingMapAware.class);
        }
        this.builder = new BuilderImpl<T>(type, configuration);
    }

    private Builder<? extends T> getBuilder() {
        return this.builder;
    }

    protected static class SourePropertyAccessorForMap
    implements SourcePropertyAccessor {
        private static final long serialVersionUID = 5413119292636127784L;
        private Map<String, Object> map = null;

        public SourePropertyAccessorForMap(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public void setValue(String propertyName, Object value, Class<?> parameterType, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
            this.map.put(propertyName, value);
        }

        @Override
        public Object getValue(String propertyName, Class<?> returnType, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
            return this.map.get(propertyName);
        }

        public Map<String, Object> getMap() {
            return this.map;
        }

        public void setMap(Map<String, Object> map) {
            this.map = map;
        }
    }

    public static class Configuration
    extends SourcePropertyAccessorToTypeAdapter.Configuration {
        private static final long serialVersionUID = -4976626371731665509L;
        private boolean underlyingMapAware = false;
        private boolean simulatingToString = true;

        public Configuration() {
        }

        public Configuration(PropertyAccessOption propertyAccessOption, boolean isRegardingAdapterAnnotation, boolean isRegardingPropertyNameTemplateAnnotation, boolean isRegardingDefaultValueAnnotation, boolean underlyingMapAware, boolean simulatingToString) {
            super(propertyAccessOption, isRegardingAdapterAnnotation, isRegardingPropertyNameTemplateAnnotation, isRegardingDefaultValueAnnotation);
            this.underlyingMapAware = underlyingMapAware;
            this.simulatingToString = simulatingToString;
        }

        public Configuration(boolean underlyingMapAware, boolean simulatingToString) {
            this.underlyingMapAware = underlyingMapAware;
            this.simulatingToString = simulatingToString;
        }

        public Configuration(MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators, SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators) {
            super(methodInvocationHandlerDecorators, sourcePropertyAccessorDecorators);
        }

        public Configuration(Class<?>[] interfaces) {
            super(interfaces);
        }

        public boolean isUnderlyingMapAware() {
            return this.underlyingMapAware;
        }

        public void setUnderlyingMapAware(boolean underlyingMapAware) {
            this.underlyingMapAware = underlyingMapAware;
        }

        public boolean isSimulatingToString() {
            return this.simulatingToString;
        }

        public void setSimulatingToString(boolean simulatingToString) {
            this.simulatingToString = simulatingToString;
        }
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private static final long serialVersionUID = -7533427787901201120L;
        private final Configuration configuration;
        private final SourcePropertyAccessorToTypeAdapter.Builder<? extends T> builder;

        public BuilderImpl(Class<T> type, Configuration configuration) {
            this.configuration = configuration;
            this.builder = SourcePropertyAccessorToTypeAdapter.builder(type, configuration);
        }

        @Override
        public <M extends Map<String, Object>> T newTypeAdapter(M map) {
            T retval = null;
            Assert.isNotNull(map, "map must not be null");
            try {
                final SourePropertyAccessorForMap sourcePropertyAccessor = new SourePropertyAccessorForMap(map);
                ArrayList<MethodInvocationHandlerDecorator> methodInvocationHandlerDecoratorList = new ArrayList<MethodInvocationHandlerDecorator>();
                if (this.configuration.isUnderlyingMapAware()) {
                    methodInvocationHandlerDecoratorList.add(new MethodInvocationHandlerDecoratorUnderlyingMapAware(){

                        @Override
                        public void setUnderlyingMap(Map<?, ?> underlyingMap) {
                            sourcePropertyAccessor.setMap(underlyingMap);
                        }

                        @Override
                        public Map<?, ?> getUnderlyingMap() {
                            return sourcePropertyAccessor.getMap();
                        }
                    });
                }
                if (this.configuration.isSimulatingToString()) {
                    methodInvocationHandlerDecoratorList.add(new MethodInvocationHandlerDecoratorToString(){

                        @Override
                        public String handleToString() {
                            return MapUtils.toString(sourcePropertyAccessor.getMap());
                        }
                    });
                }
                SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators = null;
                MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators = methodInvocationHandlerDecoratorList.toArray(new MethodInvocationHandlerDecorator[methodInvocationHandlerDecoratorList.size()]);
                retval = this.builder.newTypeAdapter(sourcePropertyAccessor, sourcePropertyAccessorDecorators, methodInvocationHandlerDecorators);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return retval;
        }
    }

    public static interface Builder<T>
    extends Serializable {
        public <M extends Map<String, Object>> T newTypeAdapter(M var1);
    }
}

