/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.adapter.PropertyAccessOption;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessor;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecorator;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecoratorAdapter;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecoratorDefaultValue;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecoratorPropertyAccessOption;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecoratorPropertyNameTemplate;
import org.omnaest.utils.beans.autowired.AutowiredContainer;
import org.omnaest.utils.beans.autowired.ClassMapToAutowiredContainerAdapter;
import org.omnaest.utils.beans.result.BeanMethodInformation;
import org.omnaest.utils.proxy.StubCreator;
import org.omnaest.utils.proxy.handler.MethodCallCapture;
import org.omnaest.utils.proxy.handler.MethodInvocationHandler;
import org.omnaest.utils.proxy.handler.MethodInvocationHandlerDecorator;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.cached.CachedElement;

public class SourcePropertyAccessorToTypeAdapter<T>
implements Serializable {
    private static final long serialVersionUID = 5957600557802418027L;
    private final Builder<T> builder;

    public static <T> T newInstance(Class<T> type, SourcePropertyAccessor sourcePropertyAccessor) {
        Configuration configuration = null;
        return SourcePropertyAccessorToTypeAdapter.newInstance(type, sourcePropertyAccessor, configuration);
    }

    public static <T> T newInstance(Class<T> type, SourcePropertyAccessor sourcePropertyAccessor, Configuration configuration) {
        T retval = null;
        if (type != null && sourcePropertyAccessor != null) {
            retval = SourcePropertyAccessorToTypeAdapter.builder(type, configuration).newTypeAdapter(sourcePropertyAccessor);
        }
        return retval;
    }

    public static <T> Builder<T> builder(Class<T> type, Configuration configuration) {
        Builder<T> retval = null;
        if (type != null) {
            SourcePropertyAccessorToTypeAdapter<T> propertyAccessorToTypeAdapter = new SourcePropertyAccessorToTypeAdapter<T>(type, configuration);
            retval = super.getBuilder();
        }
        return retval;
    }

    protected SourcePropertyAccessorToTypeAdapter(Class<T> type, Configuration configuration) {
        Assert.isNotNull(type);
        configuration = configuration != null ? configuration : new Configuration();
        ImmutableList declaredAnnotationListOfType = null;
        ImmutableMap declaredMethodToAnnotationSetMap = null;
        ImmutableMap propertyNameToBeanPropertyAnnotationSetMap = null;
        ImmutableMap methodNameToBeanMethodInformationMap = null;
        boolean isRegardingAnnotations = Configuration.RegardedAnnotationScope.DECLARED.equals((Object)configuration.getRegardedAnnotationScope()) || Configuration.RegardedAnnotationScope.INHERITED.equals((Object)configuration.getRegardedAnnotationScope());
        boolean isRegardingInheritedAnnotations = Configuration.RegardedAnnotationScope.INHERITED.equals((Object)configuration.getRegardedAnnotationScope());
        if (isRegardingAnnotations) {
            declaredAnnotationListOfType = ImmutableList.builder().addAll(isRegardingInheritedAnnotations ? ReflectionUtils.annotationList(type) : ReflectionUtils.declaredAnnotationList(type)).build();
            declaredMethodToAnnotationSetMap = ImmutableMap.builder().putAll(isRegardingInheritedAnnotations ? ReflectionUtils.methodToAnnotationSetMap(type) : ReflectionUtils.declaredMethodToAnnotationSetMap(type)).build();
            propertyNameToBeanPropertyAnnotationSetMap = ImmutableMap.builder().putAll(BeanUtils.propertyNameToBeanPropertyAnnotationSetMap(type)).build();
            methodNameToBeanMethodInformationMap = ImmutableMap.builder().putAll(BeanUtils.methodNameToBeanMethodInformationMap(type)).build();
        }
        this.builder = new BuilderImpl<T>((List<Annotation>)declaredAnnotationListOfType, (Map<Method, Set<Annotation>>)declaredMethodToAnnotationSetMap, (Map<String, Set<Annotation>>)propertyNameToBeanPropertyAnnotationSetMap, (Map<String, BeanMethodInformation>)methodNameToBeanMethodInformationMap, type, configuration);
    }

    private Builder<T> getBuilder() {
        return this.builder;
    }

    public static class Configuration
    implements Serializable {
        private static final long serialVersionUID = 1537703849251094863L;
        private Class<?>[] interfaces = new Class[0];
        private MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators = null;
        private SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators = null;
        private PropertyAccessOption propertyAccessOption = PropertyAccessOption.PROPERTY;
        private boolean isRegardingAdapterAnnotation = false;
        private boolean isRegardingPropertyNameTemplateAnnotation = false;
        private boolean isRegardingDefaultValueAnnotation = false;
        private RegardedAnnotationScope regardedAnnotationScope = RegardedAnnotationScope.INHERITED;

        public Configuration(MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators, SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators) {
            this.methodInvocationHandlerDecorators = methodInvocationHandlerDecorators;
            this.sourcePropertyAccessorDecorators = sourcePropertyAccessorDecorators;
        }

        public Configuration(PropertyAccessOption propertyAccessOption, boolean isRegardingAdapterAnnotation, boolean isRegardingPropertyNameTemplateAnnotation, boolean isRegardingDefaultValueAnnotation) {
            this.propertyAccessOption = propertyAccessOption;
            this.isRegardingAdapterAnnotation = isRegardingAdapterAnnotation;
            this.isRegardingPropertyNameTemplateAnnotation = isRegardingPropertyNameTemplateAnnotation;
            this.isRegardingDefaultValueAnnotation = isRegardingDefaultValueAnnotation;
        }

        public Configuration() {
        }

        public Configuration(Class<?> ... interfaces) {
            this.interfaces = interfaces;
        }

        public void addInterface(Class<?> interfaceType) {
            this.interfaces = this.interfaces == null ? (this.interfaces = new Class[0]) : this.interfaces;
            this.interfaces = (Class[])org.apache.commons.lang3.ArrayUtils.add((Object[])this.interfaces, interfaceType);
        }

        public void addSourcePropertyAccessorDecorator(SourcePropertyAccessorDecorator sourcePropertyAccessorDecorator) {
            this.sourcePropertyAccessorDecorators = this.sourcePropertyAccessorDecorators == null ? new SourcePropertyAccessorDecorator[]{} : this.sourcePropertyAccessorDecorators;
            this.sourcePropertyAccessorDecorators = (SourcePropertyAccessorDecorator[])org.apache.commons.lang3.ArrayUtils.add((Object[])this.sourcePropertyAccessorDecorators, (Object)sourcePropertyAccessorDecorator);
        }

        public void addMethodInvocationHandlerDecorator(MethodInvocationHandlerDecorator methodInvocationHandlerDecorator) {
            this.methodInvocationHandlerDecorators = this.methodInvocationHandlerDecorators == null ? new MethodInvocationHandlerDecorator[]{} : this.methodInvocationHandlerDecorators;
            this.methodInvocationHandlerDecorators = (MethodInvocationHandlerDecorator[])org.apache.commons.lang3.ArrayUtils.add((Object[])this.methodInvocationHandlerDecorators, (Object)methodInvocationHandlerDecorator);
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }

        public void setInterfaces(Class<?>[] interfaces) {
            this.interfaces = interfaces;
        }

        public MethodInvocationHandlerDecorator[] getMethodInvocationHandlerDecorators() {
            return this.methodInvocationHandlerDecorators;
        }

        public void setMethodInvocationHandlerDecorators(MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators) {
            this.methodInvocationHandlerDecorators = methodInvocationHandlerDecorators;
        }

        public PropertyAccessOption getPropertyAccessOption() {
            return this.propertyAccessOption;
        }

        public void setPropertyAccessOption(PropertyAccessOption propertyAccessOption) {
            this.propertyAccessOption = propertyAccessOption;
        }

        public SourcePropertyAccessorDecorator[] getSourcePropertyAccessorDecorators() {
            return this.sourcePropertyAccessorDecorators;
        }

        public void setSourcePropertyAccessorDecorators(SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators) {
            this.sourcePropertyAccessorDecorators = sourcePropertyAccessorDecorators;
        }

        public boolean isRegardingAdapterAnnotation() {
            return this.isRegardingAdapterAnnotation;
        }

        public void setRegardingAdapterAnnotation(boolean isRegardingAdapterAnnotation) {
            this.isRegardingAdapterAnnotation = isRegardingAdapterAnnotation;
        }

        public boolean isRegardingPropertyNameTemplateAnnotation() {
            return this.isRegardingPropertyNameTemplateAnnotation;
        }

        public void setRegardingPropertyNameTemplate(boolean isRegardingPropertyNameTemplate) {
            this.isRegardingPropertyNameTemplateAnnotation = isRegardingPropertyNameTemplate;
        }

        public RegardedAnnotationScope getRegardedAnnotationScope() {
            return this.regardedAnnotationScope;
        }

        public void setRegardedAnnotationScope(RegardedAnnotationScope regardedAnnotationScope) {
            this.regardedAnnotationScope = regardedAnnotationScope;
        }

        public boolean isRegardingDefaultValueAnnotation() {
            return this.isRegardingDefaultValueAnnotation;
        }

        public void setRegardingDefaultValueAnnotation(boolean isRegardingDefaultValueAnnotation) {
            this.isRegardingDefaultValueAnnotation = isRegardingDefaultValueAnnotation;
        }

        public static enum RegardedAnnotationScope {
            NONE,
            DECLARED,
            INHERITED;

        }
    }

    private static class ClassAdapterMethodInvocationHandler
    implements MethodInvocationHandler,
    Serializable {
        private static final long serialVersionUID = 7923602793508877717L;
        private SourcePropertyAccessor sourcePropertyAccessor = null;
        private final List<Annotation> declaredAnnotationListOfType;
        private final Map<Method, Set<Annotation>> declaredMethodToAnnotationSetMap;
        private final Map<String, Set<Annotation>> propertyNameToBeanPropertyAnnotationSetMap;
        private final Map<String, BeanMethodInformation> methodNameToBeanMethodInformationMap;

        public ClassAdapterMethodInvocationHandler(SourcePropertyAccessor sourcePropertyAccessor, List<Annotation> declaredAnnotationListOfType, Map<Method, Set<Annotation>> declaredMethodToAnnotationSetMap, Map<String, Set<Annotation>> propertyNameToBeanPropertyAnnotationSetMap, Map<String, BeanMethodInformation> methodNameToBeanMethodInformationMap) {
            this.sourcePropertyAccessor = sourcePropertyAccessor;
            this.declaredAnnotationListOfType = declaredAnnotationListOfType;
            this.declaredMethodToAnnotationSetMap = declaredMethodToAnnotationSetMap;
            this.propertyNameToBeanPropertyAnnotationSetMap = propertyNameToBeanPropertyAnnotationSetMap;
            this.methodNameToBeanMethodInformationMap = methodNameToBeanMethodInformationMap;
        }

        @Override
        public Object handle(MethodCallCapture methodCallCapture) throws Throwable {
            Method method = methodCallCapture.getMethod();
            String methodName = methodCallCapture.getMethodName();
            Object[] args = methodCallCapture.getArguments();
            Class<Void> retval = null;
            try {
                BeanMethodInformation beanMethodInformation = this.methodNameToBeanMethodInformationMap.get(methodName);
                if (beanMethodInformation != null) {
                    boolean isPropertyAccessorNotNull;
                    String referencedFieldName = beanMethodInformation.getPropertyName();
                    boolean isGetter = beanMethodInformation.isGetter() && args.length == 0;
                    boolean isGetterWithAddtionalArguments = beanMethodInformation.isGetterWithAdditionalArguments() && args.length >= 1;
                    boolean isSetter = beanMethodInformation.isSetter() && args.length == 1;
                    boolean isSetterWithAdditionalArguments = beanMethodInformation.isSetterWithAdditionalArguments() && args.length >= 2;
                    boolean bl = isPropertyAccessorNotNull = this.sourcePropertyAccessor != null;
                    if (isPropertyAccessorNotNull) {
                        AutowiredContainer<Annotation> propertyAnnotationAutowiredContainer = ClassMapToAutowiredContainerAdapter.newInstance(new LinkedHashMap());
                        AutowiredContainer<Annotation> classAnnotationAutowiredContainer = ClassMapToAutowiredContainerAdapter.newInstance(new LinkedHashMap());
                        classAnnotationAutowiredContainer.putAll(this.declaredAnnotationListOfType);
                        propertyAnnotationAutowiredContainer.putAll((Iterable)this.propertyNameToBeanPropertyAnnotationSetMap.get(referencedFieldName));
                        propertyAnnotationAutowiredContainer.putAll((Iterable)this.declaredMethodToAnnotationSetMap.get(method));
                        if (isGetter || isGetterWithAddtionalArguments) {
                            Class<?> returnType = beanMethodInformation.getMethod().getReturnType();
                            Type genericReturnType = beanMethodInformation.getMethod().getGenericReturnType();
                            ParameterizedType genericType = (ParameterizedType)(genericReturnType instanceof ParameterizedType ? genericReturnType : null);
                            Object[] additionalArguments = isGetterWithAddtionalArguments ? Arrays.copyOf(args, args.length) : new Object[]{};
                            SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation = new SourcePropertyAccessor.PropertyMetaInformation(additionalArguments, genericType, propertyAnnotationAutowiredContainer, classAnnotationAutowiredContainer);
                            retval = this.sourcePropertyAccessor.getValue(referencedFieldName, returnType, propertyMetaInformation);
                        } else if (isSetter || isSetterWithAdditionalArguments) {
                            String propertyName = referencedFieldName;
                            Object value = args[0];
                            Class<?>[] targetParameterTypes = beanMethodInformation.getMethod().getParameterTypes();
                            Class<?> parameterType = targetParameterTypes != null && targetParameterTypes.length >= 1 ? targetParameterTypes[0] : null;
                            Type[] genericParameterTypes = beanMethodInformation.getMethod().getGenericParameterTypes();
                            ParameterizedType genericParameterType = (ParameterizedType)(genericParameterTypes != null && genericParameterTypes.length >= 1 && genericParameterTypes[0] instanceof ParameterizedType ? genericParameterTypes[0] : null);
                            Object[] additionalArguments = isSetterWithAdditionalArguments ? Arrays.copyOfRange(args, 1, args.length) : new Object[]{};
                            SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation = new SourcePropertyAccessor.PropertyMetaInformation(additionalArguments, genericParameterType, propertyAnnotationAutowiredContainer, classAnnotationAutowiredContainer);
                            this.sourcePropertyAccessor.setValue(propertyName, value, parameterType, propertyMetaInformation);
                            retval = Void.TYPE;
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return retval;
        }
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private static final long serialVersionUID = 9056642721076392704L;
        private final List<Annotation> declaredAnnotationListOfType;
        private final Map<Method, Set<Annotation>> declaredMethodToAnnotationSetMap;
        private final Map<String, Set<Annotation>> propertyNameToBeanPropertyAnnotationSetMap;
        private final Map<String, BeanMethodInformation> methodNameToBeanMethodInformationMap;
        private final Class<T> type;
        private final Configuration configuration;
        private final CachedElement<StubCreator<T>> cachedStubFactory = new CachedElement<1>(new CachedElement.ValueResolver<StubCreator<T>>(){

            @Override
            public StubCreator<T> resolveValue() {
                return new StubCreator(BuilderImpl.this.type, BuilderImpl.this.configuration.getInterfaces());
            }
        });

        public BuilderImpl(List<Annotation> declaredAnnotationListOfType, Map<Method, Set<Annotation>> declaredMethodToAnnotationSetMap, Map<String, Set<Annotation>> propertyNameToBeanPropertyAnnotationSetMap, Map<String, BeanMethodInformation> methodNameToBeanMethodInformationMap, Class<T> type, Configuration configuration) {
            this.declaredAnnotationListOfType = declaredAnnotationListOfType;
            this.declaredMethodToAnnotationSetMap = declaredMethodToAnnotationSetMap;
            this.propertyNameToBeanPropertyAnnotationSetMap = propertyNameToBeanPropertyAnnotationSetMap;
            this.methodNameToBeanMethodInformationMap = methodNameToBeanMethodInformationMap;
            this.type = type;
            this.configuration = configuration;
        }

        @Override
        public T newTypeAdapter(SourcePropertyAccessor sourcePropertyAccessor) {
            SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators = null;
            MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators = null;
            return this.newTypeAdapter(sourcePropertyAccessor, sourcePropertyAccessorDecorators, methodInvocationHandlerDecorators);
        }

        @Override
        public T newTypeAdapter(SourcePropertyAccessor sourcePropertyAccessor, SourcePropertyAccessorDecorator[] sourcePropertyAccessorDecorators, MethodInvocationHandlerDecorator[] methodInvocationHandlerDecorators) {
            T retval = null;
            Assert.isNotNull((Object)sourcePropertyAccessor, "sourcePropertyAccessor must not be null");
            try {
                if (this.configuration.isRegardingAdapterAnnotation()) {
                    sourcePropertyAccessor = new SourcePropertyAccessorDecoratorAdapter(sourcePropertyAccessor);
                }
                if (this.configuration.isRegardingPropertyNameTemplateAnnotation()) {
                    sourcePropertyAccessor = new SourcePropertyAccessorDecoratorPropertyNameTemplate(sourcePropertyAccessor);
                }
                if (this.configuration.getPropertyAccessOption() != null && !PropertyAccessOption.PROPERTY.equals((Object)this.configuration.getPropertyAccessOption())) {
                    sourcePropertyAccessor = new SourcePropertyAccessorDecoratorPropertyAccessOption(sourcePropertyAccessor, this.configuration.getPropertyAccessOption());
                }
                if (this.configuration.isRegardingDefaultValueAnnotation()) {
                    sourcePropertyAccessor = new SourcePropertyAccessorDecoratorDefaultValue(sourcePropertyAccessor);
                }
                if (this.configuration.getSourcePropertyAccessorDecorators() != null) {
                    for (SourcePropertyAccessorDecorator sourcePropertyAccessorDecorator : sourcePropertyAccessorDecorators = ArrayUtils.merge(this.configuration.getSourcePropertyAccessorDecorators(), sourcePropertyAccessorDecorators)) {
                        if (sourcePropertyAccessorDecorator == null) continue;
                        sourcePropertyAccessor = sourcePropertyAccessorDecorator.setPropertyAccessorDecorator(sourcePropertyAccessor);
                    }
                }
                MethodInvocationHandler methodInvocationHandler = new ClassAdapterMethodInvocationHandler(sourcePropertyAccessor, this.declaredAnnotationListOfType, this.declaredMethodToAnnotationSetMap, this.propertyNameToBeanPropertyAnnotationSetMap, this.methodNameToBeanMethodInformationMap);
                methodInvocationHandlerDecorators = ArrayUtils.merge(this.configuration.getMethodInvocationHandlerDecorators(), methodInvocationHandlerDecorators);
                if (methodInvocationHandlerDecorators != null) {
                    for (MethodInvocationHandlerDecorator methodInvocationHandlerDecorator : methodInvocationHandlerDecorators) {
                        if (methodInvocationHandlerDecorator == null) continue;
                        methodInvocationHandler = methodInvocationHandlerDecorator.setMethodInvocationHandler(methodInvocationHandler);
                    }
                }
                retval = this.cachedStubFactory.getValue().build(methodInvocationHandler);
            }
            catch (Exception e) {
                // empty catch block
            }
            return retval;
        }
    }

    public static interface Builder<T>
    extends Serializable {
        public T newTypeAdapter(SourcePropertyAccessor var1);

        public T newTypeAdapter(SourcePropertyAccessor var1, SourcePropertyAccessorDecorator[] var2, MethodInvocationHandlerDecorator[] var3);
    }
}

