/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.adapter.source;

import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessor;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecorator;
import org.omnaest.utils.structure.element.converter.Converter;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterHelper;

public class SourcePropertyAccessorDecoratorAdapter
extends SourcePropertyAccessorDecorator {
    private static final long serialVersionUID = -6289909653064728549L;

    public SourcePropertyAccessorDecoratorAdapter() {
    }

    public SourcePropertyAccessorDecoratorAdapter(SourcePropertyAccessor sourcePropertyAccessor) {
        this.sourcePropertyAccessor = sourcePropertyAccessor;
    }

    @Override
    public void setValue(String propertyName, Object value, Class<?> parameterType, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
        Converter converter = propertyMetaInformation.getPropertyAnnotationAutowiredContainer().getValue(Converter.class);
        if (converter != null) {
            value = SourcePropertyAccessorDecoratorAdapter.convertByAdapter(value, converter);
        }
        Assert.isNotNull(this.sourcePropertyAccessor);
        this.sourcePropertyAccessor.setValue(propertyName, value, parameterType, propertyMetaInformation);
    }

    @Override
    public Object getValue(String propertyName, Class<?> returnType, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
        Object retval = null;
        Assert.isNotNull(this.sourcePropertyAccessor);
        retval = this.sourcePropertyAccessor.getValue(propertyName, returnType, propertyMetaInformation);
        Converter converter = propertyMetaInformation.getPropertyAnnotationAutowiredContainer().getValue(Converter.class);
        if (converter != null) {
            retval = SourcePropertyAccessorDecoratorAdapter.convertByAdapter(retval, converter);
        }
        return retval;
    }

    private static Object convertByAdapter(Object value, Converter converter) {
        Object retval = value;
        if (converter != null) {
            Class<? extends ElementConverter>[] elementConverterTypes = converter.types();
            retval = ElementConverterHelper.convert(retval, elementConverterTypes);
        }
        return retval;
    }
}

