/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.adapter.source;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.beans.adapter.source.PropertyNameTemplate;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessor;
import org.omnaest.utils.beans.adapter.source.SourcePropertyAccessorDecorator;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public class SourcePropertyAccessorDecoratorPropertyNameTemplate
extends SourcePropertyAccessorDecorator {
    private static final long serialVersionUID = 6165218599151510835L;

    public SourcePropertyAccessorDecoratorPropertyNameTemplate(SourcePropertyAccessor sourcePropertyAccessor) {
        this.sourcePropertyAccessor = sourcePropertyAccessor;
    }

    @Override
    public void setValue(String propertyName, Object value, Class<?> parameterType, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
        String propertyNameProcessed = SourcePropertyAccessorDecoratorPropertyNameTemplate.processPropertyNameWithTemplate(propertyName, propertyMetaInformation);
        Assert.isNotNull(this.sourcePropertyAccessor);
        this.sourcePropertyAccessor.setValue(propertyNameProcessed, value, parameterType, propertyMetaInformation);
    }

    @Override
    public Object getValue(String propertyName, Class<?> returnType, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
        String propertyNameProcessed = SourcePropertyAccessorDecoratorPropertyNameTemplate.processPropertyNameWithTemplate(propertyName, propertyMetaInformation);
        Assert.isNotNull(this.sourcePropertyAccessor);
        return this.sourcePropertyAccessor.getValue(propertyNameProcessed, returnType, propertyMetaInformation);
    }

    private static String processPropertyNameWithTemplate(String propertyName, SourcePropertyAccessor.PropertyMetaInformation propertyMetaInformation) {
        String retval = propertyName;
        if (propertyMetaInformation != null) {
            PropertyNameTemplate propertyNameTemplate = propertyMetaInformation.getPropertyAnnotationAutowiredContainer().getValue(PropertyNameTemplate.class);
            if (propertyNameTemplate == null) {
                propertyNameTemplate = propertyMetaInformation.getClassAnnotationAutowiredContainer().getValue(PropertyNameTemplate.class);
            }
            if (propertyNameTemplate != null) {
                Class<? extends ElementConverter<?, String>>[] additionalArgumentConverterTypes = propertyNameTemplate.additionalArgumentConverterTypes();
                String template = propertyNameTemplate.value();
                if (template != null) {
                    String TAG_PROPERTYNAME = "\\{(?iu)propertyname(?-iu)\\}";
                    String TAG_PARAMETER = "\\{(\\d)\\}";
                    Assert.isTrue(Pattern.matches("(\\{(?iu)propertyname(?-iu)\\}|\\{(\\d)\\}|[^\\{\\}])+", template), "PropertyNameTemplate of property " + propertyName + " has an invalid format.");
                    String templateWithValues = template.replaceAll("\\{(?iu)propertyname(?-iu)\\}", propertyName);
                    StringBuffer stringBuffer = new StringBuffer();
                    Matcher matcher = Pattern.compile("\\{(\\d)\\}").matcher(templateWithValues);
                    while (matcher.find()) {
                        String group = matcher.group(1);
                        Assert.isTrue(StringUtils.isNumeric((CharSequence)group), "Parameter index position within PropertyNameTemplate of property " + propertyName + " has to be a valid number. Found: " + group);
                        int additionalArgumentIndexPosition = Integer.valueOf(group);
                        Object[] additionalArguments = propertyMetaInformation.getAdditionalArguments();
                        int parameterIndexPositionMax = additionalArguments.length - 1;
                        Assert.isTrue(additionalArgumentIndexPosition >= 0 && additionalArgumentIndexPosition <= parameterIndexPositionMax, "Parameter index position within PropertyNameTemplate of property " + propertyName + " has to be between 0 and " + parameterIndexPositionMax);
                        Object additionalArgument = SourcePropertyAccessorDecoratorPropertyNameTemplate.determineAdditionalArgument(additionalArgumentConverterTypes, additionalArgumentIndexPosition, additionalArguments);
                        String additionalArgumentString = String.valueOf(additionalArgument);
                        matcher.appendReplacement(stringBuffer, additionalArgumentString);
                    }
                    matcher.appendTail(stringBuffer);
                    retval = stringBuffer.toString();
                }
            }
        }
        return retval;
    }

    private static Object determineAdditionalArgument(Class<? extends ElementConverter<?, String>>[] additionalArgumentConverterTypes, int additionalArgumentIndexPosition, Object[] additionalArguments) {
        Class<? extends ElementConverter<?, String>> elementConverterType;
        ElementConverter<?, String> elementConverter;
        Object additionalArgument = additionalArguments[additionalArgumentIndexPosition];
        if (additionalArgumentIndexPosition >= 0 && additionalArgumentIndexPosition < additionalArgumentConverterTypes.length && (elementConverter = ReflectionUtils.newInstanceOf(elementConverterType = additionalArgumentConverterTypes[additionalArgumentIndexPosition], new Object[0])) != null) {
            additionalArgument = elementConverter.convert(additionalArgument);
        }
        return additionalArgument;
    }
}

