/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.autowired;

import java.util.Iterator;
import java.util.Set;
import org.omnaest.utils.beans.autowired.AutowiredContainer;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.iterator.IterableUtils;

public abstract class AutowiredContainerAbstract<E>
implements AutowiredContainer<E> {
    private static final long serialVersionUID = -7792783078590040662L;

    @Override
    public <O extends E> O getValue(Class<? extends O> clazz) {
        O retval = null;
        Set<O> valueSet = this.getValueSet(clazz);
        if (valueSet != null && valueSet.size() == 1) {
            retval = valueSet.iterator().next();
        }
        return retval;
    }

    @Override
    public AutowiredContainer<E> putAll(Iterable<E> iterable) {
        if (iterable != null) {
            for (E element : iterable) {
                this.put(element);
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AutowiredContainer [content=");
        builder.append(ListUtils.valueOf(this));
        builder.append("]");
        return builder.toString();
    }

    @Override
    public <O extends E> boolean containsAssignable(Class<O> type) {
        Set<O> valueSet = this.getValueSet(type);
        return valueSet != null && !valueSet.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        Iterator iterator = this.iterator();
        return iterator == null || !iterator.hasNext();
    }

    @Override
    public <O extends E> AutowiredContainer<E> remove(O object) {
        if (object != null) {
            Class<?> type = object.getClass();
            this.removeAllHavingExactTypeOf(type);
        }
        return this;
    }

    public int hashCode() {
        return IterableUtils.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof Iterable && IterableUtils.equals(this, (Iterable)obj);
    }

    @Override
    public int size() {
        return IterableUtils.size(this);
    }
}

