/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.autowired;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.omnaest.utils.beans.autowired.AutowiredContainer;
import org.omnaest.utils.beans.autowired.AutowiredContainerAbstract;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClassMapToAutowiredContainerAdapter<E>
extends AutowiredContainerAbstract<E> {
    private static final long serialVersionUID = -6432970316176438546L;
    @XmlElementWrapper(name="entries")
    private Map<Class<? extends E>, E> classToObjectMap = null;

    public static <E> AutowiredContainer<E> newInstanceUsingLinkedHashMap() {
        return ClassMapToAutowiredContainerAdapter.newInstance(null);
    }

    public static <E> AutowiredContainer<E> newInstance(Map<Class<? extends E>, E> classToObjectMap) {
        ClassMapToAutowiredContainerAdapter<? extends E> retval = null;
        retval = new ClassMapToAutowiredContainerAdapter<E>(classToObjectMap);
        return retval;
    }

    protected ClassMapToAutowiredContainerAdapter(Map<Class<? extends E>, E> classToObjectMap) {
        this.classToObjectMap = classToObjectMap != null ? classToObjectMap : new LinkedHashMap();
    }

    protected ClassMapToAutowiredContainerAdapter() {
        this(null);
    }

    @Override
    public <O extends E> Set<O> getValueSet(Class<? extends O> type) {
        LinkedHashSet<E> retset = new LinkedHashSet<E>();
        if (type != null) {
            Set<Class<O>> assignableTypeSet = this.determineAssignableTypeSet(type);
            for (Class<? extends O> clazz : assignableTypeSet) {
                retset.add(this.classToObjectMap.get(clazz));
            }
        }
        return retset;
    }

    protected Set<Class<? extends E>> determineAssignableTypeSet(Class<? extends E> type) {
        HashSet<Class<Class<? extends E>>> retset = new HashSet<Class<Class<? extends E>>>();
        if (type != null) {
            for (Class<? extends E> clazz : this.classToObjectMap.keySet()) {
                if (clazz == null || !type.isAssignableFrom(clazz)) continue;
                retset.add(clazz);
            }
        }
        return retset;
    }

    @Override
    public AutowiredContainer<E> put(E object) {
        return this.put(object, object != null ? object.getClass() : null);
    }

    @Override
    public Iterator<E> iterator() {
        return this.classToObjectMap.values().iterator();
    }

    @Override
    public <O extends E> AutowiredContainer<E> put(O object, Class<? extends O> ... types) {
        if (object != null && types.length > 0) {
            for (Class<O> clazz : types) {
                if (clazz == null) continue;
                this.classToObjectMap.put(clazz, object);
            }
        }
        return this;
    }

    @Override
    public AutowiredContainer<E> removeAllHavingExactTypeOf(Class<? extends E> type) {
        if (type != null) {
            this.classToObjectMap.remove(type);
        }
        return this;
    }

    @Override
    public AutowiredContainer<E> removeAllAssignableTo(Class<? extends E> type) {
        Set<Class<E>> assignableTypeSet = this.determineAssignableTypeSet(type);
        if (!assignableTypeSet.isEmpty()) {
            for (Class<? extends E> clazz : assignableTypeSet) {
                this.classToObjectMap.remove(clazz);
            }
        }
        return this;
    }
}

