/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.autowired;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.autowired.AutowiredContainer;
import org.omnaest.utils.beans.autowired.AutowiredContainerAbstract;
import org.omnaest.utils.beans.autowired.AutowiredPropertyContainer;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;

public class TypeToAutowiredPropertyContainerAdapter<B>
extends AutowiredContainerAbstract<Object>
implements AutowiredPropertyContainer {
    private static final long serialVersionUID = -4028601259144341930L;
    protected B bean = null;
    protected Map<String, BeanPropertyAccessor<B>> propertynameToBeanPropertyAccessorMap = null;
    protected Map<Class<?>, Set<BeanPropertyAccessor<B>>> propertyTypeToBeanPropertyAccessorSetMap = null;

    public static <B> AutowiredPropertyContainer newInstance(B bean) {
        TypeToAutowiredPropertyContainerAdapter<B> retval = null;
        if (bean != null) {
            retval = new TypeToAutowiredPropertyContainerAdapter<B>(bean);
        }
        return retval;
    }

    protected TypeToAutowiredPropertyContainerAdapter(B bean) {
        Class<?> beanClass = bean.getClass();
        this.bean = bean;
        this.propertynameToBeanPropertyAccessorMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(beanClass);
        this.propertyTypeToBeanPropertyAccessorSetMap = BeanUtils.propertyTypeToBeanPropertyAccessorSetMap(beanClass);
    }

    @Override
    public <O> AutowiredContainer<Object> put(O object, Class<? extends O> ... types) {
        if (object != null && types.length > 0) {
            for (Class<O> clazz : types) {
                if (clazz == null) continue;
                for (Class<? extends O> clazz2 : this.propertyTypeToBeanPropertyAccessorSetMap.keySet()) {
                    if (!clazz2.isAssignableFrom(clazz)) continue;
                    Set<BeanPropertyAccessor<B>> beanPropertyAccessorSet = this.propertyTypeToBeanPropertyAccessorSetMap.get(clazz2);
                    for (BeanPropertyAccessor<B> beanPropertyAccessor : beanPropertyAccessorSet) {
                        if (!beanPropertyAccessor.hasSetter()) continue;
                        beanPropertyAccessor.setPropertyValue(this.bean, object);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public AutowiredContainer<Object> put(Object object) {
        this.put(object, object != null ? object.getClass() : null);
        return this;
    }

    @Override
    public AutowiredPropertyContainer put(String propertyname, Object value) {
        BeanPropertyAccessor<B> beanPropertyAccessor;
        if (propertyname != null && (beanPropertyAccessor = this.propertynameToBeanPropertyAccessorMap.get(propertyname)) != null && beanPropertyAccessor.hasSetter()) {
            beanPropertyAccessor.setPropertyValue(this.bean, value);
        }
        return this;
    }

    @Override
    public <O> Map<String, O> getPropertynameToValueMap(Class<O> type) {
        return this.getPropertynameToValueMapForArbitraryType(type);
    }

    protected <O> Map<String, O> getPropertynameToValueMapForArbitraryType(Class<?> type) {
        LinkedHashMap<String, Object> retmap = new LinkedHashMap<String, Object>();
        if (type != null) {
            for (Class<?> propertyType : this.propertyTypeToBeanPropertyAccessorSetMap.keySet()) {
                if (!type.isAssignableFrom(propertyType)) continue;
                Set<BeanPropertyAccessor<B>> beanPropertyAccessorSet = this.propertyTypeToBeanPropertyAccessorSetMap.get(propertyType);
                for (BeanPropertyAccessor<B> beanPropertyAccessor : beanPropertyAccessorSet) {
                    String propertyName = beanPropertyAccessor.getPropertyName();
                    Object propertyValue = beanPropertyAccessor.getPropertyValue(this.bean);
                    retmap.put(propertyName, propertyValue);
                }
            }
        }
        return retmap;
    }

    @Override
    public <O> Set<O> getValueSet(Class<? extends O> type) {
        return new LinkedHashSet<O>(this.getPropertynameToValueMap(type).values());
    }

    @Override
    public Iterator<Object> iterator() {
        return this.getPropertynameToValueMapForArbitraryType(Object.class).values().iterator();
    }

    @Override
    public AutowiredContainer<Object> removeAllHavingExactTypeOf(Class<? extends Object> type) {
        return this.put(null, type);
    }

    @Override
    public AutowiredContainer<Object> removeAllAssignableTo(Class<? extends Object> type) {
        return this.removeAllHavingExactTypeOf(type);
    }
}

