/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.copier;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.events.exception.basic.ExceptionHandlerIgnoring;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.map.MapUtils;
import org.omnaest.utils.tuple.Tuple2;

public class PreparedBeanCopier<FROM, TO>
implements Serializable {
    private static final long serialVersionUID = -7426881508083859649L;
    private static final ExceptionHandlerIgnoring DEFAULT_EXCEPTION_HANDLER = new ExceptionHandlerIgnoring();
    private static final BeanPropertyAccessor.PropertyAccessType DEFAULT_PROPERTY_ACCESS_TYPE = BeanPropertyAccessor.PropertyAccessType.PROPERTY;
    private final List<PreparedCopier> preparedCopierList;
    private ExceptionHandler exceptionHandler = DEFAULT_EXCEPTION_HANDLER;
    private final InstanceFactoryCreator.InstanceFactory instanceFactoryForRoot;
    private final Class<FROM> typeFrom;
    private BeanPropertyAccessor.PropertyAccessType propertyAccessTypeFrom = DEFAULT_PROPERTY_ACCESS_TYPE;
    private BeanPropertyAccessor.PropertyAccessType propertyAccessTypeTo = DEFAULT_PROPERTY_ACCESS_TYPE;
    private final Transformer transformer;
    private final List<String> nonMatchingPropertyNameList;

    public PreparedBeanCopier(Class<? extends FROM> typeFrom, Class<? extends TO> typeTo) {
        this(typeFrom, typeTo, new Configuration());
    }

    public PreparedBeanCopier(Class<? extends FROM> typeFrom, Class<? extends TO> typeTo, Configuration configuration) {
        this.typeFrom = typeFrom;
        ArrayList<String> nonMatchingPropertyNameList = new ArrayList<String>();
        final Configuration configurationOrDefault = ObjectUtils.defaultIfNull(configuration, new Configuration());
        this.preparedCopierList = PreparedBeanCopier.newPreparedCopierList(typeFrom, typeTo, configurationOrDefault, nonMatchingPropertyNameList);
        this.instanceFactoryForRoot = PreparedBeanCopier.newInstanceFactory(typeFrom, configurationOrDefault);
        this.nonMatchingPropertyNameList = ImmutableList.copyOf(nonMatchingPropertyNameList);
        this.transformer = new Transformer(){
            private static final long serialVersionUID = -4846406160190255627L;

            @Override
            public Object transform(Object instanceFrom) {
                Class<?> propertyTypeFrom;
                InstanceFactoryCreator.InstanceFactory instanceFactory;
                Object retval = null;
                if (instanceFrom != null && (instanceFactory = PreparedBeanCopier.newInstanceFactory(propertyTypeFrom = instanceFrom.getClass(), configurationOrDefault)) != null && (retval = instanceFactory.newReplacementInstance(propertyTypeFrom)) != null) {
                    if (retval != InstanceFactoryCreator.InstanceFactory.IMMUTABLE_INSTANCE) {
                        MetaDataHandler metaDataHandler;
                        Class<?> propertyTypeTo = retval.getClass();
                        CopierFactory.Copier copier = PreparedBeanCopier.newCopier(propertyTypeFrom, propertyTypeTo, configurationOrDefault, metaDataHandler = PreparedBeanCopier.newMetaDataHandler(PreparedBeanCopier.this.nonMatchingPropertyNameList));
                        if (copier != null) {
                            copier.copy(instanceFrom, retval, this);
                        }
                    } else {
                        retval = instanceFrom;
                    }
                }
                return retval;
            }
        };
    }

    private static <FROM, TO> List<PreparedCopier> newPreparedCopierList(Class<FROM> typeFrom, Class<TO> typeTo, Configuration configuration, List<String> nonMatchingPropertyNameList) {
        ArrayList<PreparedCopier> retlist = new ArrayList<PreparedCopier>();
        Map<String, BeanPropertyAccessor<FROM>> propertyNameToBeanPropertyAccessorMapFrom = BeanUtils.propertyNameToBeanPropertyAccessorMap(typeFrom);
        Map<String, BeanPropertyAccessor<TO>> propertyNameToBeanPropertyAccessorMapTo = BeanUtils.propertyNameToBeanPropertyAccessorMap(typeTo);
        Map<String, Tuple2<BeanPropertyAccessor<FROM>, BeanPropertyAccessor<TO>>> joinMapByPropertyName = MapUtils.innerJoinMapByKey(propertyNameToBeanPropertyAccessorMapFrom, propertyNameToBeanPropertyAccessorMapTo);
        nonMatchingPropertyNameList.addAll(SetUtils.delta(propertyNameToBeanPropertyAccessorMapFrom.keySet(), joinMapByPropertyName.keySet()).getRemovedElementSet());
        nonMatchingPropertyNameList.addAll(SetUtils.delta(propertyNameToBeanPropertyAccessorMapTo.keySet(), joinMapByPropertyName.keySet()).getRemovedElementSet());
        for (String propertyName : joinMapByPropertyName.keySet()) {
            Tuple2<BeanPropertyAccessor<FROM>, BeanPropertyAccessor<TO>> tuple = joinMapByPropertyName.get(propertyName);
            BeanPropertyAccessor<FROM> beanPropertyAccessorFrom = tuple.getValueFirst();
            BeanPropertyAccessor<TO> beanPropertyAccessorTo = tuple.getValueSecond();
            if (beanPropertyAccessorTo == null || beanPropertyAccessorFrom == null) continue;
            Class<?> propertyTypeFrom = beanPropertyAccessorFrom.getDeclaringPropertyType();
            Class<?> propertyTypeTo = beanPropertyAccessorTo.getDeclaringPropertyType();
            if (propertyTypeTo == null || propertyTypeFrom == null) continue;
            InstanceFactoryCreator.InstanceFactory instanceFactory = PreparedBeanCopier.newInstanceFactory(propertyTypeFrom, configuration);
            MetaDataHandler metaDataHandler = PreparedBeanCopier.newMetaDataHandler(nonMatchingPropertyNameList);
            CopierFactory.Copier copier = PreparedBeanCopier.newCopier(propertyTypeFrom, propertyTypeTo, configuration, metaDataHandler);
            if (instanceFactory == null) continue;
            retlist.add(new PreparedCopier(beanPropertyAccessorFrom, beanPropertyAccessorTo, instanceFactory, propertyTypeFrom, copier));
        }
        return ImmutableList.copyOf(retlist);
    }

    private static MetaDataHandler newMetaDataHandler(final List<String> nonMatchingPropertyNameList) {
        return new MetaDataHandler(){
            private static final long serialVersionUID = -2755016787172736785L;

            @Override
            public void reportNonMatchingPropertyNames(List<String> propertyNameList) {
                if (propertyNameList != null) {
                    nonMatchingPropertyNameList.addAll(propertyNameList);
                }
            }
        };
    }

    private static InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> propertyTypeFrom, Configuration configuration) {
        Map<Class<?>, Class<?>> typeFromToTypeToMap;
        InstanceFactoryCreator.InstanceFactory instanceHandler = null;
        ArrayList<InstanceFactoryCreator> instanceHandlerFactoryList = new ArrayList<InstanceFactoryCreator>(configuration.getInstanceHandlerFactoryList());
        if (configuration.isHandlingPrimitivesAndWrappers()) {
            instanceHandlerFactoryList.add(0, new InstanceFactoryCreatorForPrimitives());
            instanceHandlerFactoryList.add(1, new InstanceFactoryCreatorAndCopierFactoryForDate());
        }
        if (configuration.isHandlingLists()) {
            instanceHandlerFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForList());
        }
        if (configuration.isHandlingSets()) {
            instanceHandlerFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForSet());
        }
        if (configuration.isHandlingCollections()) {
            instanceHandlerFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForCollection());
        }
        if (configuration.isHandlingMaps()) {
            instanceHandlerFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForMap());
        }
        if (!(typeFromToTypeToMap = configuration.getTypeFromToTypeToMap()).isEmpty()) {
            instanceHandlerFactoryList.add(new InstanceFactoryCreatorForMappedTypes(typeFromToTypeToMap));
        }
        if (configuration.isHandlingArbitraryObjects()) {
            instanceHandlerFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForArbitraryObjects());
        }
        for (InstanceFactoryCreator instanceHandlerFactory : instanceHandlerFactoryList) {
            if (instanceHandlerFactory == null || !instanceHandlerFactory.isHandling(propertyTypeFrom)) continue;
            instanceHandler = instanceHandlerFactory.newInstanceFactory(propertyTypeFrom);
            break;
        }
        return instanceHandler;
    }

    private static CopierFactory.Copier newCopier(Class<?> propertyTypeFrom, Class<?> propertyTypeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
        CopierFactory.Copier copier = null;
        ArrayList<CopierFactory> copierFactoryList = new ArrayList<CopierFactory>(configuration.getCopierFactoryList());
        if (configuration.isHandlingPrimitivesAndWrappers()) {
            copierFactoryList.add(0, new InstanceFactoryCreatorAndCopierFactoryForDate());
        }
        if (configuration.isHandlingLists()) {
            copierFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForList());
        }
        if (configuration.isHandlingSets()) {
            copierFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForSet());
        }
        if (configuration.isHandlingCollections()) {
            copierFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForCollection());
        }
        if (configuration.isHandlingMaps()) {
            copierFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForMap());
        }
        if (configuration.isHandlingArbitraryObjects()) {
            copierFactoryList.add(new InstanceFactoryCreatorAndCopierFactoryForArbitraryObjects());
        }
        for (CopierFactory copierFactory : copierFactoryList) {
            if (copierFactory == null || !copierFactory.isHandling(propertyTypeFrom)) continue;
            copier = copierFactory.newCopier(propertyTypeFrom, propertyTypeTo, configuration, metaDataHandler);
            break;
        }
        return copier;
    }

    public TO deepCloneProperties(FROM instanceFrom) {
        Object instanceTo = this.instanceFactoryForRoot.newReplacementInstance(this.typeFrom);
        this.deepCopyProperties(instanceFrom, instanceTo);
        return (TO)instanceTo;
    }

    public PreparedBeanCopier<FROM, TO> deepCopyProperties(FROM instanceFrom, TO instanceTo) {
        for (PreparedCopier preparedCopier : this.preparedCopierList) {
            try {
                Object value;
                Object targetValue = value = preparedCopier.getPropertyValue(instanceFrom, this.propertyAccessTypeFrom, this.exceptionHandler);
                Object replacementInstance = preparedCopier.newReplacementInstance();
                if (replacementInstance != InstanceFactoryCreator.InstanceFactory.IMMUTABLE_INSTANCE) {
                    targetValue = replacementInstance;
                    preparedCopier.copy(value, targetValue, this.transformer);
                }
                preparedCopier.setPropertyValue(instanceTo, targetValue, this.propertyAccessTypeTo, this.exceptionHandler);
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
        }
        return this;
    }

    public PreparedBeanCopier<FROM, TO> setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = ObjectUtils.defaultIfNull(exceptionHandler, DEFAULT_EXCEPTION_HANDLER);
        return this;
    }

    public PreparedBeanCopier<FROM, TO> setPropertyAccessTypeFrom(BeanPropertyAccessor.PropertyAccessType propertyAccessTypeFrom) {
        this.propertyAccessTypeFrom = ObjectUtils.defaultIfNull(propertyAccessTypeFrom, DEFAULT_PROPERTY_ACCESS_TYPE);
        return this;
    }

    public PreparedBeanCopier<FROM, TO> setPropertyAccessTypeTo(BeanPropertyAccessor.PropertyAccessType propertyAccessTypeTo) {
        this.propertyAccessTypeTo = ObjectUtils.defaultIfNull(propertyAccessTypeTo, DEFAULT_PROPERTY_ACCESS_TYPE);
        return this;
    }

    public List<String> getNonMatchingPropertyNameList() {
        return Collections.unmodifiableList(this.nonMatchingPropertyNameList);
    }

    public boolean hasNonMatchingProperties() {
        return !this.nonMatchingPropertyNameList.isEmpty();
    }

    public PreparedBeanCopier<FROM, TO> throwExceptionWhenAnyPropertiesAreNotMatching() throws NonMatchingPropertyException {
        if (this.hasNonMatchingProperties()) {
            throw new NonMatchingPropertyException(this.getNonMatchingPropertyNameList());
        }
        return this;
    }

    public static class NonMatchingPropertyException
    extends Exception {
        private static final long serialVersionUID = 9045272214549608639L;
        private final List<String> nonMatchingPropertyNameList;

        public NonMatchingPropertyException(List<String> nonMatchingPropertyNameList) {
            super("Properties are not matching: " + nonMatchingPropertyNameList);
            this.nonMatchingPropertyNameList = nonMatchingPropertyNameList;
        }

        public List<String> getNonMatchingPropertyNameList() {
            return this.nonMatchingPropertyNameList;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NonMatchingPropertyException [nonMatchingPropertyNameList2=");
            builder.append(this.nonMatchingPropertyNameList);
            builder.append("]");
            return builder.toString();
        }
    }

    private static class InstanceFactoryCreatorAndCopierFactoryForMap
    implements InstanceFactoryCreator,
    CopierFactory {
        private static final long serialVersionUID = -5806518949904168961L;

        private InstanceFactoryCreatorAndCopierFactoryForMap() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return Map.class.isAssignableFrom(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return new InstanceFactoryCreator.InstanceFactory(){
                private static final long serialVersionUID = -2991059275809191118L;

                @Override
                public Object newReplacementInstance(Class<?> type) {
                    return new LinkedHashMap();
                }
            };
        }

        @Override
        public CopierFactory.Copier newCopier(Class<?> typeFrom, Class<?> typeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
            return new CopierFactory.Copier(){
                private static final long serialVersionUID = -122066676367014959L;

                @Override
                public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
                    if (instanceFrom instanceof Map && instanceTo instanceof Map) {
                        Map mapFrom = (Map)instanceFrom;
                        Map mapTo = (Map)instanceTo;
                        for (Object keyFrom : mapFrom.keySet()) {
                            Object valueFrom = mapFrom.get(keyFrom);
                            mapTo.put(transformer.transform(keyFrom), transformer.transform(valueFrom));
                        }
                    }
                }
            };
        }
    }

    private static class InstanceFactoryCreatorAndCopierFactoryForCollection
    implements InstanceFactoryCreator,
    CopierFactory {
        private static final long serialVersionUID = 218975866373111663L;

        private InstanceFactoryCreatorAndCopierFactoryForCollection() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return Collection.class.isAssignableFrom(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return new InstanceFactoryCreator.InstanceFactory(){
                private static final long serialVersionUID = 5411662705527963151L;

                @Override
                public Object newReplacementInstance(Class<?> type) {
                    return new ArrayList();
                }
            };
        }

        @Override
        public CopierFactory.Copier newCopier(Class<?> typeFrom, Class<?> typeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
            return new CopierFactory.Copier(){
                private static final long serialVersionUID = -4647789552559439022L;

                @Override
                public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
                    if (instanceFrom instanceof Collection && instanceTo instanceof Collection) {
                        Collection collectionFrom = (Collection)instanceFrom;
                        Collection collectionTo = (Collection)instanceTo;
                        for (Object element : collectionFrom) {
                            collectionTo.add(transformer.transform(element));
                        }
                    }
                }
            };
        }
    }

    private static class InstanceFactoryCreatorAndCopierFactoryForSet
    implements InstanceFactoryCreator,
    CopierFactory {
        private static final long serialVersionUID = 3615193483888509556L;

        private InstanceFactoryCreatorAndCopierFactoryForSet() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return Set.class.isAssignableFrom(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return new InstanceFactoryCreator.InstanceFactory(){
                private static final long serialVersionUID = 5411662705527963151L;

                @Override
                public Object newReplacementInstance(Class<?> type) {
                    return new LinkedHashSet();
                }
            };
        }

        @Override
        public CopierFactory.Copier newCopier(Class<?> typeFrom, Class<?> typeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
            return new CopierFactory.Copier(){
                private static final long serialVersionUID = -4647789552559439022L;

                @Override
                public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
                    if (instanceFrom instanceof Set && instanceTo instanceof Set) {
                        Set setFrom = (Set)instanceFrom;
                        Set setTo = (Set)instanceTo;
                        for (Object element : setFrom) {
                            setTo.add(transformer.transform(element));
                        }
                    }
                }
            };
        }
    }

    private static class InstanceFactoryCreatorAndCopierFactoryForList
    implements InstanceFactoryCreator,
    CopierFactory {
        private static final long serialVersionUID = 654229828154669671L;

        private InstanceFactoryCreatorAndCopierFactoryForList() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return List.class.isAssignableFrom(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return new InstanceFactoryCreator.InstanceFactory(){
                private static final long serialVersionUID = 312554307912581992L;

                @Override
                public Object newReplacementInstance(Class<?> type) {
                    return new ArrayList();
                }
            };
        }

        @Override
        public CopierFactory.Copier newCopier(Class<?> typeFrom, Class<?> typeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
            return new CopierFactory.Copier(){
                private static final long serialVersionUID = 7561447633309204450L;

                @Override
                public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
                    if (instanceFrom instanceof List && instanceTo instanceof List) {
                        List listFrom = (List)instanceFrom;
                        List listTo = (List)instanceTo;
                        for (Object element : listFrom) {
                            listTo.add(transformer.transform(element));
                        }
                    }
                }
            };
        }
    }

    private static class InstanceFactoryCreatorAndCopierFactoryForArbitraryObjects
    implements InstanceFactoryCreator,
    CopierFactory {
        private static final long serialVersionUID = -5948935042135374462L;

        private InstanceFactoryCreatorAndCopierFactoryForArbitraryObjects() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return !ObjectUtils.isPrimitiveOrPrimitiveWrapperType(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return new InstanceFactoryCreator.InstanceFactory(){
                private static final long serialVersionUID = -6795625336262144894L;

                @Override
                public Object newReplacementInstance(Class<?> type) {
                    return ReflectionUtils.newInstanceOf(type, new Object[0]);
                }
            };
        }

        @Override
        public CopierFactory.Copier newCopier(Class<?> typeFrom, Class<?> typeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
            final PreparedBeanCopier preparedBeanCopier = new PreparedBeanCopier(typeFrom, typeTo, configuration);
            metaDataHandler.reportNonMatchingPropertyNames(preparedBeanCopier.getNonMatchingPropertyNameList());
            return new CopierFactory.Copier(){
                private static final long serialVersionUID = -6415805520183068114L;

                @Override
                public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
                    preparedBeanCopier.deepCopyProperties(instanceFrom, instanceTo);
                }
            };
        }
    }

    private static class InstanceFactoryCreatorForMappedTypes
    implements InstanceFactoryCreator,
    InstanceFactoryCreator.InstanceFactory {
        private static final long serialVersionUID = -1621806923021530179L;
        private final Map<Class<?>, Class<?>> typeFromToTypeToMap;

        public InstanceFactoryCreatorForMappedTypes(Map<Class<?>, Class<?>> typeFromToTypeToMap) {
            this.typeFromToTypeToMap = typeFromToTypeToMap;
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return this.typeFromToTypeToMap.containsKey(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return this;
        }

        @Override
        public Object newReplacementInstance(Class<?> type) {
            return ReflectionUtils.newInstanceOf(this.typeFromToTypeToMap.get(type), new Object[0]);
        }
    }

    private static class InstanceFactoryCreatorAndCopierFactoryForDate
    implements InstanceFactoryCreator,
    InstanceFactoryCreator.InstanceFactory,
    CopierFactory {
        private static final long serialVersionUID = -8024424149443680755L;

        private InstanceFactoryCreatorAndCopierFactoryForDate() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return Date.class.equals(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return this;
        }

        @Override
        public Object newReplacementInstance(Class<?> type) {
            return new Date();
        }

        @Override
        public CopierFactory.Copier newCopier(Class<?> typeFrom, Class<?> typeTo, Configuration configuration, MetaDataHandler metaDataHandler) {
            return new CopierFactory.Copier(){
                private static final long serialVersionUID = 858420964408231399L;

                @Override
                public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
                    Date dateFrom = (Date)instanceFrom;
                    Date dateTo = (Date)instanceTo;
                    dateTo.setTime(dateFrom.getTime());
                }
            };
        }
    }

    private static class InstanceFactoryCreatorForPrimitives
    implements InstanceFactoryCreator,
    InstanceFactoryCreator.InstanceFactory {
        private static final long serialVersionUID = -8024424149443680755L;

        private InstanceFactoryCreatorForPrimitives() {
        }

        @Override
        public boolean isHandling(Class<?> type) {
            return ObjectUtils.isPrimitiveOrPrimitiveWrapperType(type) || String.class.equals(type);
        }

        @Override
        public InstanceFactoryCreator.InstanceFactory newInstanceFactory(Class<?> type) {
            return this;
        }

        @Override
        public Object newReplacementInstance(Class<?> type) {
            return IMMUTABLE_INSTANCE;
        }
    }

    public static interface Transformer
    extends Serializable {
        public Object transform(Object var1);
    }

    public static interface MetaDataHandler
    extends Serializable {
        public void reportNonMatchingPropertyNames(List<String> var1);
    }

    public static interface CopierFactory
    extends Serializable {
        public boolean isHandling(Class<?> var1);

        public Copier newCopier(Class<?> var1, Class<?> var2, Configuration var3, MetaDataHandler var4);

        public static interface Copier
        extends Serializable {
            public void copy(Object var1, Object var2, Transformer var3);
        }
    }

    public static interface InstanceFactoryCreator
    extends Serializable {
        public boolean isHandling(Class<?> var1);

        public InstanceFactory newInstanceFactory(Class<?> var1);

        public static interface InstanceFactory
        extends Serializable {
            public static final Object IMMUTABLE_INSTANCE = new Object();

            public Object newReplacementInstance(Class<?> var1);
        }
    }

    private static class PreparedCopier
    implements Serializable {
        private static final long serialVersionUID = 9014411875272403900L;
        private final BeanPropertyAccessor<Object> beanPropertyAccessorFrom;
        private final BeanPropertyAccessor<Object> beanPropertyAccessorTo;
        private final InstanceFactoryCreator.InstanceFactory instanceFactory;
        private final Class<?> type;
        private final CopierFactory.Copier copier;

        public PreparedCopier(BeanPropertyAccessor<? extends Object> beanPropertyAccessorFrom, BeanPropertyAccessor<? extends Object> beanPropertyAccessorTo, InstanceFactoryCreator.InstanceFactory instanceFactory, Class<?> type, CopierFactory.Copier copier) {
            this.copier = copier;
            this.beanPropertyAccessorFrom = beanPropertyAccessorFrom;
            this.beanPropertyAccessorTo = beanPropertyAccessorTo;
            this.instanceFactory = instanceFactory;
            this.type = type;
        }

        public Object getPropertyValue(Object bean, BeanPropertyAccessor.PropertyAccessType propertyAccessType, ExceptionHandler exceptionHandler) {
            return this.beanPropertyAccessorFrom.getPropertyValue(bean, propertyAccessType, exceptionHandler);
        }

        public boolean setPropertyValue(Object bean, Object value, BeanPropertyAccessor.PropertyAccessType propertyAccessType, ExceptionHandler exceptionHandler) {
            return this.beanPropertyAccessorTo.setPropertyValue(bean, value, propertyAccessType, exceptionHandler);
        }

        public Object newReplacementInstance() {
            return this.instanceFactory.newReplacementInstance(this.type);
        }

        public void copy(Object instanceFrom, Object instanceTo, Transformer transformer) {
            if (this.copier != null) {
                this.copier.copy(instanceFrom, instanceTo, transformer);
            }
        }
    }

    public static class Configuration
    implements Serializable {
        private static final long serialVersionUID = 5361292993967280460L;
        private final List<InstanceFactoryCreator> instanceFactoryCreatorList = new ArrayList<InstanceFactoryCreator>();
        private final List<CopierFactory> copierFactoryList = new ArrayList<CopierFactory>();
        private Map<Class<?>, Class<?>> typeFromToTypeToMap = ImmutableMap.of();
        private boolean isHandlingPrimitivesAndWrappers = true;
        private boolean isHandlingLists = true;
        private boolean isHandlingSets = true;
        private boolean isHandlingCollections = true;
        private boolean isHandlingMaps = true;
        private boolean isHandlingArbitraryObjects = true;

        public Configuration add(InstanceFactoryCreator instanceFactoryCreator) {
            this.instanceFactoryCreatorList.add(instanceFactoryCreator);
            return this;
        }

        public Configuration add(int index, InstanceFactoryCreator instanceFactoryCreator) {
            this.instanceFactoryCreatorList.add(index, instanceFactoryCreator);
            return this;
        }

        public Configuration add(CopierFactory copierFactory) {
            this.copierFactoryList.add(copierFactory);
            return this;
        }

        public Configuration add(int index, CopierFactory copierFactory) {
            this.copierFactoryList.add(index, copierFactory);
            return this;
        }

        public List<InstanceFactoryCreator> getInstanceHandlerFactoryList() {
            return Collections.unmodifiableList(this.instanceFactoryCreatorList);
        }

        public List<CopierFactory> getCopierFactoryList() {
            return Collections.unmodifiableList(this.copierFactoryList);
        }

        public Configuration setHandlingPrimitivesAndWrappers(boolean isHandlingPrimitivesAndWrappers) {
            this.isHandlingPrimitivesAndWrappers = isHandlingPrimitivesAndWrappers;
            return this;
        }

        public Configuration setHandlingArbitraryObjects(boolean isHandlingArbitraryObjects) {
            this.isHandlingArbitraryObjects = isHandlingArbitraryObjects;
            return this;
        }

        public boolean isHandlingPrimitivesAndWrappers() {
            return this.isHandlingPrimitivesAndWrappers;
        }

        public boolean isHandlingArbitraryObjects() {
            return this.isHandlingArbitraryObjects;
        }

        public boolean isHandlingLists() {
            return this.isHandlingLists;
        }

        public Configuration setHandlingLists(boolean isHandlingLists) {
            this.isHandlingLists = isHandlingLists;
            return this;
        }

        public Configuration addTypeToTypeMapping(Class<?> typeFrom, Class<?> typeTo) {
            this.typeFromToTypeToMap = ImmutableMap.builder().putAll(this.typeFromToTypeToMap).put(typeFrom, typeTo).build();
            return this;
        }

        public Configuration addBidirectionalTypeToTypeMapping(Class<?> type1, Class<?> type2) {
            this.addTypeToTypeMapping(type1, type2);
            this.addTypeToTypeMapping(type2, type1);
            return this;
        }

        public Configuration addTypeToTypeMapping(Map<? extends Class<?>, ? extends Class<?>> typeFromToTypeToMap) {
            this.typeFromToTypeToMap = ImmutableMap.builder().putAll(this.typeFromToTypeToMap).putAll(typeFromToTypeToMap).build();
            return this;
        }

        public Configuration addBidirectionalTypeToTypeMapping(Map<? extends Class<?>, ? extends Class<?>> typeFromToTypeToMap) {
            this.addTypeToTypeMapping(typeFromToTypeToMap);
            this.addTypeToTypeMapping(MapUtils.invertedBidirectionalMap(typeFromToTypeToMap));
            return this;
        }

        public Map<Class<?>, Class<?>> getTypeFromToTypeToMap() {
            return this.typeFromToTypeToMap;
        }

        public boolean isHandlingSets() {
            return this.isHandlingSets;
        }

        public Configuration setHandlingSets(boolean isHandlingSets) {
            this.isHandlingSets = isHandlingSets;
            return this;
        }

        public boolean isHandlingMaps() {
            return this.isHandlingMaps;
        }

        public Configuration setHandlingMaps(boolean isHandlingMaps) {
            this.isHandlingMaps = isHandlingMaps;
            return this;
        }

        public boolean isHandlingCollections() {
            return this.isHandlingCollections;
        }

        public Configuration setHandlingCollections(boolean isHandlingCollections) {
            this.isHandlingCollections = isHandlingCollections;
            return this;
        }
    }
}

