/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.mapconverter;

import java.util.Map;
import org.omnaest.utils.beans.mapconverter.internal.BeanToNestedMapMarshaller;
import org.omnaest.utils.beans.mapconverter.internal.BeanToNestedMapUnMarshaller;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;

public class BeanToNestedMapConverter<B> {
    private static final BeanPropertyAccessor.PropertyAccessType DEFAULT_PROPERTYACCESSTYPE = BeanPropertyAccessor.PropertyAccessType.PROPERTY;
    private static final BeanConversionFilterExcludingJavaBaseClass DEFAULT_BEAN_CONVERSION_FILTER = new BeanConversionFilterExcludingJavaBaseClass();
    private final BeanToNestedMapMarshaller beanToNestedMapMarshaller;
    private final BeanToNestedMapUnMarshaller<B> beanToNestedMapUnMarshaller;
    private final BeanConversionFilter beanConversionFilter;
    private final BeanPropertyAccessor.PropertyAccessType propertyAccessType;

    public BeanToNestedMapConverter(Class<? extends B> beanClass) {
        this(DEFAULT_BEAN_CONVERSION_FILTER, beanClass, DEFAULT_PROPERTYACCESSTYPE, null);
    }

    public BeanToNestedMapConverter(BeanConversionFilter beanConversionFilter, Class<? extends B> beanClass) {
        this(beanConversionFilter, beanClass, DEFAULT_PROPERTYACCESSTYPE, null);
    }

    public BeanToNestedMapConverter(BeanConversionFilter beanConversionFilter, Class<? extends B> beanClass, BeanPropertyAccessor.PropertyAccessType propertyAccessType) {
        this(beanConversionFilter, beanClass, propertyAccessType, null);
    }

    public BeanToNestedMapConverter(BeanConversionFilter beanConversionFilter, Class<? extends B> beanClass, Map<Class<?>, Class<?>> sourceTypeTodestinationTypeMap) {
        this(beanConversionFilter, beanClass, DEFAULT_PROPERTYACCESSTYPE, sourceTypeTodestinationTypeMap);
    }

    public BeanToNestedMapConverter(BeanConversionFilter beanConversionFilter, Class<? extends B> beanClass, BeanPropertyAccessor.PropertyAccessType propertyAccessType, Map<Class<?>, Class<?>> sourceTypeTodestinationTypeMap) {
        this.beanConversionFilter = beanConversionFilter != null ? beanConversionFilter : DEFAULT_BEAN_CONVERSION_FILTER;
        this.propertyAccessType = propertyAccessType != null ? propertyAccessType : DEFAULT_PROPERTYACCESSTYPE;
        this.beanToNestedMapMarshaller = new BeanToNestedMapMarshaller(this.beanConversionFilter);
        this.beanToNestedMapUnMarshaller = new BeanToNestedMapUnMarshaller<B>(beanClass, sourceTypeTodestinationTypeMap);
    }

    public Map<String, Object> marshal(B bean) {
        return this.beanToNestedMapMarshaller.marshal(bean, this.propertyAccessType);
    }

    public B unmarshal(Map<String, Object> map) {
        return this.beanToNestedMapUnMarshaller.unmarshal(map, this.propertyAccessType);
    }

    public B clone(B bean) {
        return this.unmarshal(this.marshal(bean));
    }

    public static class BeanConversionFilterExcludingJavaBaseClass
    implements BeanConversionFilter {
        @Override
        public boolean hasBeanToBeConverted(Class<?> declaringType, Object bean) {
            return bean != null && !bean.getClass().getCanonicalName().startsWith("java");
        }
    }

    public static class BeanConversionFilterExcludingDeclaringJavaBaseClass
    implements BeanConversionFilter {
        @Override
        public boolean hasBeanToBeConverted(Class<?> declaringType, Object bean) {
            return bean != null && !bean.getClass().getCanonicalName().startsWith("java");
        }
    }

    public static class BeanConversionFilterExcludingPrimitiveAndString
    implements BeanConversionFilter {
        @Override
        public boolean hasBeanToBeConverted(Class<?> declaringType, Object bean) {
            return !(bean instanceof Byte) && !(bean instanceof Short) && !(bean instanceof Integer) && !(bean instanceof Long) && !(bean instanceof Float) && !(bean instanceof Double) && !(bean instanceof Boolean) && !(bean instanceof String);
        }
    }

    public static interface BeanConversionFilter {
        public boolean hasBeanToBeConverted(Class<?> var1, Object var2);
    }
}

