/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.beans.mapconverter.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.mapconverter.BeanToNestedMapConverter;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;

public class BeanToNestedMapMarshaller {
    public static final String CLASS_IDENTIFIER = "clazz";
    public static final String MAP_KEY_IDENTIFIER = "key";
    public static final String MAP_VALUE_IDENTIFIER = "value";
    private BeanToNestedMapConverter.BeanConversionFilter beanConversionFilter = null;
    private Map<Object, Map<String, Object>> objectToMapMap = new IdentityHashMap<Object, Map<String, Object>>();

    public BeanToNestedMapMarshaller(BeanToNestedMapConverter.BeanConversionFilter beanConversionFilter) {
        this.beanConversionFilter = beanConversionFilter;
    }

    public Map<String, Object> marshal(Object bean, BeanPropertyAccessor.PropertyAccessType propertyAccessType) {
        final HashMap<String, Object> retmap = new HashMap<String, Object>();
        final BeanPropertyAccessor.PropertyAccessType propertyAccessTypeFinal = propertyAccessType != null ? propertyAccessType : BeanPropertyAccessor.PropertyAccessType.PROPERTY;
        final class Helper {
            Helper() {
            }

            public void convertIfNecessaryAndPutToRetmap(Class<?> declaringPropertyType, Object object, String propertyName) {
                boolean hasToConvertBean = this.hasToConvertBean(declaringPropertyType, object);
                if (hasToConvertBean) {
                    Map<String, Object> map = BeanToNestedMapMarshaller.this.marshal(object, propertyAccessTypeFinal);
                    BeanToNestedMapMarshaller.this.objectToMapMap.put(object, map);
                    retmap.put(propertyName, map);
                } else {
                    retmap.put(propertyName, object);
                }
            }

            private boolean hasToConvertBean(Class<?> declaringType, Object bean) {
                return BeanToNestedMapMarshaller.this.beanConversionFilter != null && BeanToNestedMapMarshaller.this.beanConversionFilter.hasBeanToBeConverted(declaringType, bean);
            }
        }
        Helper helper = new Helper();
        if (bean != null) {
            if (this.objectToMapMap.containsKey(bean)) {
                return this.objectToMapMap.get(bean);
            }
            if (bean instanceof Collection) {
                int counter = 0;
                for (Object object : (Collection)bean) {
                    Class<?> declaringPropertyType = object != null ? object.getClass() : null;
                    String propertyName = "" + counter++;
                    helper.convertIfNecessaryAndPutToRetmap(declaringPropertyType, object, propertyName);
                }
                retmap.put(CLASS_IDENTIFIER, bean.getClass().getName());
            } else if (bean instanceof Map) {
                int counter = 0;
                for (Map.Entry entry : ((Map)bean).entrySet()) {
                    Object key = entry.getKey();
                    Class<?> declaringPropertyType = key != null ? key.getClass() : null;
                    String propertyName = counter + MAP_KEY_IDENTIFIER;
                    helper.convertIfNecessaryAndPutToRetmap(declaringPropertyType, key, propertyName);
                    Object value = entry.getValue();
                    declaringPropertyType = value != null ? value.getClass() : null;
                    propertyName = counter + MAP_VALUE_IDENTIFIER;
                    helper.convertIfNecessaryAndPutToRetmap(declaringPropertyType, value, propertyName);
                    ++counter;
                }
                retmap.put(CLASS_IDENTIFIER, bean.getClass().getName());
            } else {
                Map<String, BeanPropertyAccessor<?>> propertyNameToBeanPropertyAccessorMap = BeanUtils.propertyNameToBeanPropertyAccessorMap(bean.getClass());
                for (String propertyName : propertyNameToBeanPropertyAccessorMap.keySet()) {
                    BeanPropertyAccessor<?> beanPropertyAccessor = propertyNameToBeanPropertyAccessorMap.get(propertyName).newBeanPropertyAccessorWithPropertyAccessType(propertyAccessType);
                    if (!beanPropertyAccessor.isReadable()) continue;
                    Object object = beanPropertyAccessor.getPropertyValue(bean);
                    Class<?> declaringPropertyType = beanPropertyAccessor.getDeclaringPropertyType();
                    helper.convertIfNecessaryAndPutToRetmap(declaringPropertyType, object, propertyName);
                }
                retmap.put(CLASS_IDENTIFIER, bean.getClass().getName());
            }
        }
        return retmap;
    }
}

